/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.ImproveWayAccuracyHelper;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImproveWayAccuracyAction
extends MapMode
implements MapViewPaintable,
SelectionChangedListener,
AWTEventListener {
    private State state;
    private MapView mv;
    private static final long serialVersionUID = 42L;
    private Way targetWay;
    private Node candidateNode = null;
    private WaySegment candidateSegment = null;
    private Point mousePos = null;
    private boolean dragging = false;
    private final Cursor cursorSelect = ImageProvider.getCursor("normal", "mode");
    private final Cursor cursorSelectHover = ImageProvider.getCursor("hand", "mode");
    private final Cursor cursorImprove = ImageProvider.getCursor("crosshair", null);
    private final Cursor cursorImproveAdd = ImageProvider.getCursor("crosshair", "addnode");
    private final Cursor cursorImproveDelete = ImageProvider.getCursor("crosshair", "delete_node");
    private final Cursor cursorImproveAddLock = ImageProvider.getCursor("crosshair", "add_node_lock");
    private final Cursor cursorImproveLock = ImageProvider.getCursor("crosshair", "lock");
    private final Color guideColor = PaintColors.HIGHLIGHT.get();
    private final BasicStroke selectTargetWayStroke = new BasicStroke(2.0f, 1, 1);
    private final BasicStroke moveNodeStroke;
    private final BasicStroke addNodeStroke;
    private final BasicStroke deleteNodeStroke;
    private boolean selectionChangedBlocked = false;
    protected String oldModeHelpText;

    public ImproveWayAccuracyAction(MapFrame mapFrame) {
        super(I18n.tr("Improve Way Accuracy", new Object[0]), "improvewayaccuracy.png", I18n.tr("Improve Way Accuracy mode", new Object[0]), Shortcut.registerShortcut("mapmode:ImproveWayAccuracy", I18n.tr("Mode: {0}", I18n.tr("Improve Way Accuracy", new Object[0])), 87, 5003), mapFrame, Cursor.getPredefinedCursor(0));
        float[] fArray = new float[]{4.0f};
        this.moveNodeStroke = new BasicStroke(1.0f, 0, 0, 10.0f, fArray, 0.0f);
        this.addNodeStroke = new BasicStroke(1.0f, 0, 0);
        this.deleteNodeStroke = new BasicStroke(1.0f, 0, 0);
    }

    @Override
    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.mv = Main.map.mapView;
        this.mousePos = null;
        this.oldModeHelpText = "";
        if (ImproveWayAccuracyAction.getCurrentDataSet() == null) {
            return;
        }
        this.updateStateByCurrentSelection();
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        Main.map.mapView.addTemporaryLayer(this);
        DataSet.addSelectionListener(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
        DataSet.removeSelectionListener(this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Main.map.mapView.repaint();
    }

    @Override
    protected void updateStatusLine() {
        String string = this.getModeHelpText();
        if (!string.equals(this.oldModeHelpText)) {
            this.oldModeHelpText = string;
            Main.map.statusLine.setHelpText(string);
            Main.map.statusLine.repaint();
        }
    }

    @Override
    public String getModeHelpText() {
        if (this.state == State.selecting) {
            if (this.targetWay != null) {
                return I18n.tr("Click on the way to start improving its shape.", new Object[0]);
            }
            return I18n.tr("Select a way that you want to make more accurate.", new Object[0]);
        }
        if (this.ctrl) {
            return I18n.tr("Click to add a new node. Release Ctrl to move existing nodes or hold Alt to delete.", new Object[0]);
        }
        if (this.alt) {
            return I18n.tr("Click to delete the highlighted node. Release Alt to move existing nodes or hold Ctrl to add new nodes.", new Object[0]);
        }
        return I18n.tr("Click to move the highlighted node. Hold Ctrl to add new nodes, or Alt to delete.", new Object[0]);
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(ImproveWayAccuracyAction.getEditLayer() != null);
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        if (this.mousePos == null) {
            return;
        }
        graphics2D.setColor(this.guideColor);
        if (this.state == State.selecting && this.targetWay != null) {
            graphics2D.setStroke(this.selectTargetWayStroke);
            List<Node> list = this.targetWay.getNodes();
            GeneralPath generalPath = new GeneralPath();
            Point point = mapView.getPoint(list.get(0));
            generalPath.moveTo(point.x, point.y);
            for (Node node : list) {
                Point point2 = mapView.getPoint(node);
                generalPath.lineTo(point2.x, point2.y);
            }
            if (this.targetWay.isClosed()) {
                generalPath.lineTo(point.x, point.y);
            }
            graphics2D.draw(generalPath);
        } else if (this.state == State.improving) {
            List<Node> list;
            Point point = null;
            Point point3 = null;
            if (this.ctrl && this.candidateSegment != null) {
                graphics2D.setStroke(this.addNodeStroke);
                point = mapView.getPoint(this.candidateSegment.getFirstNode());
                point3 = mapView.getPoint(this.candidateSegment.getSecondNode());
            } else if (!this.alt && !this.ctrl && this.candidateNode != null) {
                graphics2D.setStroke(this.moveNodeStroke);
                list = this.targetWay.getNodePairs(false);
                for (Pair pair : list) {
                    if (pair.a == this.candidateNode) {
                        point = mapView.getPoint((Node)pair.b);
                    }
                    if (pair.b == this.candidateNode) {
                        point3 = mapView.getPoint((Node)pair.a);
                    }
                    if (point == null || point3 == null) continue;
                    break;
                }
            } else if (this.alt && !this.ctrl && this.candidateNode != null) {
                graphics2D.setStroke(this.deleteNodeStroke);
                list = this.targetWay.getNodes();
                int n = list.indexOf(this.candidateNode);
                if (n != 0 && n != list.size() - 1) {
                    point = mapView.getPoint(list.get(n - 1));
                    point3 = mapView.getPoint(list.get(n + 1));
                }
            }
            list = new GeneralPath();
            if (this.alt && !this.ctrl) {
                if (point != null && point3 != null) {
                    ((Path2D.Float)((Object)list)).moveTo(point.x, point.y);
                    ((Path2D.Float)((Object)list)).lineTo(point3.x, point3.y);
                }
            } else {
                if (point != null) {
                    ((Path2D.Float)((Object)list)).moveTo(this.mousePos.x, this.mousePos.y);
                    ((Path2D.Float)((Object)list)).lineTo(point.x, point.y);
                }
                if (point3 != null) {
                    ((Path2D.Float)((Object)list)).moveTo(this.mousePos.x, this.mousePos.y);
                    ((Path2D.Float)((Object)list)).lineTo(point3.x, point3.y);
                }
            }
            graphics2D.draw((Shape)((Object)list));
            if (this.candidateNode != null) {
                point = mapView.getPoint(this.candidateNode);
                graphics2D.fillRect(point.x - 2, point.y - 2, 6, 6);
            }
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (Main.map == null || Main.map.mapView == null || !Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiers((InputEvent)aWTEvent);
        this.updateCursorDependentObjectsIfNeeded();
        this.updateCursor();
        this.updateStatusLine();
        Main.map.mapView.repaint();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (this.selectionChangedBlocked) {
            return;
        }
        this.updateStateByCurrentSelection();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.dragging = true;
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.mousePos = mouseEvent.getPoint();
        this.updateKeyModifiers(mouseEvent);
        this.updateCursorDependentObjectsIfNeeded();
        this.updateCursor();
        this.updateStatusLine();
        Main.map.mapView.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragging = false;
        if (!this.isEnabled() || mouseEvent.getButton() != 1) {
            return;
        }
        this.updateKeyModifiers(mouseEvent);
        this.mousePos = mouseEvent.getPoint();
        if (this.state == State.selecting) {
            if (this.targetWay != null) {
                ImproveWayAccuracyAction.getCurrentDataSet().setSelected(this.targetWay.getPrimitiveId());
                this.updateStateByCurrentSelection();
            }
        } else if (this.state == State.improving && this.mousePos != null) {
            if (this.mv.getLatLon(this.mousePos.x, this.mousePos.y).isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot place a node outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            if (this.ctrl && !this.alt && this.candidateSegment != null) {
                Object object;
                LinkedList<Command> linkedList = new LinkedList<Command>();
                Node node = new Node(this.mv.getEastNorth(this.mousePos.x, this.mousePos.y));
                linkedList.add(new AddCommand(node));
                List<Way> list = OsmPrimitive.getFilteredList(this.candidateSegment.getFirstNode().getReferrers(), Way.class);
                List<Way> list2 = OsmPrimitive.getFilteredList(this.candidateSegment.getFirstNode().getReferrers(), Way.class);
                LinkedList<WaySegment> linkedList2 = new LinkedList<WaySegment>();
                for (Way object2 : list) {
                    object = object2.getNodePairs(true);
                    for (Way way : list2) {
                        if (!object2.equals(way)) continue;
                        int n = -1;
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            Pair pair = (Pair)iterator.next();
                            ++n;
                            if ((!((Node)pair.a).equals(this.candidateSegment.getFirstNode()) || !((Node)pair.b).equals(this.candidateSegment.getSecondNode())) && (!((Node)pair.b).equals(this.candidateSegment.getFirstNode()) || !((Node)pair.a).equals(this.candidateSegment.getSecondNode()))) continue;
                            linkedList2.add(new WaySegment(object2, n));
                        }
                    }
                }
                for (WaySegment waySegment : linkedList2) {
                    object = waySegment.way;
                    Way way = new Way((Way)object);
                    way.addNode(waySegment.lowerIndex + 1, node);
                    linkedList.add(new ChangeCommand((OsmPrimitive)object, way));
                }
                String string = I18n.trn("Add and a new node to way", "Add and a new node to {0} ways", linkedList2.size(), linkedList2.size());
                Main.main.undoRedo.add(new SequenceCommand(string, linkedList));
            } else if (this.alt && !this.ctrl && this.candidateNode != null) {
                Object object;
                Iterator<String> iterator = this.candidateNode.getKeys().keySet().iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (OsmPrimitive.isUninterestingKey((String)object)) continue;
                    bl = true;
                    break;
                }
                object = this.candidateNode.getReferrers();
                List<Way> list = OsmPrimitive.getFilteredList((Collection<OsmPrimitive>)object, Way.class);
                if (object.size() != 1 || list.size() != 1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot delete node that is referenced by multiple objects", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                } else if (bl) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot delete node that has tags", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                } else {
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    arrayList.add(this.candidateNode);
                    Command command = DeleteCommand.delete(ImproveWayAccuracyAction.getEditLayer(), arrayList, true);
                    Main.main.undoRedo.add(command);
                }
            } else if (this.candidateNode != null) {
                EastNorth eastNorth = this.candidateNode.getEastNorth();
                EastNorth eastNorth2 = this.mv.getEastNorth(this.mousePos.x, this.mousePos.y);
                Main.main.undoRedo.add(new MoveCommand(this.candidateNode, eastNorth2.east() - eastNorth.east(), eastNorth2.north() - eastNorth.north()));
            }
        }
        this.mousePos = null;
        this.updateCursor();
        this.updateStatusLine();
        Main.map.mapView.repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.dragging) {
            this.mousePos = null;
        }
        Main.map.mapView.repaint();
    }

    private void updateCursor() {
        if (!this.isEnabled()) {
            this.mv.setNewCursor(null, (Object)this);
            return;
        }
        if (this.state == State.selecting) {
            this.mv.setNewCursor(this.targetWay == null ? this.cursorSelect : this.cursorSelectHover, (Object)this);
        } else if (this.state == State.improving) {
            if (this.alt && !this.ctrl) {
                this.mv.setNewCursor(this.cursorImproveDelete, (Object)this);
            } else if (this.shift || this.dragging) {
                if (this.ctrl) {
                    this.mv.setNewCursor(this.cursorImproveAddLock, (Object)this);
                } else {
                    this.mv.setNewCursor(this.cursorImproveLock, (Object)this);
                }
            } else if (this.ctrl && !this.alt) {
                this.mv.setNewCursor(this.cursorImproveAdd, (Object)this);
            } else {
                this.mv.setNewCursor(this.cursorImprove, (Object)this);
            }
        }
    }

    public void updateCursorDependentObjectsIfNeeded() {
        if (this.state == State.improving && (this.shift || this.dragging) && (this.candidateNode != null || this.candidateSegment != null)) {
            return;
        }
        if (this.mousePos == null) {
            this.candidateNode = null;
            this.candidateSegment = null;
            return;
        }
        if (this.state == State.selecting) {
            this.targetWay = ImproveWayAccuracyHelper.findWay(this.mv, this.mousePos);
        } else if (this.state == State.improving) {
            if (this.ctrl && !this.alt) {
                this.candidateSegment = ImproveWayAccuracyHelper.findCandidateSegment(this.mv, this.targetWay, this.mousePos);
                this.candidateNode = null;
            } else {
                this.candidateNode = ImproveWayAccuracyHelper.findCandidateNode(this.mv, this.targetWay, this.mousePos);
                this.candidateSegment = null;
            }
        }
    }

    public void startSelecting() {
        this.state = State.selecting;
        this.targetWay = null;
        if (ImproveWayAccuracyAction.getCurrentDataSet() != null) {
            ImproveWayAccuracyAction.getCurrentDataSet().clearSelection();
        }
        this.mv.repaint();
        this.updateStatusLine();
    }

    public void startImproving(Way way) {
        this.state = State.improving;
        List list = (List)ImproveWayAccuracyAction.getCurrentDataSet().getSelected();
        if (list.size() != 1 || !((OsmPrimitive)list.get(0)).equals(way)) {
            this.selectionChangedBlocked = true;
            ImproveWayAccuracyAction.getCurrentDataSet().clearSelection();
            ImproveWayAccuracyAction.getCurrentDataSet().setSelected(way.getPrimitiveId());
            this.selectionChangedBlocked = false;
        }
        this.targetWay = way;
        this.candidateNode = null;
        this.candidateSegment = null;
        this.mv.repaint();
        this.updateStatusLine();
    }

    private void updateStateByCurrentSelection() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        Collection<OsmPrimitive> collection = ImproveWayAccuracyAction.getCurrentDataSet().getSelected();
        Object object = collection.iterator();
        while (object.hasNext()) {
            OsmPrimitive osmPrimitive = object.next();
            if (osmPrimitive instanceof Way) {
                arrayList2.add((Way)osmPrimitive);
            }
            if (!(osmPrimitive instanceof Node)) continue;
            arrayList.add((Node)osmPrimitive);
        }
        if (arrayList2.size() == 1) {
            this.startImproving((Way)arrayList2.get(0));
            return;
        }
        if (arrayList.size() > 0 && arrayList.size() == 1 && (object = ((Node)arrayList.get(0)).getReferrers()).size() == 1 && object.get(0) instanceof Way) {
            this.startImproving((Way)object.get(0));
            return;
        }
        this.startSelecting();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        selecting,
        improving;

    }
}

