/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.xml.XmlStyleSource;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPaintStyles {
    private static ElemStyles styles = new ElemStyles();
    protected static final CopyOnWriteArrayList<MapPaintSylesUpdateListener> listeners = new CopyOnWriteArrayList();

    public static ElemStyles getStyles() {
        return styles;
    }

    public static ImageIcon getIcon(IconReference iconReference, int n, int n2) {
        String string = iconReference.source.getPrefName();
        ImageIcon imageIcon = new ImageProvider(iconReference.iconName).setDirs(MapPaintStyles.getIconSourceDirs(iconReference.source)).setId("mappaint." + string).setArchive(iconReference.source.zipIcons).setWidth(n).setHeight(n2).setOptional(true).get();
        if (imageIcon == null) {
            System.out.println("Mappaint style \"" + string + "\" (" + iconReference.source.getDisplayString() + ") icon \"" + iconReference.iconName + "\" not found.");
            return null;
        }
        return imageIcon;
    }

    public static ImageIcon getNoIcon_Icon(StyleSource styleSource) {
        return new ImageProvider("misc/no_icon.png").setDirs(MapPaintStyles.getIconSourceDirs(styleSource)).setId("mappaint." + styleSource.getPrefName()).setArchive(styleSource.zipIcons).setOptional(true).get();
    }

    public static List<String> getIconSourceDirs(StyleSource styleSource) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = styleSource.getLocalSourceDir();
        if (string != null) {
            linkedList.add(string);
        }
        Collection<String> collection = Main.pref.getCollection("mappaint.icon.sources");
        for (String string2 : collection) {
            String[] stringArray = string2.indexOf("=") >= 0 ? string2.split("=", 2) : new String[]{"", string2};
            if (stringArray[0].length() != 0 && !styleSource.getPrefName().equals(stringArray[0])) continue;
            linkedList.add(stringArray[1]);
        }
        if (Main.pref.getBoolean("mappaint.icon.enable-defaults", true)) {
            linkedList.add("resource://images/styles/standard/");
            linkedList.add("resource://images/styles/");
        }
        return linkedList;
    }

    public static void readFromPreferences() {
        Object object;
        styles.clear();
        List<SourceEntry> list = MapPaintPreference.MapPaintPrefHelper.INSTANCE.get();
        for (SourceEntry sourceEntry : list) {
            object = MapPaintStyles.fromSourceEntry(sourceEntry);
            if (object == null) continue;
            styles.add((StyleSource)object);
        }
        for (StyleSource styleSource : styles.getStyleSources()) {
            styleSource.loadStyleSource();
            if (!Main.pref.getBoolean("mappaint.auto_reload_local_styles", true) || !styleSource.isLocal()) continue;
            object = new File(styleSource.url);
            styleSource.setLastMTime(((File)object).lastModified());
        }
        MapPaintStyles.fireMapPaintSylesUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StyleSource fromSourceEntry(SourceEntry sourceEntry) {
        MirroredInputStream mirroredInputStream = null;
        try {
            mirroredInputStream = new MirroredInputStream(sourceEntry.url);
            InputStream inputStream = mirroredInputStream.getZipEntry("xml", "style");
            if (inputStream != null) {
                XmlStyleSource xmlStyleSource = new XmlStyleSource(sourceEntry);
                return xmlStyleSource;
            }
            inputStream = mirroredInputStream.getZipEntry("mapcss", "style");
            if (inputStream != null) {
                MapCSSStyleSource mapCSSStyleSource = new MapCSSStyleSource(sourceEntry);
                return mapCSSStyleSource;
            }
            if (sourceEntry.url.toLowerCase().endsWith(".mapcss")) {
                MapCSSStyleSource mapCSSStyleSource = new MapCSSStyleSource(sourceEntry);
                return mapCSSStyleSource;
            }
            if (sourceEntry.url.toLowerCase().endsWith(".xml")) {
                XmlStyleSource xmlStyleSource = new XmlStyleSource(sourceEntry);
                return xmlStyleSource;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(mirroredInputStream);
            block34: while (true) {
                int n = inputStreamReader.read();
                switch (n) {
                    case -1: {
                        break block34;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        continue block34;
                    }
                    case 60: {
                        XmlStyleSource xmlStyleSource = new XmlStyleSource(sourceEntry);
                        return xmlStyleSource;
                    }
                    default: {
                        MapCSSStyleSource mapCSSStyleSource = new MapCSSStyleSource(sourceEntry);
                        return mapCSSStyleSource;
                    }
                }
                break;
            }
            System.err.println("Warning: Could not detect style type. Using default (xml).");
            XmlStyleSource xmlStyleSource = new XmlStyleSource(sourceEntry);
            return xmlStyleSource;
        }
        catch (IOException iOException) {
            System.err.println(I18n.tr("Warning: failed to load Mappaint styles from ''{0}''. Exception was: {1}", sourceEntry.url, iOException.toString()));
            iOException.printStackTrace();
            return null;
        }
        finally {
            try {
                if (mirroredInputStream != null) {
                    mirroredInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void reloadStyles(int ... nArray) {
        ArrayList<StyleSource> arrayList = new ArrayList<StyleSource>();
        List<StyleSource> list = styles.getStyleSources();
        for (int n : nArray) {
            arrayList.add(list.get(n));
        }
        Main.worker.submit(new MapPaintStyleLoader(arrayList));
    }

    public static void moveStyles(int[] nArray, int n) {
        if (!MapPaintStyles.canMoveStyles(nArray, n)) {
            return;
        }
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Arrays.sort(nArray2);
        ArrayList<StyleSource> arrayList = new ArrayList<StyleSource>(styles.getStyleSources());
        for (int n2 : nArray2) {
            StyleSource styleSource = (StyleSource)arrayList.get(n2);
            StyleSource styleSource2 = (StyleSource)arrayList.get(n2 + n);
            arrayList.set(n2, styleSource2);
            arrayList.set(n2 + n, styleSource);
        }
        styles.setStyleSources(arrayList);
        MapPaintPreference.MapPaintPrefHelper.INSTANCE.put(arrayList);
        MapPaintStyles.fireMapPaintSylesUpdated();
        styles.clearCached();
        Main.map.mapView.repaint();
    }

    public static boolean canMoveStyles(int[] nArray, int n) {
        if (nArray.length == 0) {
            return false;
        }
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Arrays.sort(nArray2);
        if (n < 0) {
            return nArray2[0] >= -n;
        }
        if (n > 0) {
            return nArray2[nArray2.length - 1] <= styles.getStyleSources().size() - 1 - n;
        }
        return true;
    }

    public static void toggleStyleActive(int ... nArray) {
        List<StyleSource> list = styles.getStyleSources();
        for (int n : nArray) {
            StyleSource styleSource = list.get(n);
            styleSource.active = !styleSource.active;
        }
        MapPaintPreference.MapPaintPrefHelper.INSTANCE.put(list);
        if (nArray.length == 1) {
            MapPaintStyles.fireMapPaintStyleEntryUpdated(nArray[0]);
        } else {
            MapPaintStyles.fireMapPaintSylesUpdated();
        }
        styles.clearCached();
        Main.map.mapView.repaint();
    }

    public static void addStyle(SourceEntry sourceEntry) {
        StyleSource styleSource = MapPaintStyles.fromSourceEntry(sourceEntry);
        if (styleSource != null) {
            styles.add(styleSource);
            styleSource.loadStyleSource();
            MapPaintPreference.MapPaintPrefHelper.INSTANCE.put(styles.getStyleSources());
            MapPaintStyles.fireMapPaintSylesUpdated();
            styles.clearCached();
            Main.map.mapView.repaint();
        }
    }

    public static void addMapPaintSylesUpdateListener(MapPaintSylesUpdateListener mapPaintSylesUpdateListener) {
        if (mapPaintSylesUpdateListener != null) {
            listeners.addIfAbsent(mapPaintSylesUpdateListener);
        }
    }

    public static void removeMapPaintSylesUpdateListener(MapPaintSylesUpdateListener mapPaintSylesUpdateListener) {
        listeners.remove(mapPaintSylesUpdateListener);
    }

    public static void fireMapPaintSylesUpdated() {
        for (MapPaintSylesUpdateListener mapPaintSylesUpdateListener : listeners) {
            mapPaintSylesUpdateListener.mapPaintStylesUpdated();
        }
    }

    public static void fireMapPaintStyleEntryUpdated(int n) {
        for (MapPaintSylesUpdateListener mapPaintSylesUpdateListener : listeners) {
            mapPaintSylesUpdateListener.mapPaintStyleEntryUpdated(n);
        }
    }

    public static interface MapPaintSylesUpdateListener {
        public void mapPaintStylesUpdated();

        public void mapPaintStyleEntryUpdated(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapPaintStyleLoader
    extends PleaseWaitRunnable {
        private boolean canceled;
        private List<StyleSource> sources;

        public MapPaintStyleLoader(List<StyleSource> list) {
            super(I18n.tr("Reloading style sources", new Object[0]));
            this.sources = list;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MapPaintStyles.fireMapPaintSylesUpdated();
                    styles.clearCached();
                    Main.map.mapView.preferenceChanged(null);
                    Main.map.mapView.repaint();
                }
            });
        }

        @Override
        protected void realRun() {
            ProgressMonitor progressMonitor = this.getProgressMonitor();
            progressMonitor.setTicksCount(this.sources.size());
            for (StyleSource styleSource : this.sources) {
                if (this.canceled) {
                    return;
                }
                progressMonitor.subTask(I18n.tr("loading style ''{0}''...", styleSource.getDisplayString()));
                styleSource.loadStyleSource();
                progressMonitor.worked(1);
            }
        }
    }

    public static class IconReference {
        public final String iconName;
        public final StyleSource source;

        public IconReference(String string, StyleSource styleSource) {
            this.iconName = string;
            this.source = styleSource;
        }

        public String toString() {
            return "IconReference{iconName='" + this.iconName + "' source='" + this.source.getDisplayString() + "'}";
        }
    }

    public static class TagKeyReference {
        public final String key;

        public TagKeyReference(String string) {
            this.key = string;
        }

        public String toString() {
            return "TagKeyReference{key='" + this.key + "'}";
        }
    }
}

