/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmBzip2Importer;
import org.openstreetmap.josm.io.OsmChangeReader;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmServerLocationReader
extends OsmServerReader {
    protected final String url;

    public OsmServerLocationReader(String string) {
        this.url = string;
    }

    protected final <T> T doParse(Parser<T> parser, ProgressMonitor progressMonitor) throws OsmTransferException {
        T t;
        progressMonitor.beginTask(I18n.tr("Contacting Server...", 10));
        try {
            t = parser.parse();
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                T t2 = null;
                return t2;
            }
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
            try {
                this.activeConnection = null;
                if (parser.in != null) {
                    parser.in.close();
                    parser.in = null;
                }
            }
            catch (Exception exception) {}
        }
        return t;
    }

    @Override
    public DataSet parseOsm(final ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.doParse(new Parser<DataSet>(){

            @Override
            public DataSet parse() throws OsmTransferException, IllegalDataException {
                this.in = OsmServerLocationReader.this.getInputStreamRaw(OsmServerLocationReader.this.url, progressMonitor.createSubTaskMonitor(9, false));
                if (this.in == null) {
                    return null;
                }
                progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
                return OsmReader.parseDataSet(this.in, progressMonitor.createSubTaskMonitor(1, false));
            }
        }, progressMonitor);
    }

    @Override
    public DataSet parseOsmBzip2(final ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.doParse(new Parser<DataSet>(){

            @Override
            public DataSet parse() throws OsmTransferException, IllegalDataException, IOException {
                this.in = OsmServerLocationReader.this.getInputStreamRaw(OsmServerLocationReader.this.url, progressMonitor.createSubTaskMonitor(9, false));
                if (this.in == null) {
                    return null;
                }
                CBZip2InputStream cBZip2InputStream = OsmBzip2Importer.getBZip2InputStream(this.in);
                progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
                return OsmReader.parseDataSet(cBZip2InputStream, progressMonitor.createSubTaskMonitor(1, false));
            }
        }, progressMonitor);
    }

    @Override
    public DataSet parseOsmChange(final ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.doParse(new Parser<DataSet>(){

            @Override
            public DataSet parse() throws OsmTransferException, IllegalDataException {
                this.in = OsmServerLocationReader.this.getInputStreamRaw(OsmServerLocationReader.this.url, progressMonitor.createSubTaskMonitor(9, false));
                if (this.in == null) {
                    return null;
                }
                progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
                return OsmChangeReader.parseDataSet(this.in, progressMonitor.createSubTaskMonitor(1, false));
            }
        }, progressMonitor);
    }

    @Override
    public GpxData parseRawGps(final ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.doParse(new Parser<GpxData>(){

            @Override
            public GpxData parse() throws OsmTransferException, IllegalDataException, IOException, SAXException {
                this.in = OsmServerLocationReader.this.getInputStreamRaw(OsmServerLocationReader.this.url, progressMonitor.createSubTaskMonitor(1, true));
                if (this.in == null) {
                    return null;
                }
                progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
                GpxReader gpxReader = new GpxReader(this.in);
                gpxReader.parse(false);
                GpxData gpxData = gpxReader.data;
                gpxData.fromServer = true;
                return gpxData;
            }
        }, progressMonitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class Parser<T> {
        public InputStream in = null;

        protected Parser() {
        }

        public abstract T parse() throws OsmTransferException, IllegalDataException, IOException, SAXException;
    }
}

