/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.Icon;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinateConflictResolveCommand
extends ConflictResolveCommand {
    private Conflict<? extends OsmPrimitive> conflict;
    private final MergeDecisionType decision;

    public CoordinateConflictResolveCommand(Conflict<? extends OsmPrimitive> conflict, MergeDecisionType mergeDecisionType) {
        this.conflict = conflict;
        this.decision = mergeDecisionType;
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Resolve conflicts in coordinates in {0}", this.conflict.getMy().getId());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        if (!this.decision.equals((Object)MergeDecisionType.KEEP_MINE)) {
            if (this.decision.equals((Object)MergeDecisionType.KEEP_THEIR)) {
                Node node = (Node)this.conflict.getMy();
                Node node2 = (Node)this.conflict.getTheir();
                node.setCoor(node2.getCoor());
            } else {
                throw new IllegalStateException(I18n.tr("Cannot resolve undecided conflict.", new Object[0]));
            }
        }
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.conflict.getMy());
    }
}

