/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.datum.AbstractDatum;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShift;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileWrapper;

public class NTV2Datum
extends AbstractDatum {
    protected NTV2GridShiftFileWrapper nadgrids;

    public NTV2Datum(String string, String string2, Ellipsoid ellipsoid, NTV2GridShiftFileWrapper nTV2GridShiftFileWrapper) {
        super(string, string2, ellipsoid);
        this.nadgrids = nTV2GridShiftFileWrapper;
    }

    public LatLon toWGS84(LatLon latLon) {
        NTV2GridShift nTV2GridShift = new NTV2GridShift(latLon);
        this.nadgrids.getShiftFile().gridShiftForward(nTV2GridShift);
        return new LatLon(latLon.lat() + nTV2GridShift.getLatShiftDegrees(), latLon.lon() + nTV2GridShift.getLonShiftPositiveEastDegrees());
    }

    public LatLon fromWGS84(LatLon latLon) {
        NTV2GridShift nTV2GridShift = new NTV2GridShift(latLon);
        this.nadgrids.getShiftFile().gridShiftReverse(nTV2GridShift);
        return new LatLon(latLon.lat() + nTV2GridShift.getLatShiftDegrees(), latLon.lon() + nTV2GridShift.getLonShiftPositiveEastDegrees());
    }
}

