/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.ValUtil;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossingWays
extends Test {
    protected static final int CROSSING_WAYS = 601;
    Map<Point2D, List<ExtendedSegment>> cellSegments;
    HashSet<WaySegment> errorSegments;
    Map<List<Way>, List<WaySegment>> ways_seen;

    public CrossingWays() {
        super(I18n.tr("Crossing ways", new Object[0]), I18n.tr("This test checks if two roads, railways, waterways or buildings crosses in the same layer, but are not connected by a node.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.cellSegments = new HashMap<Point2D, List<ExtendedSegment>>(1000);
        this.errorSegments = new HashSet();
        this.ways_seen = new HashMap<List<Way>, List<WaySegment>>(50);
    }

    @Override
    public void endTest() {
        super.endTest();
        this.cellSegments = null;
        this.errorSegments = null;
        this.ways_seen = null;
    }

    @Override
    public void visit(Way way) {
        if (!way.isUsable()) {
            return;
        }
        String string = way.get("natural");
        String string2 = way.get("landuse");
        boolean bl = "water".equals(string) || "coastline".equals(string) || "reservoir".equals(string2);
        String string3 = way.get("railway");
        boolean bl2 = "subway".equals(string3);
        boolean bl3 = "tram".equals(string3);
        boolean bl4 = CrossingWays.isBuilding(way);
        String string4 = way.get("waterway");
        if (way.get("highway") == null && way.get("waterway") == null && (string3 == null || bl2 || bl3) && !bl && !bl4) {
            return;
        }
        String string5 = way.get("layer");
        if ("0".equals(string5)) {
            string5 = null;
        }
        int n = way.getNodesCount();
        for (int i = 0; i < n - 1; ++i) {
            WaySegment waySegment = new WaySegment(way, i);
            ExtendedSegment extendedSegment = new ExtendedSegment(waySegment, string5, string3, bl, string4);
            List<List<ExtendedSegment>> list = this.getSegments(extendedSegment.n1, extendedSegment.n2);
            for (List<ExtendedSegment> list2 : list) {
                for (ExtendedSegment extendedSegment2 : list2) {
                    if (this.errorSegments.contains(waySegment) && this.errorSegments.contains(extendedSegment2.ws)) continue;
                    String string6 = extendedSegment2.layer;
                    String string7 = extendedSegment2.railway;
                    boolean bl5 = extendedSegment2.coastline;
                    if (string5 != null ? !string5.equals(string6) : string6 != null) continue;
                    if (!extendedSegment.intersects(extendedSegment2) || bl2 && "subway".equals(string7) || bl3 && "tram".equals(string7) || bl != bl5 || "river".equals(string4) && "riverbank".equals(extendedSegment2.waterway) || "riverbank".equals(string4) && "river".equals(extendedSegment2.waterway) || extendedSegment.railway != null && extendedSegment.railway.equals("abandoned") || string7 != null && string7.equals("abandoned")) continue;
                    List<Way> list3 = Arrays.asList(extendedSegment.ws.way, extendedSegment2.ws.way);
                    List<WaySegment> list4 = this.ways_seen.get(list3);
                    if (list4 == null) {
                        list4 = new ArrayList<WaySegment>();
                        list4.add(extendedSegment.ws);
                        list4.add(extendedSegment2.ws);
                        String string8 = bl4 ? I18n.tr("Crossing buildings", new Object[0]) : (extendedSegment.waterway != null && extendedSegment2.ws.way.get("highway") != null || extendedSegment2.waterway != null && extendedSegment.ws.way.get("highway") != null ? I18n.tr("Crossing waterway/highway", new Object[0]) : I18n.tr("Crossing ways", new Object[0]));
                        this.errors.add(new TestError(this, Severity.WARNING, string8, 601, list3, list4));
                        this.ways_seen.put(list3, list4);
                        continue;
                    }
                    list4.add(extendedSegment.ws);
                    list4.add(extendedSegment2.ws);
                }
                list2.add(extendedSegment);
            }
        }
    }

    public List<List<ExtendedSegment>> getSegments(Node node, Node node2) {
        ArrayList<List<ExtendedSegment>> arrayList = new ArrayList<List<ExtendedSegment>>();
        for (Point2D point2D : ValUtil.getSegmentCells(node, node2, OsmValidator.griddetail)) {
            List<ExtendedSegment> list = this.cellSegments.get(point2D);
            if (list == null) {
                list = new ArrayList<ExtendedSegment>();
                this.cellSegments.put(point2D, list);
            }
            arrayList.add(list);
        }
        return arrayList;
    }

    public static class ExtendedSegment {
        public Node n1;
        public Node n2;
        public WaySegment ws;
        public String layer;
        public String railway;
        public String waterway;
        public boolean coastline;

        public ExtendedSegment(WaySegment waySegment, String string, String string2, boolean bl, String string3) {
            this.ws = waySegment;
            this.n1 = waySegment.way.getNodes().get(waySegment.lowerIndex);
            this.n2 = waySegment.way.getNodes().get(waySegment.lowerIndex + 1);
            this.layer = string;
            this.railway = string2;
            this.coastline = bl;
            this.waterway = string3;
        }

        public boolean intersects(ExtendedSegment extendedSegment) {
            if (this.n1.equals(extendedSegment.n1) || this.n2.equals(extendedSegment.n2) || this.n1.equals(extendedSegment.n2) || this.n2.equals(extendedSegment.n1)) {
                return false;
            }
            return Line2D.linesIntersect(this.n1.getEastNorth().east(), this.n1.getEastNorth().north(), this.n2.getEastNorth().east(), this.n2.getEastNorth().north(), extendedSegment.n1.getEastNorth().east(), extendedSegment.n1.getEastNorth().north(), extendedSegment.n2.getEastNorth().east(), extendedSegment.n2.getEastNorth().north());
        }
    }
}

