/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.awt.Font;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.LabelCompositionStrategy;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class TextElement
implements StyleKeys {
    public static final LabelCompositionStrategy AUTO_LABEL_COMPOSITION_STRATEGY = new LabelCompositionStrategy.DeriveLabelFromNameTagsCompositionStrategy();
    public LabelCompositionStrategy labelCompositionStrategy;
    public Font font;
    public int xOffset;
    public int yOffset;
    public Color color;
    public Float haloRadius;
    public Color haloColor;

    public TextElement(LabelCompositionStrategy labelCompositionStrategy, Font font, int n, int n2, Color color, Float f, Color color2) {
        CheckParameterUtil.ensureParameterNotNull(font);
        CheckParameterUtil.ensureParameterNotNull(color);
        this.labelCompositionStrategy = labelCompositionStrategy;
        this.font = font;
        this.xOffset = n;
        this.yOffset = n2;
        this.color = color;
        this.haloRadius = f;
        this.haloColor = color2;
    }

    public TextElement(TextElement textElement) {
        this.labelCompositionStrategy = textElement.labelCompositionStrategy;
        this.font = textElement.font;
        this.xOffset = textElement.xOffset;
        this.yOffset = textElement.yOffset;
        this.color = textElement.color;
        this.haloColor = textElement.haloColor;
        this.haloRadius = textElement.haloRadius;
    }

    protected static LabelCompositionStrategy buildLabelCompositionStrategy(Cascade cascade, boolean bl) {
        MapPaintStyles.TagKeyReference tagKeyReference = cascade.get("text", null, MapPaintStyles.TagKeyReference.class, true);
        if (tagKeyReference != null) {
            return new LabelCompositionStrategy.TagLookupCompositionStrategy(tagKeyReference.key);
        }
        Keyword keyword = cascade.get("text", null, Keyword.class, true);
        if (Utils.equal(keyword, Keyword.AUTO)) {
            return AUTO_LABEL_COMPOSITION_STRATEGY;
        }
        String string = cascade.get("text", null, String.class, true);
        if (string != null) {
            return new LabelCompositionStrategy.StaticLabelCompositionStrategy(string);
        }
        return bl ? AUTO_LABEL_COMPOSITION_STRATEGY : null;
    }

    public static TextElement create(Cascade cascade, Color color, boolean bl) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(color);
        LabelCompositionStrategy labelCompositionStrategy = TextElement.buildLabelCompositionStrategy(cascade, bl);
        if (labelCompositionStrategy == null) {
            return null;
        }
        Font font = ElemStyle.getFont(cascade);
        float f = 0.0f;
        float f2 = 0.0f;
        float[] fArray = cascade.get("text-offset", null, float[].class);
        if (fArray != null) {
            if (fArray.length == 1) {
                f2 = fArray[0];
            } else if (fArray.length >= 2) {
                f = fArray[0];
                f2 = fArray[1];
            }
        }
        f = cascade.get("text-offset-x", Float.valueOf(f), Float.class).floatValue();
        f2 = cascade.get("text-offset-y", Float.valueOf(f2), Float.class).floatValue();
        Color color2 = cascade.get("text-color", color, Color.class);
        float f3 = cascade.get("text-opacity", Float.valueOf(1.0f), Float.class).floatValue();
        color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), Utils.color_float2int(Float.valueOf(f3)));
        Float f4 = cascade.get("text-halo-radius", null, Float.class);
        if (f4 != null && f4.floatValue() <= 0.0f) {
            f4 = null;
        }
        Color color3 = null;
        if (f4 != null) {
            color3 = cascade.get("text-halo-color", Utils.complement(color2), Color.class);
            float f5 = cascade.get("text-halo-opacity", Float.valueOf(1.0f), Float.class).floatValue();
            color3 = new Color(color3.getRed(), color3.getGreen(), color3.getBlue(), Utils.color_float2int(Float.valueOf(f5)));
        }
        return new TextElement(labelCompositionStrategy, font, (int)f, -((int)f2), color2, f4, color3);
    }

    public String getString(OsmPrimitive osmPrimitive) {
        if (this.labelCompositionStrategy == null) {
            return null;
        }
        return this.labelCompositionStrategy.compose(osmPrimitive);
    }

    public String toString() {
        return "TextElement{" + this.toStringImpl() + '}';
    }

    protected String toStringImpl() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("labelCompositionStrategy=" + this.labelCompositionStrategy);
        stringBuilder.append(" font=" + this.font);
        if (this.xOffset != 0) {
            stringBuilder.append(" xOffset=" + this.xOffset);
        }
        if (this.yOffset != 0) {
            stringBuilder.append(" yOffset=" + this.yOffset);
        }
        stringBuilder.append(" color=" + Utils.toString(this.color));
        if (this.haloRadius != null) {
            stringBuilder.append(" haloRadius=" + this.haloRadius);
            stringBuilder.append(" haloColor=" + this.haloColor);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 3;
        n = 79 * n + (this.labelCompositionStrategy != null ? this.labelCompositionStrategy.hashCode() : 0);
        n = 79 * n + this.font.hashCode();
        n = 79 * n + this.xOffset;
        n = 79 * n + this.yOffset;
        n = 79 * n + this.color.hashCode();
        n = 79 * n + (this.haloRadius != null ? Float.floatToIntBits(this.haloRadius.floatValue()) : 0);
        n = 79 * n + (this.haloColor != null ? this.haloColor.hashCode() : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TextElement textElement = (TextElement)object;
        return Utils.equal(this.labelCompositionStrategy, textElement.labelCompositionStrategy) && Utils.equal(this.font, textElement.font) && this.xOffset == textElement.xOffset && this.yOffset == textElement.yOffset && Utils.equal(this.color, textElement.color) && Utils.equal(this.haloRadius, textElement.haloRadius) && Utils.equal(this.haloColor, textElement.haloColor);
    }
}

