/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class GpxImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("gpx,gpx.gz", "gpx", I18n.tr("GPX Files", new Object[0]) + " (*.gpx *.gpx.gz)");

    public GpxImporter() {
        super(FILE_FILTER);
    }

    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        InputStream inputStream = file.getName().endsWith(".gpx.gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
        String string = file.getName();
        final GpxImporterData gpxImporterData = this.loadLayers(inputStream, file, string, I18n.tr("Markers from {0}", string), progressMonitor);
        GuiHelper.runInEDT(new Runnable(){

            public void run() {
                if (gpxImporterData.markerLayer != null) {
                    Main.main.addLayer(gpxImporterData.markerLayer);
                }
                if (gpxImporterData.gpxLayer != null) {
                    Main.main.addLayer(gpxImporterData.gpxLayer);
                }
                gpxImporterData.postLayerTask.run();
            }
        });
    }

    public GpxImporterData loadLayers(InputStream inputStream, final File file, final String string, String string2, ProgressMonitor progressMonitor) throws IOException {
        final GpxImporterData gpxImporterData = new GpxImporterData();
        try {
            GpxReader gpxReader = new GpxReader(inputStream);
            final boolean bl = gpxReader.parse(true);
            gpxReader.data.storageFile = file;
            if (gpxReader.data.hasRoutePoints() || gpxReader.data.hasTrackPoints()) {
                gpxImporterData.gpxLayer = new GpxLayer(gpxReader.data, string, file != null);
            }
            if (Main.pref.getBoolean("marker.makeautomarkers", true) && !gpxReader.data.waypoints.isEmpty()) {
                gpxImporterData.markerLayer = new MarkerLayer(gpxReader.data, string2, file, gpxImporterData.gpxLayer, false);
                if (gpxImporterData.markerLayer.data.size() == 0) {
                    gpxImporterData.markerLayer = null;
                }
            }
            gpxImporterData.postLayerTask = new Runnable(){

                public void run() {
                    if (gpxImporterData.markerLayer != null) {
                        gpxImporterData.markerLayer.addMouseHandler();
                    }
                    if (!bl) {
                        String string2 = file == null ? I18n.tr("Error occurred while parsing gpx data for layer ''{0}''. Only a part of the file will be available.", string) : I18n.tr("Error occurred while parsing gpx file ''{0}''. Only a part of the file will be available.", file.getPath());
                        JOptionPane.showMessageDialog(null, string2);
                    }
                }
            };
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new IOException(I18n.tr("Parsing data for layer ''{0}'' failed", string));
        }
        return gpxImporterData;
    }

    protected static class GpxImporterData {
        public GpxLayer gpxLayer;
        public MarkerLayer markerLayer;
        public Runnable postLayerTask;

        protected GpxImporterData() {
        }
    }
}

