/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadOsmTask
extends AbstractDownloadTask {
    protected Bounds currentBounds;
    protected DataSet downloadedData;
    protected DownloadTask downloadTask;
    protected OsmDataLayer targetLayer;
    protected String newLayerName = null;

    protected void rememberDownloadedData(DataSet dataSet) {
        this.downloadedData = dataSet;
    }

    public DataSet getDownloadedData() {
        return this.downloadedData;
    }

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        return this.download(new BoundingBoxDownloader(bounds), bl, bounds, progressMonitor);
    }

    public Future<?> download(OsmServerReader osmServerReader, boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        return this.download(new DownloadTask(bl, osmServerReader, progressMonitor), bounds);
    }

    protected Future<?> download(DownloadTask downloadTask, Bounds bounds) {
        this.downloadTask = downloadTask;
        this.currentBounds = new Bounds(bounds);
        return Main.worker.submit(downloadTask);
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(bl, new OsmServerLocationReader(string), progressMonitor);
        this.currentBounds = null;
        this.extractOsmFilename("https?://.*/(.*\\.osm)", string);
        return Main.worker.submit(this.downloadTask);
    }

    protected final void extractOsmFilename(String string, String string2) {
        Matcher matcher = Pattern.compile(string).matcher(string2);
        this.newLayerName = matcher.matches() ? matcher.group(1) : null;
    }

    @Override
    public boolean acceptsUrl(String string) {
        return string != null && (string.matches("http://.*/api/0.6/(map|nodes?|ways?|relations?|\\*).*") || string.matches("http://.*/interpreter\\?data=.*") || string.matches("http://.*/xapi\\?.*\\[@meta\\].*") || string.matches("https?://.*/.*\\.osm"));
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    protected class DownloadTask
    extends PleaseWaitRunnable {
        protected OsmServerReader reader;
        protected DataSet dataSet;
        protected boolean newLayer;

        public DownloadTask(boolean bl, OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading data", new Object[0]), progressMonitor, false);
            this.reader = osmServerReader;
            this.newLayer = bl;
        }

        protected DataSet parseDataSet() throws OsmTransferException {
            return this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
        }

        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadOsmTask.this.isCanceled()) {
                    return;
                }
                this.dataSet = this.parseDataSet();
            }
            catch (Exception exception) {
                if (DownloadOsmTask.this.isCanceled()) {
                    System.out.println(I18n.tr("Ignoring exception because download has been canceled. Exception was: {0}", exception.toString()));
                    return;
                }
                if (exception instanceof OsmTransferCanceledException) {
                    DownloadOsmTask.this.setCanceled(true);
                    return;
                }
                if (exception instanceof OsmTransferException) {
                    DownloadOsmTask.this.rememberException(exception);
                } else {
                    DownloadOsmTask.this.rememberException(new OsmTransferException(exception));
                }
                DownloadOsmTask.this.setFailed(true);
            }
        }

        protected OsmDataLayer getEditLayer() {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            return Main.map.mapView.getEditLayer();
        }

        protected int getNumDataLayers() {
            int n = 0;
            if (!Main.isDisplayingMapView()) {
                return 0;
            }
            Collection<Layer> collection = Main.map.mapView.getAllLayers();
            for (Layer layer : collection) {
                if (!(layer instanceof OsmDataLayer)) continue;
                ++n;
            }
            return n;
        }

        protected OsmDataLayer getFirstDataLayer() {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            List<Layer> list = Main.map.mapView.getAllLayersAsList();
            for (Layer layer : list) {
                if (!(layer instanceof OsmDataLayer)) continue;
                return (OsmDataLayer)layer;
            }
            return null;
        }

        protected OsmDataLayer createNewLayer(String string) {
            if (string == null || string.isEmpty()) {
                string = OsmDataLayer.createNewName();
            }
            return new OsmDataLayer(this.dataSet, string, null);
        }

        protected OsmDataLayer createNewLayer() {
            return this.createNewLayer(null);
        }

        protected void finish() {
            if (DownloadOsmTask.this.isFailed() || DownloadOsmTask.this.isCanceled()) {
                return;
            }
            if (this.dataSet == null) {
                return;
            }
            if (this.dataSet.allPrimitives().isEmpty()) {
                DownloadOsmTask.this.rememberErrorMessage(I18n.tr("No data found in this area.", new Object[0]));
                this.dataSet.dataSources.add(new DataSource(DownloadOsmTask.this.currentBounds != null ? DownloadOsmTask.this.currentBounds : new Bounds(new LatLon(0.0, 0.0)), "OpenStreetMap server"));
            }
            DownloadOsmTask.this.rememberDownloadedData(this.dataSet);
            int n = this.getNumDataLayers();
            if (this.newLayer || n == 0 || n > 1 && this.getEditLayer() == null) {
                DownloadOsmTask.this.targetLayer = this.createNewLayer(DownloadOsmTask.this.newLayerName);
                boolean bl = Main.isDisplayingMapView();
                Main.main.addLayer(DownloadOsmTask.this.targetLayer);
                if (bl) {
                    this.computeBboxAndCenterScale();
                }
            } else {
                DownloadOsmTask.this.targetLayer = this.getEditLayer();
                if (DownloadOsmTask.this.targetLayer == null) {
                    DownloadOsmTask.this.targetLayer = this.getFirstDataLayer();
                }
                DownloadOsmTask.this.targetLayer.mergeFrom(this.dataSet);
                this.computeBboxAndCenterScale();
                DownloadOsmTask.this.targetLayer.onPostDownloadFromServer();
            }
            this.suggestImageryLayers();
        }

        protected void computeBboxAndCenterScale() {
            BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
            if (DownloadOsmTask.this.currentBounds != null) {
                boundingXYVisitor.visit(DownloadOsmTask.this.currentBounds);
            } else {
                boundingXYVisitor.computeBoundingBox(this.dataSet.getNodes());
            }
            Main.map.mapView.recalculateCenterScale(boundingXYVisitor);
        }

        protected void cancel() {
            DownloadOsmTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }

        protected void suggestImageryLayers() {
            if (DownloadOsmTask.this.currentBounds != null) {
                LatLon latLon = DownloadOsmTask.this.currentBounds.getCenter();
                HashSet<ImageryInfo> hashSet = new HashSet<ImageryInfo>();
                for (ImageryInfo list : ImageryLayerInfo.instance.getDefaultLayers()) {
                    if (list.getBounds() == null || !list.getBounds().contains(latLon)) continue;
                    hashSet.add(list);
                }
                hashSet.removeAll(ImageryLayerInfo.instance.getLayers());
                Object object = hashSet.iterator();
                while (object.hasNext()) {
                    List<Shape> list = object.next().getBounds().getShapes();
                    if (list == null || list.isEmpty()) continue;
                    boolean bl = false;
                    Iterator<Shape> iterator = list.iterator();
                    while (iterator.hasNext() && !bl) {
                        bl = iterator.next().contains(latLon);
                    }
                    if (bl) continue;
                    object.remove();
                }
                if (hashSet.isEmpty()) {
                    return;
                }
                object = new ArrayList();
                for (ImageryInfo imageryInfo : hashSet) {
                    object.add(imageryInfo.getName());
                }
                if (!ConditionalOptionPaneUtil.showConfirmationDialog("download.suggest-imagery-layer", Main.parent, I18n.tr("<html>For the downloaded area, the following additional imagery layers are available: {0}Do you want to add those layers to the <em>Imagery</em> menu?<br>(If needed, you can remove those entries in the <em>Preferences</em>.)", Utils.joinAsHtmlUnorderedList(object)), I18n.tr("Add imagery layers?", new Object[0]), 0, 3, 0)) {
                    return;
                }
                ImageryLayerInfo.addLayers(hashSet);
            }
        }
    }
}

