/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ExtrudeAction
extends MapMode
implements MapViewPaintable {
    private Mode mode = Mode.select;
    private boolean alwaysCreateNodes = false;
    private long mouseDownTime = 0L;
    private WaySegment selectedSegment = null;
    private Color selectedColor;
    private Color helperColor;
    private BasicStroke helperStrokeDash;
    private BasicStroke helperStrokeRA;
    private List<ReferenceSegment> possibleMoveDirections;
    private ReferenceSegment activeMoveDirection;
    private Point initialMousePos;
    private int initialMoveDelay = 200;
    private EastNorth initialN1en;
    private EastNorth initialN2en;
    private EastNorth newN1en;
    private EastNorth newN2en;
    private MoveCommand moveCommand;
    private final Cursor cursorCreateNew;
    private final Cursor cursorTranslate;
    private final Cursor cursorCreateNodes;
    private final AWTEventListener altKeyListener = new AWTEventListener(){

        public void eventDispatched(AWTEvent aWTEvent) {
            boolean bl;
            if (Main.map == null || Main.map.mapView == null || !Main.map.mapView.isActiveLayerDrawable()) {
                return;
            }
            InputEvent inputEvent = (InputEvent)aWTEvent;
            boolean bl2 = (inputEvent.getModifiers() & 0x28) != 0;
            boolean bl3 = (inputEvent.getModifiers() & 2) != 0;
            boolean bl4 = bl = (inputEvent.getModifiers() & 1) != 0;
            if (ExtrudeAction.this.mode == Mode.select) {
                Main.map.mapView.setNewCursor(bl3 ? ExtrudeAction.this.cursorTranslate : (bl2 ? ExtrudeAction.this.cursorCreateNew : (bl ? ExtrudeAction.this.cursorCreateNodes : ExtrudeAction.this.cursor)), (Object)this);
            }
        }
    };

    public ExtrudeAction(MapFrame mapFrame) {
        super(I18n.tr("Extrude", new Object[0]), "extrude/extrude", I18n.tr("Create areas", new Object[0]), Shortcut.registerShortcut("mapmode:extrude", I18n.tr("Mode: {0}", I18n.tr("Extrude", new Object[0])), 88, 5003), mapFrame, ImageProvider.getCursor("normal", "rectangle"));
        this.putValue("help", HelpUtil.ht("/Action/Extrude"));
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.selectedColor = PaintColors.SELECTED.get();
        this.cursorCreateNew = ImageProvider.getCursor("normal", "rectangle_plus");
        this.cursorTranslate = ImageProvider.getCursor("normal", "rectangle_move");
        this.cursorCreateNodes = ImageProvider.getCursor("normal", "rectangle_plussmall");
        this.helperColor = Main.pref.getColor(I18n.marktr("Extrude: helper line"), Color.ORANGE);
        float[] fArray = new float[]{4.0f};
        this.helperStrokeDash = new BasicStroke(1.0f, 0, 0, 10.0f, fArray, 0.0f);
        this.helperStrokeRA = new BasicStroke(1.0f);
    }

    public String getModeHelpText() {
        if (this.mode == Mode.translate) {
            return I18n.tr("Move a segment along its normal, then release the mouse button.", new Object[0]);
        }
        if (this.mode == Mode.extrude) {
            return I18n.tr("Draw a rectangle of the desired size, then release the mouse button.", new Object[0]);
        }
        if (this.mode == Mode.create_new) {
            return I18n.tr("Draw a rectangle of the desired size, then release the mouse button.", new Object[0]);
        }
        return I18n.tr("Drag a way segment to make a rectangle. Ctrl-drag to move a segment along its normal, Alt-drag to create a new rectangle, double click to add a new node.", new Object[0]);
    }

    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.altKeyListener, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void exitMode() {
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.altKeyListener);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        super.exitMode();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (!((Boolean)this.getValue("active")).booleanValue()) {
            return;
        }
        if (mouseEvent.getButton() != 1) {
            return;
        }
        this.updateKeyModifiers(mouseEvent);
        this.selectedSegment = Main.map.mapView.getNearestWaySegment(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate);
        if (this.selectedSegment != null) {
            Object object;
            if (this.ctrl) {
                this.mode = Mode.translate;
            } else if (this.alt) {
                this.mode = Mode.create_new;
                ExtrudeAction.getCurrentDataSet().setSelected(this.selectedSegment.way);
                this.alwaysCreateNodes = true;
            } else {
                this.mode = Mode.extrude;
                ExtrudeAction.getCurrentDataSet().setSelected(this.selectedSegment.way);
                this.alwaysCreateNodes = this.shift;
            }
            this.initialN1en = this.selectedSegment.getFirstNode().getEastNorth();
            this.initialN2en = this.selectedSegment.getSecondNode().getEastNorth();
            this.possibleMoveDirections = new ArrayList<ReferenceSegment>();
            this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN1en.getY() - this.initialN2en.getY(), this.initialN2en.getX() - this.initialN1en.getX()), this.selectedSegment, true));
            Node node = this.getPreviousNode(this.selectedSegment.lowerIndex);
            if (node != null) {
                object = node.getEastNorth();
                this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN1en.getX() - ((EastNorth)object).getX(), this.initialN1en.getY() - ((EastNorth)object).getY()), new WaySegment(this.selectedSegment.way, this.getPreviousNodeIndex(this.selectedSegment.lowerIndex)), false));
            }
            if ((object = this.getNextNode(this.selectedSegment.lowerIndex + 1)) != null) {
                EastNorth eastNorth = ((Node)object).getEastNorth();
                this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN2en.getX() - eastNorth.getX(), this.initialN2en.getY() - eastNorth.getY()), new WaySegment(this.selectedSegment.way, this.getPreviousNodeIndex(this.getNextNodeIndex(this.getNextNodeIndex(this.selectedSegment.lowerIndex)))), false));
            }
            this.newN1en = null;
            this.newN2en = null;
            this.moveCommand = null;
            Main.map.mapView.addTemporaryLayer(this);
            this.updateStatusLine();
            Main.map.mapView.repaint();
            this.mouseDownTime = System.currentTimeMillis();
            this.initialMousePos = mouseEvent.getPoint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.select) {
            Cloneable cloneable;
            EastNorth eastNorth = Main.map.mapView.getEastNorth(this.initialMousePos.x, this.initialMousePos.y);
            EastNorth eastNorth2 = Main.map.mapView.getEastNorth(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            EastNorth eastNorth3 = new EastNorth(eastNorth2.getX() - eastNorth.getX(), eastNorth2.getY() - eastNorth.getY());
            double d = Double.POSITIVE_INFINITY;
            EastNorth eastNorth4 = null;
            this.activeMoveDirection = null;
            for (ReferenceSegment referenceSegment : this.possibleMoveDirections) {
                double d2;
                cloneable = ExtrudeAction.calculateSegmentOffset(this.initialN1en, this.initialN2en, referenceSegment.en, eastNorth2);
                if (cloneable == null || !(d > (d2 = ((EastNorth)cloneable).distance(eastNorth3)))) continue;
                d = d2;
                this.activeMoveDirection = referenceSegment;
                eastNorth4 = cloneable;
            }
            this.newN1en = new EastNorth(this.initialN1en.getX() + eastNorth4.getX(), this.initialN1en.getY() + eastNorth4.getY());
            this.newN2en = new EastNorth(this.initialN2en.getX() + eastNorth4.getX(), this.initialN2en.getY() + eastNorth4.getY());
            double d3 = Main.getProjection().eastNorth2latlon(this.initialN1en).greatCircleDistance(Main.getProjection().eastNorth2latlon(this.newN1en));
            Main.map.statusLine.setDist(d3);
            this.updateStatusLine();
            Main.map.mapView.setNewCursor(13, (Object)this);
            if (this.mode != Mode.extrude && this.mode != Mode.create_new && this.mode == Mode.translate) {
                if (this.moveCommand == null) {
                    cloneable = new LinkedList();
                    cloneable.add(this.selectedSegment.getFirstNode());
                    cloneable.add(this.selectedSegment.getSecondNode());
                    this.moveCommand = new MoveCommand((Collection<OsmPrimitive>)((Object)cloneable), eastNorth4.getX(), eastNorth4.getY());
                    Main.main.undoRedo.add(this.moveCommand);
                } else {
                    this.moveCommand.moveAgainTo(eastNorth4.getX(), eastNorth4.getY());
                }
            }
            Main.map.mapView.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (this.mode != Mode.select) {
            OsmPrimitive osmPrimitive;
            Object object;
            if (this.mode == Mode.create_new) {
                if (mouseEvent.getPoint().distance(this.initialMousePos) > 10.0 && this.newN1en != null) {
                    object = new LinkedList();
                    osmPrimitive = new Node(this.newN2en);
                    Node node = new Node(this.newN1en);
                    Way way = new Way();
                    way.addNode(this.selectedSegment.getFirstNode());
                    way.addNode(this.selectedSegment.getSecondNode());
                    way.addNode((Node)osmPrimitive);
                    way.addNode(node);
                    way.addNode(this.selectedSegment.getFirstNode());
                    object.add(new AddCommand(osmPrimitive));
                    object.add(new AddCommand(node));
                    object.add(new AddCommand(way));
                    SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr("Extrude Way", new Object[0]), (Collection<Command>)object);
                    Main.main.undoRedo.add(sequenceCommand);
                    ExtrudeAction.getCurrentDataSet().setSelected(way);
                }
            } else if (this.mode == Mode.extrude) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getPoint().equals(this.initialMousePos)) {
                    object = Main.map.mapView.getNearestWaySegment(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate);
                    if (object != null) {
                        osmPrimitive = new Node(Main.map.mapView.getLatLon(mouseEvent.getX(), mouseEvent.getY()));
                        EastNorth eastNorth = ((WaySegment)object).getFirstNode().getEastNorth();
                        EastNorth eastNorth2 = ((WaySegment)object).getSecondNode().getEastNorth();
                        ((Node)osmPrimitive).setEastNorth(Geometry.closestPointToSegment(eastNorth, eastNorth2, ((Node)osmPrimitive).getEastNorth()));
                        Way way = new Way(((WaySegment)object).way);
                        way.addNode(((WaySegment)object).lowerIndex + 1, (Node)osmPrimitive);
                        SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr("Add a new node to an existing way", new Object[0]), new AddCommand(osmPrimitive), new ChangeCommand(((WaySegment)object).way, way));
                        Main.main.undoRedo.add(sequenceCommand);
                    }
                } else if (mouseEvent.getPoint().distance(this.initialMousePos) > 10.0 && this.newN1en != null && this.selectedSegment != null) {
                    Object object2;
                    Node node;
                    object = new LinkedList<Command>();
                    osmPrimitive = new Way(this.selectedSegment.way);
                    int n = this.selectedSegment.lowerIndex + 1;
                    Node node2 = this.getPreviousNode(this.selectedSegment.lowerIndex);
                    boolean bl = node2 != null && Geometry.segmentsParallel(this.initialN1en, node2.getEastNorth(), this.initialN1en, this.newN1en);
                    boolean bl2 = this.hasNodeOtherWays(this.selectedSegment.getFirstNode(), this.selectedSegment.way);
                    if (bl && !this.alwaysCreateNodes && !bl2) {
                        node = this.selectedSegment.getFirstNode();
                        object.add(new MoveCommand(node, Main.getProjection().eastNorth2latlon(this.newN1en)));
                    } else {
                        node = new Node(Main.getProjection().eastNorth2latlon(this.newN1en));
                        ((Way)osmPrimitive).addNode(n, node);
                        ++n;
                        object.add(new AddCommand(node));
                    }
                    node = this.getNextNode(this.selectedSegment.lowerIndex + 1);
                    bl = node != null && Geometry.segmentsParallel(this.initialN2en, node.getEastNorth(), this.initialN2en, this.newN2en);
                    bl2 = this.hasNodeOtherWays(this.selectedSegment.getSecondNode(), this.selectedSegment.way);
                    if (bl && !this.alwaysCreateNodes && !bl2) {
                        object2 = this.selectedSegment.getSecondNode();
                        object.add((Command)new MoveCommand((Node)object2, Main.getProjection().eastNorth2latlon(this.newN2en)));
                    } else {
                        object2 = new Node(Main.getProjection().eastNorth2latlon(this.newN2en));
                        ((Way)osmPrimitive).addNode(n, (Node)object2);
                        ++n;
                        object.add((Command)new AddCommand((OsmPrimitive)object2));
                    }
                    if (((Way)osmPrimitive).getNodesCount() == 4) {
                        ((Way)osmPrimitive).addNode(this.selectedSegment.getFirstNode());
                    }
                    object.add((Command)new ChangeCommand(this.selectedSegment.way, osmPrimitive));
                    object2 = new SequenceCommand(I18n.tr("Extrude Way", new Object[0]), (Collection<Command>)object);
                    Main.main.undoRedo.add((Command)object2);
                }
            } else if (this.mode == Mode.translate) {
                // empty if block
            }
            boolean bl = (mouseEvent.getModifiers() & 0x28) != 0;
            boolean bl3 = (mouseEvent.getModifiers() & 2) != 0;
            boolean bl4 = (mouseEvent.getModifiers() & 1) != 0;
            Main.map.mapView.setNewCursor(bl3 ? this.cursorTranslate : (bl ? this.cursorCreateNew : (bl4 ? this.cursorCreateNodes : this.cursor)), (Object)this);
            Main.map.mapView.removeTemporaryLayer(this);
            this.selectedSegment = null;
            this.moveCommand = null;
            this.mode = Mode.select;
            this.updateStatusLine();
            Main.map.mapView.repaint();
        }
    }

    private boolean hasNodeOtherWays(Node node, Way way) {
        for (OsmPrimitive osmPrimitive : node.getReferrers()) {
            if (!(osmPrimitive instanceof Way) || !osmPrimitive.isUsable() || osmPrimitive == way) continue;
            return true;
        }
        return false;
    }

    private static EastNorth calculateSegmentOffset(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        EastNorth eastNorth5 = Geometry.getLineLineIntersection(eastNorth, eastNorth2, eastNorth4, new EastNorth(eastNorth4.getX() + eastNorth3.getX(), eastNorth4.getY() + eastNorth3.getY()));
        if (eastNorth5 == null) {
            return null;
        }
        return new EastNorth(eastNorth4.getX() - eastNorth5.getX(), eastNorth4.getY() - eastNorth5.getY());
    }

    private int getPreviousNodeIndex(int n) {
        if (n > 0) {
            return n - 1;
        }
        if (this.selectedSegment.way.isClosed()) {
            return this.selectedSegment.way.getNodesCount() - 2;
        }
        return -1;
    }

    private Node getPreviousNode(int n) {
        int n2 = this.getPreviousNodeIndex(n);
        if (n2 >= 0) {
            return this.selectedSegment.way.getNode(n2);
        }
        return null;
    }

    private int getNextNodeIndex(int n) {
        int n2 = this.selectedSegment.way.getNodesCount();
        if (n < n2 - 1) {
            return n + 1;
        }
        if (this.selectedSegment.way.isClosed()) {
            return 1;
        }
        return -1;
    }

    private Node getNextNode(int n) {
        int n2 = this.getNextNodeIndex(n);
        if (n2 >= 0) {
            return this.selectedSegment.way.getNode(n2);
        }
        return null;
    }

    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        if (this.mode != Mode.select && this.newN1en != null) {
            Graphics2D graphics2D2 = graphics2D;
            graphics2D2.setColor(this.selectedColor);
            graphics2D2.setStroke(new BasicStroke(3.0f, 1, 1));
            Point point = mapView.getPoint(this.initialN1en);
            Point point2 = mapView.getPoint(this.initialN2en);
            Point point3 = mapView.getPoint(this.newN1en);
            Point point4 = mapView.getPoint(this.newN2en);
            double d = 1.0 / this.activeMoveDirection.en.distance(0.0, 0.0);
            EastNorth eastNorth = new EastNorth(this.activeMoveDirection.en.getX() * d, this.activeMoveDirection.en.getY() * d);
            if (this.newN1en != null && this.newN1en.getX() > this.initialN1en.getX() != eastNorth.getX() > -0.0) {
                eastNorth = new EastNorth(-eastNorth.getX(), -eastNorth.getY());
            }
            eastNorth.setLocation(eastNorth.getX(), -eastNorth.getY());
            if (this.mode == Mode.extrude || this.mode == Mode.create_new) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(point.x, point.y);
                generalPath.lineTo(point3.x, point3.y);
                generalPath.lineTo(point4.x, point4.y);
                generalPath.lineTo(point2.x, point2.y);
                generalPath.lineTo(point.x, point.y);
                graphics2D2.draw(generalPath);
                if (this.activeMoveDirection != null) {
                    Point point5 = mapView.getPoint(this.activeMoveDirection.ws.getFirstNode().getEastNorth());
                    Point point6 = mapView.getPoint(this.activeMoveDirection.ws.getSecondNode().getEastNorth());
                    generalPath = new GeneralPath();
                    generalPath.moveTo(point5.x, point5.y);
                    generalPath.lineTo(point6.x, point6.y);
                    graphics2D2.setColor(this.helperColor);
                    graphics2D2.setStroke(this.helperStrokeDash);
                    graphics2D2.draw(generalPath);
                    if (this.activeMoveDirection.perpendicular) {
                        double d2;
                        double d3 = this.activeMoveDirection.ws.getFirstNode().getEastNorth().heading(this.activeMoveDirection.ws.getSecondNode().getEastNorth());
                        double d4 = d3 - (d2 = Math.atan2(eastNorth.getY(), eastNorth.getX()));
                        if (d4 < 0.0) {
                            d4 += Math.PI * 2;
                        }
                        boolean bl = Math.abs(d4 - Math.PI) > 1.0E-5;
                        double d5 = 1.0 / graphics2D2.getTransform().getScaleX();
                        double d6 = 8.0 * d5 * eastNorth.getX();
                        double d7 = 8.0 * d5 * eastNorth.getY();
                        Point2D.Double double_ = new Point2D.Double((double)point5.x + d6, (double)point5.y + d7);
                        Point2D.Double double_2 = new Point2D.Double((double)point5.x - d7 * (double)(bl ? -1 : 1), (double)point5.y + d6 * (double)(bl ? -1 : 1));
                        Point2D.Double double_3 = new Point2D.Double(((Point2D)double_).getX() - d7 * (double)(bl ? -1 : 1), ((Point2D)double_).getY() + d6 * (double)(bl ? -1 : 1));
                        GeneralPath generalPath2 = new GeneralPath();
                        generalPath2.moveTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
                        generalPath2.lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
                        generalPath2.lineTo((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
                        graphics2D2.setStroke(this.helperStrokeRA);
                        graphics2D2.draw(generalPath2);
                    }
                }
            } else if (this.mode == Mode.translate) {
                Line2D.Double double_ = new Line2D.Double(point3, point4);
                graphics2D2.draw(double_);
                graphics2D2.setStroke(new BasicStroke(1.0f));
                Line2D.Double double_4 = new Line2D.Double(point, point2);
                graphics2D2.draw(double_4);
                if (this.activeMoveDirection != null) {
                    Point2D.Double double_5 = new Point2D.Double((point.getX() + point2.getX()) * 0.5, (point.getY() + point2.getY()) * 0.5);
                    Line2D line2D = ExtrudeAction.createSemiInfiniteLine(double_5, eastNorth, graphics2D2);
                    graphics2D2.draw(line2D);
                    if (this.activeMoveDirection.perpendicular) {
                        double d8 = 1.0 / graphics2D2.getTransform().getScaleX();
                        double d9 = 8.0 * d8 * eastNorth.getX();
                        double d10 = 8.0 * d8 * eastNorth.getY();
                        Point2D.Double double_6 = new Point2D.Double(((Point2D)double_5).getX() + d9, ((Point2D)double_5).getY() + d10);
                        Point2D.Double double_7 = new Point2D.Double(((Point2D)double_5).getX() - d10, ((Point2D)double_5).getY() + d9);
                        Point2D.Double double_8 = new Point2D.Double(((Point2D)double_6).getX() - d10, ((Point2D)double_6).getY() + d9);
                        GeneralPath generalPath = new GeneralPath();
                        generalPath.moveTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
                        generalPath.lineTo((float)((Point2D)double_8).getX(), (float)((Point2D)double_8).getY());
                        generalPath.lineTo((float)((Point2D)double_7).getX(), (float)((Point2D)double_7).getY());
                        graphics2D2.draw(generalPath);
                    }
                }
            }
        }
    }

    private static Line2D createSemiInfiniteLine(Point2D point2D, Point2D point2D2, Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getDeviceConfiguration().getBounds();
        try {
            AffineTransform affineTransform = graphics2D.getTransform().createInverse();
            Point2D point2D3 = affineTransform.deltaTransform(new Point2D.Double(rectangle.width, 0.0), null);
            Point2D point2D4 = affineTransform.deltaTransform(new Point2D.Double(0.0, rectangle.height), null);
            double d = Math.abs(point2D3.getX()) + Math.abs(point2D3.getY()) + Math.abs(point2D4.getX()) + Math.abs(point2D4.getY());
            return new Line2D.Double(point2D, new Point2D.Double(point2D.getX() + point2D2.getX() * d, point2D.getY() + point2D2.getY() * d));
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return new Line2D.Double(point2D, new Point2D.Double(point2D.getX() + point2D2.getX() * 10.0, point2D.getY() + point2D2.getY() * 10.0));
        }
    }

    private class ReferenceSegment {
        public final EastNorth en;
        public final WaySegment ws;
        public final boolean perpendicular;

        public ReferenceSegment(EastNorth eastNorth, WaySegment waySegment, boolean bl) {
            this.en = eastNorth;
            this.ws = waySegment;
            this.perpendicular = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        extrude,
        translate,
        select,
        create_new;

    }
}

