/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.datum.NTV2Datum;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileWrapper;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.tools.I18n;

public class GaussKrueger
extends AbstractProjection {
    public static final int DEFAULT_ZONE = 2;
    private final int zone;
    private static Bounds[] bounds = new Bounds[]{new Bounds(new LatLon(-5.0, 3.5), new LatLon(85.0, 8.5), false), new Bounds(new LatLon(-5.0, 6.5), new LatLon(85.0, 11.5), false), new Bounds(new LatLon(-5.0, 9.5), new LatLon(85.0, 14.5), false), new Bounds(new LatLon(-5.0, 12.5), new LatLon(85.0, 17.5), false)};

    public GaussKrueger() {
        this(2);
    }

    public GaussKrueger(int n) {
        if (n < 2 || n > 5) {
            throw new IllegalArgumentException();
        }
        this.zone = n;
        this.ellps = Ellipsoid.Bessel1841;
        this.datum = new NTV2Datum("BETA2007", null, this.ellps, NTV2GridShiftFileWrapper.BETA2007);
        this.proj = new TransverseMercator();
        try {
            this.proj.initialize(new ProjParameters(){
                {
                    this.ellps = GaussKrueger.this.ellps;
                }
            });
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException(projectionConfigurationException);
        }
        this.x_0 = 1000000 * n + 500000;
        this.lon_0 = 3 * n;
    }

    public String toString() {
        return I18n.tr("Gau\u00df-Kr\u00fcger Zone {0}", this.zone);
    }

    public Integer getEpsgCode() {
        return 31464 + this.zone;
    }

    public String getCacheDirectoryName() {
        return "gausskrueger" + this.zone;
    }

    public Bounds getWorldBoundsLatLon() {
        return bounds[this.zone - 2];
    }
}

