/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.datum.WGS84Datum;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.tools.I18n;

public class UTM
extends AbstractProjection {
    private static final int DEFAULT_ZONE = 30;
    private int zone;
    private static final Hemisphere DEFAULT_HEMISPHERE = Hemisphere.North;
    private Hemisphere hemisphere;

    public UTM() {
        this(30, DEFAULT_HEMISPHERE);
    }

    public UTM(int n, Hemisphere hemisphere) {
        if (n < 1 || n > 60) {
            throw new IllegalArgumentException();
        }
        this.ellps = Ellipsoid.WGS84;
        this.proj = new TransverseMercator();
        try {
            this.proj.initialize(new ProjParameters(){
                {
                    this.ellps = UTM.this.ellps;
                }
            });
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException(projectionConfigurationException);
        }
        this.datum = WGS84Datum.INSTANCE;
        this.zone = n;
        this.hemisphere = hemisphere;
        this.x_0 = 500000.0;
        this.y_0 = hemisphere == Hemisphere.North ? 0.0 : 1.0E7;
        this.lon_0 = this.getUtmCentralMeridianDeg(n);
        this.k_0 = 0.9996;
    }

    private double getUtmCentralMeridianDeg(int n) {
        return -183.0 + (double)n * 6.0;
    }

    public int getzone() {
        return this.zone;
    }

    public String toString() {
        return I18n.tr("UTM", new Object[0]);
    }

    public Integer getEpsgCode() {
        return 32600 + this.getzone() + (this.hemisphere == Hemisphere.South ? 100 : 0);
    }

    public int hashCode() {
        return this.toCode().hashCode();
    }

    public String getCacheDirectoryName() {
        return "epsg" + this.getEpsgCode();
    }

    public Bounds getWorldBoundsLatLon() {
        if (this.hemisphere == Hemisphere.North) {
            return new Bounds(new LatLon(-5.0, this.getUtmCentralMeridianDeg(this.getzone()) - 5.0), new LatLon(85.0, this.getUtmCentralMeridianDeg(this.getzone()) + 5.0), false);
        }
        return new Bounds(new LatLon(-85.0, this.getUtmCentralMeridianDeg(this.getzone()) - 5.0), new LatLon(5.0, this.getUtmCentralMeridianDeg(this.getzone()) + 5.0), false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Hemisphere {
        North,
        South;

    }
}

