/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.datum.GRS80Datum;
import org.openstreetmap.josm.data.projection.datum.SevenParameterDatum;
import org.openstreetmap.josm.data.projection.datum.ThreeParameterDatum;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.tools.I18n;

public class UTM_France_DOM
extends AbstractProjection {
    private static final Bounds FortMarigotBounds = new Bounds(new LatLon(17.6, -63.25), new LatLon(18.5, -62.5), false);
    private static final Bounds SainteAnneBounds = new Bounds(new LatLon(15.8, -61.9), new LatLon(16.6, -60.9), false);
    private static final Bounds MartiniqueBounds = new Bounds(new LatLon(14.25, -61.25), new LatLon(15.025, -60.725), false);
    private static final Bounds ReunionBounds = new Bounds(new LatLon(-25.92, 37.58), new LatLon(-10.6, 58.27), false);
    private static final Bounds GuyaneBounds = new Bounds(new LatLon(2.16, -54.0), new LatLon(9.06, -49.62), false);
    private static final Bounds[] utmBounds = new Bounds[]{FortMarigotBounds, SainteAnneBounds, MartiniqueBounds, ReunionBounds, GuyaneBounds};
    private static final Integer FortMarigotEPSG = 2969;
    private static final Integer SainteAnneEPSG = 2970;
    private static final Integer MartiniqueEPSG = 2973;
    private static final Integer ReunionEPSG = 2975;
    private static final Integer GuyaneEPSG = 2972;
    public static final Integer[] utmEPSGs = new Integer[]{FortMarigotEPSG, SainteAnneEPSG, MartiniqueEPSG, ReunionEPSG, GuyaneEPSG};
    private static final Datum FortMarigotDatum = new ThreeParameterDatum("FortMarigot Datum", null, Ellipsoid.hayford, 136.596, 248.148, -429.789);
    private static final Datum SainteAnneDatum = new SevenParameterDatum("SainteAnne Datum", null, Ellipsoid.hayford, -472.29, -5.63, -304.12, 0.4362, -0.8374, 0.2563, 1.8984);
    private static final Datum MartiniqueDatum = new SevenParameterDatum("Martinique Datum", null, Ellipsoid.hayford, 126.926, 547.939, 130.409, -2.7867, 5.16124, -0.85844, 13.82265);
    private static final Datum ReunionDatum = GRS80Datum.INSTANCE;
    private static final Datum GuyaneDatum = GRS80Datum.INSTANCE;
    private static final Datum[] utmDatums = new Datum[]{FortMarigotDatum, SainteAnneDatum, MartiniqueDatum, ReunionDatum, GuyaneDatum};
    private static final int[] utmZones = new int[]{20, 20, 20, 40, 22};
    private static int zone;
    private boolean isNorth;
    public static final int DEFAULT_GEODESIC = 0;
    public int currentGeodesic;

    public UTM_France_DOM() {
        this(0);
    }

    public UTM_France_DOM(int n) {
        if (n < 0 || n >= 5) {
            throw new IllegalArgumentException();
        }
        this.currentGeodesic = n;
        this.datum = utmDatums[n];
        this.ellps = this.datum.getEllipsoid();
        this.proj = new TransverseMercator();
        try {
            this.proj.initialize(new ProjParameters(){
                {
                    this.ellps = UTM_France_DOM.this.ellps;
                }
            });
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException(projectionConfigurationException);
        }
        this.isNorth = n != 3;
        zone = utmZones[n];
        this.x_0 = 500000.0;
        this.y_0 = this.isNorth ? 0.0 : 1.0E7;
        this.lon_0 = 6 * zone - 183;
        this.k_0 = 0.9996;
    }

    public int getCurrentGeodesic() {
        return this.currentGeodesic;
    }

    public String toString() {
        return I18n.tr("UTM France (DOM)", new Object[0]);
    }

    public String getCacheDirectoryName() {
        return this.toString();
    }

    public Bounds getWorldBoundsLatLon() {
        return utmBounds[this.currentGeodesic];
    }

    public Integer getEpsgCode() {
        return utmEPSGs[this.currentGeodesic];
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.currentGeodesic;
    }
}

