/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.conflict.pair.ComparePairType;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.OsmPrimitivesTableModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListMergeModel<T extends PrimitiveId>
extends Observable {
    public static final String FROZEN_PROP = ListMergeModel.class.getName() + ".frozen";
    private static final int MAX_DELETED_PRIMITIVE_IN_DIALOG = 5;
    protected HashMap<ListRole, ArrayList<T>> entries = new HashMap();
    protected EntriesTableModel myEntriesTableModel;
    protected EntriesTableModel theirEntriesTableModel;
    protected EntriesTableModel mergedEntriesTableModel;
    protected EntriesSelectionModel myEntriesSelectionModel;
    protected EntriesSelectionModel theirEntriesSelectionModel;
    protected EntriesSelectionModel mergedEntriesSelectionModel;
    private final List<PropertyChangeListener> listeners;
    private boolean isFrozen = false;
    private final ComparePairListModel comparePairListModel;
    private DataSet myDataset;
    private Map<PrimitiveId, PrimitiveId> mergedMap;

    protected abstract T cloneEntryForMergedList(T var1);

    public abstract boolean isEqualEntry(T var1, T var2);

    protected abstract void setValueAt(DefaultTableModel var1, Object var2, int var3, int var4);

    public OsmPrimitive getMyPrimitive(T t) {
        return this.getMyPrimitiveById((PrimitiveId)t);
    }

    public final OsmPrimitive getMyPrimitiveById(PrimitiveId primitiveId) {
        OsmPrimitive osmPrimitive = this.myDataset.getPrimitiveById(primitiveId);
        if (osmPrimitive == null && this.mergedMap != null) {
            PrimitiveId primitiveId2 = this.mergedMap.get(primitiveId);
            if (primitiveId2 == null && primitiveId instanceof OsmPrimitive) {
                primitiveId2 = this.mergedMap.get(((OsmPrimitive)primitiveId).getPrimitiveId());
            }
            if (primitiveId2 != null) {
                osmPrimitive = this.myDataset.getPrimitiveById(primitiveId2);
            }
        }
        return osmPrimitive;
    }

    protected void buildMyEntriesTableModel() {
        this.myEntriesTableModel = new EntriesTableModel(ListRole.MY_ENTRIES);
    }

    protected void buildTheirEntriesTableModel() {
        this.theirEntriesTableModel = new EntriesTableModel(ListRole.THEIR_ENTRIES);
    }

    protected void buildMergedEntriesTableModel() {
        this.mergedEntriesTableModel = new EntriesTableModel(ListRole.MERGED_ENTRIES);
    }

    protected List<T> getMergedEntries() {
        return this.entries.get((Object)ListRole.MERGED_ENTRIES);
    }

    protected List<T> getMyEntries() {
        return this.entries.get((Object)ListRole.MY_ENTRIES);
    }

    protected List<T> getTheirEntries() {
        return this.entries.get((Object)ListRole.THEIR_ENTRIES);
    }

    public int getMyEntriesSize() {
        return this.getMyEntries().size();
    }

    public int getMergedEntriesSize() {
        return this.getMergedEntries().size();
    }

    public int getTheirEntriesSize() {
        return this.getTheirEntries().size();
    }

    public ListMergeModel() {
        for (ListRole listRole : ListRole.values()) {
            this.entries.put(listRole, new ArrayList());
        }
        this.buildMyEntriesTableModel();
        this.buildTheirEntriesTableModel();
        this.buildMergedEntriesTableModel();
        this.myEntriesSelectionModel = new EntriesSelectionModel(this.entries.get((Object)ListRole.MY_ENTRIES));
        this.theirEntriesSelectionModel = new EntriesSelectionModel(this.entries.get((Object)ListRole.THEIR_ENTRIES));
        this.mergedEntriesSelectionModel = new EntriesSelectionModel(this.entries.get((Object)ListRole.MERGED_ENTRIES));
        this.listeners = new ArrayList<PropertyChangeListener>();
        this.comparePairListModel = new ComparePairListModel();
        this.setFrozen(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            if (propertyChangeListener != null && !this.listeners.contains(propertyChangeListener)) {
                this.listeners.add(propertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            if (propertyChangeListener != null && this.listeners.contains(propertyChangeListener)) {
                this.listeners.remove(propertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFrozenChanged(boolean bl, boolean bl2) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, FROZEN_PROP, bl, bl2);
            for (PropertyChangeListener propertyChangeListener : this.listeners) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    public void setFrozen(boolean bl) {
        boolean bl2 = this.isFrozen;
        this.isFrozen = bl;
        this.fireFrozenChanged(bl2, this.isFrozen);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public OsmPrimitivesTableModel getMyTableModel() {
        return this.myEntriesTableModel;
    }

    public OsmPrimitivesTableModel getTheirTableModel() {
        return this.theirEntriesTableModel;
    }

    public OsmPrimitivesTableModel getMergedTableModel() {
        return this.mergedEntriesTableModel;
    }

    public EntriesSelectionModel getMySelectionModel() {
        return this.myEntriesSelectionModel;
    }

    public EntriesSelectionModel getTheirSelectionModel() {
        return this.theirEntriesSelectionModel;
    }

    public EntriesSelectionModel getMergedSelectionModel() {
        return this.mergedEntriesSelectionModel;
    }

    protected void fireModelDataChanged() {
        this.myEntriesTableModel.fireTableDataChanged();
        this.theirEntriesTableModel.fireTableDataChanged();
        this.mergedEntriesTableModel.fireTableDataChanged();
        this.setChanged();
        this.notifyObservers();
    }

    protected void copyToTop(ListRole listRole, int[] nArray) {
        this.copy(listRole, nArray, 0);
        this.mergedEntriesSelectionModel.setSelectionInterval(0, nArray.length - 1);
    }

    public void copyMyToTop(int[] nArray) {
        this.copyToTop(ListRole.MY_ENTRIES, nArray);
    }

    public void copyTheirToTop(int[] nArray) {
        this.copyToTop(ListRole.THEIR_ENTRIES, nArray);
    }

    public void copyToEnd(ListRole listRole, int[] nArray) {
        this.copy(listRole, nArray, this.getMergedEntriesSize());
        this.mergedEntriesSelectionModel.setSelectionInterval(this.getMergedEntriesSize() - nArray.length, this.getMergedEntriesSize() - 1);
    }

    public void copyMyToEnd(int[] nArray) {
        this.copyToEnd(ListRole.MY_ENTRIES, nArray);
    }

    public void copyTheirToEnd(int[] nArray) {
        this.copyToEnd(ListRole.THEIR_ENTRIES, nArray);
    }

    public void clearMerged() {
        this.getMergedEntries().clear();
        this.fireModelDataChanged();
    }

    protected final void initPopulate(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2, Map<PrimitiveId, PrimitiveId> map) {
        CheckParameterUtil.ensureParameterNotNull(osmPrimitive, "my");
        CheckParameterUtil.ensureParameterNotNull(osmPrimitive2, "their");
        this.myDataset = osmPrimitive.getDataSet();
        this.mergedMap = map;
        this.getMergedEntries().clear();
        this.getMyEntries().clear();
        this.getTheirEntries().clear();
    }

    protected void alertCopyFailedForDeletedPrimitives(List<PrimitiveId> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < Math.min(5, list.size()); ++i) {
            arrayList.add(list.get(i).toString());
        }
        if (list.size() > 5) {
            arrayList.add(I18n.tr("{0} more...", list.size() - 5));
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append(I18n.tr("The following objects could not be copied to the target object<br>because they are deleted in the target dataset:", new Object[0]));
        stringBuffer.append("<ul>");
        for (String string : arrayList) {
            stringBuffer.append("<li>").append(string).append("</li>");
        }
        stringBuffer.append("</ul>");
        stringBuffer.append("</html>");
        HelpAwareOptionPane.showOptionDialog(Main.parent, stringBuffer.toString(), I18n.tr("Merging deleted objects failed", new Object[0]), 2, HelpUtil.ht("/Dialog/Conflict#MergingDeletedPrimitivesFailed"));
    }

    private void copy(ListRole listRole, int[] nArray, int n) {
        if (n < 0 || n > this.getMergedEntriesSize()) {
            throw new IllegalArgumentException();
        }
        ArrayList<PrimitiveId> arrayList = new ArrayList<PrimitiveId>(nArray.length);
        List list = this.entries.get((Object)listRole);
        ArrayList<PrimitiveId> arrayList2 = new ArrayList<PrimitiveId>();
        for (int n2 : nArray) {
            PrimitiveId primitiveId = (PrimitiveId)list.get(n2);
            OsmPrimitive osmPrimitive = this.getMyPrimitive(primitiveId);
            if (!osmPrimitive.isDeleted()) {
                PrimitiveId primitiveId2 = this.cloneEntryForMergedList(primitiveId);
                arrayList.add(primitiveId2);
                continue;
            }
            arrayList2.add(osmPrimitive.getPrimitiveId());
        }
        this.getMergedEntries().addAll(n, arrayList);
        this.fireModelDataChanged();
        if (!arrayList2.isEmpty()) {
            this.alertCopyFailedForDeletedPrimitives(arrayList2);
        }
    }

    public void copyAll(ListRole listRole) {
        this.getMergedEntries().clear();
        int[] nArray = new int[this.entries.get((Object)listRole).size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        this.copy(listRole, nArray, 0);
    }

    protected void copyBeforeCurrent(ListRole listRole, int[] nArray, int n) {
        this.copy(listRole, nArray, n);
        this.mergedEntriesSelectionModel.setSelectionInterval(n, n + nArray.length - 1);
    }

    public void copyMyBeforeCurrent(int[] nArray, int n) {
        this.copyBeforeCurrent(ListRole.MY_ENTRIES, nArray, n);
    }

    public void copyTheirBeforeCurrent(int[] nArray, int n) {
        this.copyBeforeCurrent(ListRole.THEIR_ENTRIES, nArray, n);
    }

    protected void copyAfterCurrent(ListRole listRole, int[] nArray, int n) {
        this.copy(listRole, nArray, n + 1);
        this.mergedEntriesSelectionModel.setSelectionInterval(n + 1, n + nArray.length - 1);
        this.notifyObservers();
    }

    public void copyMyAfterCurrent(int[] nArray, int n) {
        this.copyAfterCurrent(ListRole.MY_ENTRIES, nArray, n);
    }

    public void copyTheirAfterCurrent(int[] nArray, int n) {
        this.copyAfterCurrent(ListRole.THEIR_ENTRIES, nArray, n);
    }

    public void moveUpMerged(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (nArray[0] == 0) {
            return;
        }
        List<T> list = this.getMergedEntries();
        for (int n : nArray) {
            PrimitiveId primitiveId = (PrimitiveId)list.get(n);
            list.remove(n);
            list.add(n - 1, primitiveId);
        }
        this.fireModelDataChanged();
        this.notifyObservers();
        this.mergedEntriesSelectionModel.clearSelection();
        for (int n : nArray) {
            this.mergedEntriesSelectionModel.addSelectionInterval(n - 1, n - 1);
        }
    }

    public void moveDownMerged(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        List<T> list = this.getMergedEntries();
        if (nArray[nArray.length - 1] == list.size() - 1) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            PrimitiveId primitiveId = (PrimitiveId)list.get(n);
            list.remove(n);
            list.add(n + 1, primitiveId);
        }
        this.fireModelDataChanged();
        this.notifyObservers();
        this.mergedEntriesSelectionModel.clearSelection();
        for (int n : nArray) {
            this.mergedEntriesSelectionModel.addSelectionInterval(n + 1, n + 1);
        }
    }

    public void removeMerged(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        List<T> list = this.getMergedEntries();
        for (int i = nArray.length - 1; i >= 0; --i) {
            list.remove(nArray[i]);
        }
        this.fireModelDataChanged();
        this.notifyObservers();
        this.mergedEntriesSelectionModel.clearSelection();
    }

    protected boolean myAndTheirEntriesEqual() {
        if (this.getMyEntriesSize() != this.getTheirEntriesSize()) {
            return false;
        }
        for (int i = 0; i < this.getMyEntriesSize(); ++i) {
            if (this.isEqualEntry((PrimitiveId)this.getMyEntries().get(i), (PrimitiveId)this.getTheirEntries().get(i))) continue;
            return false;
        }
        return true;
    }

    public ComparePairListModel getComparePairListModel() {
        return this.comparePairListModel;
    }

    public class ComparePairListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private int selectedIdx;
        private final ArrayList<ComparePairType> compareModes = new ArrayList();

        public ComparePairListModel() {
            this.compareModes.add(ComparePairType.MY_WITH_THEIR);
            this.compareModes.add(ComparePairType.MY_WITH_MERGED);
            this.compareModes.add(ComparePairType.THEIR_WITH_MERGED);
            this.selectedIdx = 0;
        }

        public Object getElementAt(int n) {
            if (n < this.compareModes.size()) {
                return this.compareModes.get(n);
            }
            throw new IllegalArgumentException(I18n.tr("Unexpected value of parameter ''index''. Got {0}.", n));
        }

        public int getSize() {
            return this.compareModes.size();
        }

        public Object getSelectedItem() {
            return this.compareModes.get(this.selectedIdx);
        }

        public void setSelectedItem(Object object) {
            int n = this.compareModes.indexOf(object);
            if (n < 0) {
                throw new IllegalStateException(I18n.tr("Item {0} not found in list.", object));
            }
            this.selectedIdx = n;
            ListMergeModel.this.fireModelDataChanged();
        }

        public ComparePairType getSelectedComparePair() {
            return this.compareModes.get(this.selectedIdx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntriesSelectionModel
    extends DefaultListSelectionModel {
        private final ArrayList<T> entries;

        public EntriesSelectionModel(ArrayList<T> arrayList) {
            this.entries = arrayList;
        }

        @Override
        public void addSelectionInterval(int n, int n2) {
            if (this.entries.isEmpty()) {
                return;
            }
            if (n > this.entries.size() - 1) {
                return;
            }
            n = Math.min(this.entries.size() - 1, n);
            n2 = Math.min(this.entries.size() - 1, n2);
            super.addSelectionInterval(n, n2);
        }

        @Override
        public void insertIndexInterval(int n, int n2, boolean bl) {
            if (this.entries.isEmpty()) {
                return;
            }
            if (bl) {
                int n3 = Math.min(this.entries.size() - 1, n);
                if (n3 < n - n2) {
                    return;
                }
                super.insertIndexInterval(n3, n2 -= n - n3, bl);
            } else {
                if (n > this.entries.size() - 1) {
                    return;
                }
                n2 = Math.min(this.entries.size() - 1 - n, n2);
                super.insertIndexInterval(n, n2, bl);
            }
        }

        @Override
        public void moveLeadSelectionIndex(int n) {
            if (this.entries.isEmpty()) {
                return;
            }
            n = Math.max(0, n);
            n = Math.min(this.entries.size() - 1, n);
            super.moveLeadSelectionIndex(n);
        }

        @Override
        public void removeIndexInterval(int n, int n2) {
            if (this.entries.isEmpty()) {
                return;
            }
            n = Math.max(0, n);
            n = Math.min(this.entries.size() - 1, n);
            n2 = Math.max(0, n2);
            n2 = Math.min(this.entries.size() - 1, n2);
            super.removeIndexInterval(n, n2);
        }

        @Override
        public void removeSelectionInterval(int n, int n2) {
            if (this.entries.isEmpty()) {
                return;
            }
            n = Math.max(0, n);
            n = Math.min(this.entries.size() - 1, n);
            n2 = Math.max(0, n2);
            n2 = Math.min(this.entries.size() - 1, n2);
            super.removeSelectionInterval(n, n2);
        }

        @Override
        public void setAnchorSelectionIndex(int n) {
            if (this.entries.isEmpty()) {
                return;
            }
            n = Math.min(this.entries.size() - 1, n);
            super.setAnchorSelectionIndex(n);
        }

        @Override
        public void setLeadSelectionIndex(int n) {
            if (this.entries.isEmpty()) {
                return;
            }
            n = Math.min(this.entries.size() - 1, n);
            super.setLeadSelectionIndex(n);
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            if (this.entries.isEmpty()) {
                return;
            }
            n = Math.max(0, n);
            n = Math.min(this.entries.size() - 1, n);
            n2 = Math.max(0, n2);
            n2 = Math.min(this.entries.size() - 1, n2);
            super.setSelectionInterval(n, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntriesTableModel
    extends DefaultTableModel
    implements OsmPrimitivesTableModel {
        private final ListRole role;

        public EntriesTableModel(ListRole listRole) {
            this.role = listRole;
        }

        @Override
        public int getRowCount() {
            int n = Math.max(ListMergeModel.this.getMyEntries().size(), ListMergeModel.this.getMergedEntries().size());
            n = Math.max(n, ListMergeModel.this.getTheirEntries().size());
            return n;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < ListMergeModel.this.entries.get((Object)this.role).size()) {
                return ListMergeModel.this.entries.get((Object)this.role).get(n);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ListMergeModel.this.setValueAt(this, object, n, n2);
        }

        public ListMergeModel<T> getListMergeModel() {
            return ListMergeModel.this;
        }

        public boolean isParticipatingInCurrentComparePair() {
            return ListMergeModel.this.getComparePairListModel().getSelectedComparePair().isParticipatingIn(this.role);
        }

        public boolean isSamePositionInOppositeList(int n) {
            if (!this.isParticipatingInCurrentComparePair()) {
                throw new IllegalStateException(I18n.tr("List in role {0} is currently not participating in a compare pair.", this.role.toString()));
            }
            if (n >= this.getEntries().size()) {
                return false;
            }
            if (n >= this.getOppositeEntries().size()) {
                return false;
            }
            PrimitiveId primitiveId = (PrimitiveId)this.getEntries().get(n);
            PrimitiveId primitiveId2 = (PrimitiveId)this.getOppositeEntries().get(n);
            return ListMergeModel.this.isEqualEntry(primitiveId, primitiveId2);
        }

        public boolean isIncludedInOppositeList(int n) {
            if (!this.isParticipatingInCurrentComparePair()) {
                throw new IllegalStateException(I18n.tr("List in role {0} is currently not participating in a compare pair.", this.role.toString()));
            }
            if (n >= this.getEntries().size()) {
                return false;
            }
            PrimitiveId primitiveId = (PrimitiveId)this.getEntries().get(n);
            for (PrimitiveId primitiveId2 : this.getOppositeEntries()) {
                if (!ListMergeModel.this.isEqualEntry(primitiveId, primitiveId2)) continue;
                return true;
            }
            return false;
        }

        protected ArrayList<T> getEntries() {
            return ListMergeModel.this.entries.get((Object)this.role);
        }

        protected ArrayList<T> getOppositeEntries() {
            ListRole listRole = ListMergeModel.this.getComparePairListModel().getSelectedComparePair().getOppositeRole(this.role);
            return ListMergeModel.this.entries.get((Object)listRole);
        }

        public ListRole getRole() {
            return this.role;
        }

        @Override
        public OsmPrimitive getReferredPrimitive(int n) {
            Object object = this.getValueAt(n, 1);
            if (object instanceof OsmPrimitive) {
                return (OsmPrimitive)object;
            }
            if (object instanceof RelationMember) {
                return ((RelationMember)object).getMember();
            }
            System.err.println("Unknown object type: " + object);
            return null;
        }
    }
}

