/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverTable;
import org.openstreetmap.josm.tools.I18n;

public class TagConflictResolver
extends JPanel {
    private TagConflictResolverModel model = new TagConflictResolverModel();
    private JCheckBox cbShowTagsWithConflictsOnly;
    private JCheckBox cbShowTagsWithMultiValuesOnly;

    protected JPanel buildInfoPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)new JLabel(I18n.tr("<html>Please select the values to keep for the following tags.</html>", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        this.cbShowTagsWithConflictsOnly = new JCheckBox(I18n.tr("Show tags with conflicts only", new Object[0]));
        jPanel.add((Component)this.cbShowTagsWithConflictsOnly, gridBagConstraints);
        this.cbShowTagsWithMultiValuesOnly = new JCheckBox(I18n.tr("Show tags with multiple values only", new Object[0]));
        jPanel.add((Component)this.cbShowTagsWithMultiValuesOnly, gridBagConstraints);
        this.cbShowTagsWithConflictsOnly.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TagConflictResolver.this.model.setShowTagsWithConflictsOnly(TagConflictResolver.this.cbShowTagsWithConflictsOnly.isSelected());
                TagConflictResolver.this.cbShowTagsWithMultiValuesOnly.setEnabled(TagConflictResolver.this.cbShowTagsWithConflictsOnly.isSelected());
            }
        });
        this.cbShowTagsWithConflictsOnly.setSelected(Main.pref.getBoolean(this.getClass().getName() + ".showTagsWithConflictsOnly", false));
        this.cbShowTagsWithMultiValuesOnly.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TagConflictResolver.this.model.setShowTagsWithMultiValuesOnly(TagConflictResolver.this.cbShowTagsWithMultiValuesOnly.isSelected());
            }
        });
        this.cbShowTagsWithMultiValuesOnly.setSelected(Main.pref.getBoolean(this.getClass().getName() + ".showTagsWithMultiValuesOnly", false));
        this.cbShowTagsWithMultiValuesOnly.setEnabled(this.cbShowTagsWithConflictsOnly.isSelected());
        return jPanel;
    }

    public void rememberPreferences() {
        Main.pref.put(this.getClass().getName() + ".showTagsWithConflictsOnly", this.cbShowTagsWithConflictsOnly.isSelected());
        Main.pref.put(this.getClass().getName() + ".showTagsWithMultiValuesOnly", this.cbShowTagsWithMultiValuesOnly.isSelected());
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildInfoPanel(), "North");
        this.add((Component)new JScrollPane(new TagConflictResolverTable(this.model)), "Center");
    }

    public TagConflictResolver() {
        this.build();
    }

    public TagConflictResolverModel getModel() {
        return this.model;
    }
}

