/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDownloadTask;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangesetContentDownloadTask
extends PleaseWaitRunnable
implements ChangesetDownloadTask {
    private final List<Integer> toDownload = new ArrayList<Integer>();
    private boolean canceled;
    private Exception lastException;
    private OsmServerChangesetReader reader;
    private Set<Changeset> downloadedChangesets;

    protected void init(Collection<Integer> collection) {
        if (collection == null) {
            collection = Collections.emptyList();
        }
        for (Integer n : collection) {
            if (n == null || n <= 0) continue;
            this.toDownload.add(n);
        }
        this.downloadedChangesets = new HashSet<Changeset>();
    }

    public ChangesetContentDownloadTask(int n) throws IllegalArgumentException {
        super(I18n.tr("Downloading changeset content", new Object[0]), false);
        if (n <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Expected integer value > 0 for parameter ''{0}'', got ''{1}''", "changesetId", n));
        }
        this.init(Collections.singleton(n));
    }

    public ChangesetContentDownloadTask(Collection<Integer> collection) {
        super(I18n.tr("Downloading changeset content", new Object[0]), false);
        this.init(collection);
    }

    public ChangesetContentDownloadTask(Component component, int n) throws IllegalArgumentException {
        super(component, I18n.tr("Downloading changeset content", new Object[0]), false);
        if (n <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Expected integer value > 0 for parameter ''{0}'', got ''{1}''", "changesetId", n));
        }
        this.init(Collections.singleton(n));
    }

    public ChangesetContentDownloadTask(Component component, Collection<Integer> collection) throws IllegalArgumentException {
        super(component, I18n.tr("Downloading changeset content", new Object[0]), false);
        this.init(collection);
    }

    protected boolean isAvailableLocally(int n) {
        return ChangesetCache.getInstance().get(n) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadChangeset(int n) throws OsmTransferException {
        Object object = this;
        synchronized (object) {
            this.reader = new OsmServerChangesetReader();
        }
        object = this.reader.readChangeset(n, this.getProgressMonitor().createSubTaskMonitor(0, false));
        ChangesetContentDownloadTask changesetContentDownloadTask = this;
        synchronized (changesetContentDownloadTask) {
            this.reader = null;
        }
        ChangesetCache.getInstance().update((Changeset)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        ChangesetContentDownloadTask changesetContentDownloadTask = this;
        synchronized (changesetContentDownloadTask) {
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            this.getProgressMonitor().setTicksCount(this.toDownload.size());
            int n = 0;
            for (int n2 : this.toDownload) {
                ++n;
                if (!this.isAvailableLocally(n2)) {
                    this.getProgressMonitor().setCustomText(I18n.tr("({0}/{1}) Downloading changeset {2}...", n, this.toDownload.size(), n2));
                    this.downloadChangeset(n2);
                }
                if (this.canceled) {
                    return;
                }
                Object object = this;
                synchronized (object) {
                    this.reader = new OsmServerChangesetReader();
                }
                this.getProgressMonitor().setCustomText(I18n.tr("({0}/{1}) Downloading content for changeset {2}...", n, this.toDownload.size(), n2));
                object = this.reader.downloadChangeset(n2, this.getProgressMonitor().createSubTaskMonitor(0, false));
                Object object2 = this;
                synchronized (object2) {
                    this.reader = null;
                }
                object2 = ChangesetCache.getInstance().get(n2);
                ((Changeset)object2).setContent((ChangesetDataSet)object);
                ChangesetCache.getInstance().update((Changeset)object2);
                this.downloadedChangesets.add((Changeset)object2);
                this.getProgressMonitor().worked(1);
            }
        }
        catch (OsmTransferCanceledException osmTransferCanceledException) {
            this.canceled = true;
            return;
        }
        catch (OsmTransferException osmTransferException) {
            if (this.canceled) {
                return;
            }
            this.lastException = osmTransferException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
    }

    @Override
    public Set<Changeset> getDownloadedChangesets() {
        return this.downloadedChangesets;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isFailed() {
        return this.lastException != null;
    }
}

