/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.dialogs.relation.IMemberModelListener;
import org.openstreetmap.josm.gui.dialogs.relation.RelationNodeMap;
import org.openstreetmap.josm.gui.dialogs.relation.WayConnectionType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.OsmPrimitivesTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberTableModel
extends AbstractTableModel
implements TableModelListener,
SelectionChangedListener,
DataSetListener,
OsmPrimitivesTableModel {
    private List<RelationMember> members;
    private List<WayConnectionType> connectionType = null;
    private DefaultListSelectionModel listSelectionModel;
    private CopyOnWriteArrayList<IMemberModelListener> listeners;
    private OsmDataLayer layer;
    private final int UNCONNECTED = Integer.MIN_VALUE;
    private static final Collection<AdditionalSorter> additionalSorters = new ArrayList<AdditionalSorter>();
    int firstGroupIdx;
    int lastForwardWay;
    int lastBackwardWay;
    boolean onewayBeginning;

    public MemberTableModel(OsmDataLayer osmDataLayer) {
        this.members = new ArrayList<RelationMember>();
        this.listeners = new CopyOnWriteArrayList();
        this.layer = osmDataLayer;
        this.addTableModelListener(this);
    }

    public OsmDataLayer getLayer() {
        return this.layer;
    }

    public void register() {
        DataSet.addSelectionListener(this);
        this.getLayer().data.addDataSetListener(this);
    }

    public void unregister() {
        DataSet.removeSelectionListener(this);
        this.getLayer().data.removeDataSetListener(this);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (Main.main.getEditLayer() != this.layer) {
            return;
        }
        Collection<RelationMember> collection2 = this.getSelectedMembers();
        this.fireTableDataChanged();
        this.setSelectedMembers(collection2);
    }

    @Override
    public void dataChanged(DataChangedEvent dataChangedEvent) {
        Collection<RelationMember> collection = this.getSelectedMembers();
        this.fireTableDataChanged();
        this.setSelectedMembers(collection);
    }

    @Override
    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
    }

    @Override
    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
        Collection<RelationMember> collection = this.getSelectedMembers();
        for (int i = 0; i < this.members.size(); ++i) {
            if (this.members.get(i).getMember() != tagsChangedEvent.getPrimitive()) continue;
            this.fireTableCellUpdated(i, 1);
        }
        this.setSelectedMembers(collection);
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
    }

    public void addMemberModelListener(IMemberModelListener iMemberModelListener) {
        if (iMemberModelListener != null) {
            this.listeners.addIfAbsent(iMemberModelListener);
        }
    }

    public void removeMemberModelListener(IMemberModelListener iMemberModelListener) {
        this.listeners.remove(iMemberModelListener);
    }

    protected void fireMakeMemberVisible(int n) {
        for (IMemberModelListener iMemberModelListener : this.listeners) {
            iMemberModelListener.makeMemberVisible(n);
        }
    }

    public void populate(Relation relation) {
        this.members.clear();
        if (relation != null) {
            this.members.addAll(new Relation(relation).getMembers());
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.members.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.members.get(n).getRole();
            }
            case 1: {
                return this.members.get(n).getMember();
            }
            case 2: {
                return this.getWayConnection(n);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        RelationMember relationMember = this.members.get(n);
        RelationMember relationMember2 = new RelationMember(object.toString(), relationMember.getMember());
        this.members.remove(n);
        this.members.add(n, relationMember2);
    }

    @Override
    public OsmPrimitive getReferredPrimitive(int n) {
        return this.members.get(n).getMember();
    }

    public void moveUp(int[] nArray) {
        if (!this.canMoveUp(nArray)) {
            return;
        }
        for (int n : nArray) {
            RelationMember relationMember = this.members.get(n);
            RelationMember relationMember2 = this.members.get(n - 1);
            this.members.set(n, relationMember2);
            this.members.set(n - 1, relationMember);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int n : nArray) {
            this.getSelectionModel().addSelectionInterval(--n, n);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(nArray[0] - 1);
    }

    public void moveDown(int[] nArray) {
        if (!this.canMoveDown(nArray)) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            RelationMember relationMember = this.members.get(n);
            RelationMember relationMember2 = this.members.get(n + 1);
            this.members.set(n, relationMember2);
            this.members.set(n + 1, relationMember);
        }
        this.fireTableDataChanged();
        this.getSelectionModel();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int n : nArray) {
            this.getSelectionModel().addSelectionInterval(++n, n);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(nArray[0] + 1);
    }

    public void remove(int[] nArray) {
        if (!this.canRemove(nArray)) {
            return;
        }
        int n = 0;
        for (int n2 : nArray) {
            if (this.members.size() <= (n2 -= n)) continue;
            this.members.remove(n2);
            ++n;
        }
        this.fireTableDataChanged();
    }

    public boolean canMoveUp(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        Arrays.sort(nArray);
        return nArray[0] > 0 && this.members.size() > 0;
    }

    public boolean canMoveDown(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        Arrays.sort(nArray);
        return this.members.size() > 0 && nArray[nArray.length - 1] < this.members.size() - 1;
    }

    public boolean canRemove(int[] nArray) {
        return nArray != null && nArray.length != 0;
    }

    public DefaultListSelectionModel getSelectionModel() {
        if (this.listSelectionModel == null) {
            this.listSelectionModel = new DefaultListSelectionModel();
            this.listSelectionModel.setSelectionMode(2);
        }
        return this.listSelectionModel;
    }

    public void removeMembersReferringTo(List<? extends OsmPrimitive> list) {
        if (list == null) {
            return;
        }
        Iterator<RelationMember> iterator = this.members.iterator();
        while (iterator.hasNext()) {
            RelationMember relationMember = iterator.next();
            if (!list.contains(relationMember.getMember())) continue;
            iterator.remove();
        }
        this.fireTableDataChanged();
    }

    public void applyToRelation(Relation relation) {
        relation.setMembers(this.members);
    }

    public boolean hasSameMembersAs(Relation relation) {
        if (relation == null) {
            return false;
        }
        if (relation.getMembersCount() != this.members.size()) {
            return false;
        }
        for (int i = 0; i < relation.getMembersCount(); ++i) {
            if (relation.getMember(i).equals(this.members.get(i))) continue;
            return false;
        }
        return true;
    }

    public Set<OsmPrimitive> getIncompleteMemberPrimitives() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember relationMember : this.members) {
            if (!relationMember.getMember().isIncomplete()) continue;
            hashSet.add(relationMember.getMember());
        }
        return hashSet;
    }

    public Set<OsmPrimitive> getSelectedIncompleteMemberPrimitives() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember relationMember : this.getSelectedMembers()) {
            if (!relationMember.getMember().isIncomplete()) continue;
            hashSet.add(relationMember.getMember());
        }
        return hashSet;
    }

    public boolean hasIncompleteMembers() {
        for (RelationMember relationMember : this.members) {
            if (!relationMember.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }

    public boolean hasIncompleteSelectedMembers() {
        for (RelationMember relationMember : this.getSelectedMembers()) {
            if (!relationMember.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }

    protected List<Integer> getSelectedIndices() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.members.size(); ++i) {
            if (!this.getSelectionModel().isSelectedIndex(i)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    private void addMembersAtIndex(List<? extends OsmPrimitive> list, int n) {
        if (list == null) {
            return;
        }
        int n2 = n;
        for (OsmPrimitive osmPrimitive : list) {
            RelationMember relationMember = new RelationMember("", osmPrimitive);
            this.members.add(n2++, relationMember);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().clearSelection();
        this.getSelectionModel().addSelectionInterval(n, n + list.size() - 1);
        this.fireMakeMemberVisible(n);
    }

    public void addMembersAtBeginning(List<? extends OsmPrimitive> list) {
        this.addMembersAtIndex(list, 0);
    }

    public void addMembersAtEnd(List<? extends OsmPrimitive> list) {
        this.addMembersAtIndex(list, this.members.size());
    }

    public void addMembersBeforeIdx(List<? extends OsmPrimitive> list, int n) {
        this.addMembersAtIndex(list, n);
    }

    public void addMembersAfterIdx(List<? extends OsmPrimitive> list, int n) {
        this.addMembersAtIndex(list, n + 1);
    }

    public int getNumMembersWithPrimitive(OsmPrimitive osmPrimitive) {
        int n = 0;
        for (RelationMember relationMember : this.members) {
            if (!relationMember.getMember().equals(osmPrimitive)) continue;
            ++n;
        }
        return n;
    }

    public void updateRole(int[] nArray, String string) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        for (int n : nArray) {
            RelationMember relationMember = this.members.get(n);
            RelationMember relationMember2 = new RelationMember(string, relationMember.getMember());
            this.members.remove(n);
            this.members.add(n, relationMember2);
        }
        this.fireTableDataChanged();
        for (int n : nArray) {
            this.getSelectionModel().addSelectionInterval(n, n);
        }
    }

    public Collection<RelationMember> getSelectedMembers() {
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
        for (int n : this.getSelectedIndices()) {
            arrayList.add(this.members.get(n));
        }
        return arrayList;
    }

    public Collection<OsmPrimitive> getSelectedChildPrimitives() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        for (RelationMember relationMember : this.getSelectedMembers()) {
            arrayList.add(relationMember.getMember());
        }
        return arrayList;
    }

    public Set<OsmPrimitive> getChildPrimitives(Collection<? extends OsmPrimitive> collection) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        if (collection == null) {
            return null;
        }
        for (RelationMember relationMember : this.members) {
            if (!collection.contains(relationMember.getMember())) continue;
            hashSet.add(relationMember.getMember());
        }
        return hashSet;
    }

    public void setSelectedMembers(Collection<RelationMember> collection) {
        if (collection == null || collection.isEmpty()) {
            this.getSelectionModel().clearSelection();
            return;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (RelationMember relationMember : collection) {
            for (int i = 0; i < this.members.size(); ++i) {
                if (!relationMember.equals(this.members.get(i))) continue;
                hashSet.add(i);
            }
        }
        this.setSelectedMembersIdx(hashSet);
    }

    public void setSelectedMembersIdx(Collection<Integer> collection) {
        if (collection == null || collection.isEmpty()) {
            this.getSelectionModel().clearSelection();
            return;
        }
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int n : collection) {
            this.getSelectionModel().addSelectionInterval(n, n);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        if (collection.size() > 0) {
            this.fireMakeMemberVisible(Collections.min(collection));
        }
    }

    public boolean isEditableRelation(int n) {
        if (n < 0 || n >= this.members.size()) {
            return false;
        }
        RelationMember relationMember = this.members.get(n);
        if (!relationMember.isRelation()) {
            return false;
        }
        Relation relation = relationMember.getRelation();
        return !relation.isIncomplete();
    }

    public static boolean hasMembersReferringTo(Collection<RelationMember> collection, Collection<OsmPrimitive> collection2) {
        if (collection2 == null || collection2.isEmpty()) {
            return false;
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember primitiveId : collection) {
            hashSet.add(primitiveId.getMember());
        }
        for (OsmPrimitive osmPrimitive : collection2) {
            if (!hashSet.contains(osmPrimitive)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMembersReferringTo(Collection<OsmPrimitive> collection) {
        return MemberTableModel.hasMembersReferringTo(this.members, collection);
    }

    public void selectMembersReferringTo(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            return;
        }
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < this.members.size(); ++i) {
            RelationMember relationMember = this.members.get(i);
            if (!collection.contains(relationMember.getMember())) continue;
            this.getSelectionModel().addSelectionInterval(i, i);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        if (this.getSelectedIndices().size() > 0) {
            this.fireMakeMemberVisible(this.getSelectedIndices().get(0));
        }
    }

    public boolean isInJosmSelection(OsmPrimitive osmPrimitive) {
        return this.layer.data.isSelected(osmPrimitive);
    }

    protected boolean isActiveLayer() {
        if (Main.map == null || Main.map.mapView == null) {
            return false;
        }
        return Main.map.mapView.getActiveLayer() == this.layer;
    }

    private List<RelationMember> sortMembers(List<RelationMember> list) {
        Serializable serializable;
        Integer n;
        RelationNodeMap relationNodeMap = new RelationNodeMap(list);
        ArrayList arrayList = new ArrayList();
        while ((n = relationNodeMap.pop()) != null) {
            LinkedList<Serializable> linkedList = new LinkedList<Serializable>();
            linkedList.add(n);
            arrayList.add(linkedList);
            serializable = n;
            while ((serializable = relationNodeMap.popAdjacent((Integer)serializable)) != null) {
                linkedList.addLast(serializable);
            }
            serializable = n;
            while ((serializable = relationNodeMap.popAdjacent((Integer)serializable)) != null) {
                linkedList.addFirst(serializable);
            }
        }
        serializable = new ArrayList();
        for (LinkedList cloneable2 : arrayList) {
            for (Integer n2 : cloneable2) {
                ((ArrayList)serializable).add(list.get(n2));
            }
        }
        LinkedList<RelationMember> linkedList = new LinkedList();
        HashMap<AdditionalSorter, LinkedList<RelationMember>> hashMap = new HashMap<AdditionalSorter, LinkedList<RelationMember>>();
        for (Integer n3 : relationNodeMap.getNotSortableMembers()) {
            RelationMember relationMember = list.get(n3);
            for (AdditionalSorter additionalSorter : additionalSorters) {
                LinkedList<RelationMember> linkedList2 = linkedList;
                if (additionalSorter.acceptsMember(relationMember) && (linkedList2 = (List)hashMap.get(additionalSorter)) == null) {
                    linkedList2 = new LinkedList<RelationMember>();
                    hashMap.put(additionalSorter, linkedList2);
                }
                linkedList2.add(relationMember);
            }
        }
        for (AdditionalSorter additionalSorter : hashMap.keySet()) {
            ((ArrayList)serializable).addAll(additionalSorter.sortMembers((List)hashMap.get(additionalSorter)));
        }
        ((ArrayList)serializable).addAll(linkedList);
        return serializable;
    }

    void sort() {
        List<RelationMember> list;
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>(this.getSelectedMembers());
        List<RelationMember> list2 = null;
        if (arrayList.size() <= 1) {
            list2 = list = this.sortMembers(this.members);
        } else {
            list2 = this.sortMembers(arrayList);
            List<Integer> list3 = this.getSelectedIndices();
            list = new ArrayList<RelationMember>();
            boolean bl = false;
            for (int i = 0; i < this.members.size(); ++i) {
                if (list3.contains(i)) {
                    if (bl) continue;
                    list.addAll(list2);
                    bl = true;
                    continue;
                }
                list.add(this.members.get(i));
            }
        }
        if (this.members.size() != list.size()) {
            throw new AssertionError();
        }
        this.members.clear();
        this.members.addAll(list);
        this.fireTableDataChanged();
        this.setSelectedMembers(list2);
    }

    private WayConnectionType.Direction determineDirection(int n, WayConnectionType.Direction direction, int n2) {
        return this.determineDirection(n, direction, n2, false);
    }

    private WayConnectionType.Direction determineDirection(int n, WayConnectionType.Direction direction, int n2, boolean bl) {
        if (n < 0 || n2 < 0 || n >= this.members.size() || n2 >= this.members.size()) {
            return WayConnectionType.Direction.NONE;
        }
        if (direction == WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.NONE;
        }
        RelationMember relationMember = this.members.get(n);
        RelationMember relationMember2 = this.members.get(n2);
        Way way = null;
        Way way2 = null;
        if (relationMember.isWay()) {
            way = relationMember.getWay();
        }
        if (relationMember2.isWay()) {
            way2 = relationMember2.getWay();
        }
        if (way == null || way2 == null) {
            return WayConnectionType.Direction.NONE;
        }
        List<Object> list = new ArrayList<Node>();
        switch (direction) {
            case FORWARD: {
                list.add(way.lastNode());
                break;
            }
            case BACKWARD: {
                list.add(way.firstNode());
                break;
            }
            case ROUNDABOUT_LEFT: 
            case ROUNDABOUT_RIGHT: {
                list = way.getNodes();
            }
        }
        if (list == null) {
            return WayConnectionType.Direction.NONE;
        }
        for (Node node : list) {
            if (node == null) continue;
            if (this.roundaboutType(n2) != WayConnectionType.Direction.NONE) {
                for (Node node2 : way2.getNodes()) {
                    if (node != node2) continue;
                    return this.roundaboutType(n2);
                }
                continue;
            }
            if (MemberTableModel.isOneway(relationMember2)) {
                if (node == RelationNodeMap.firstOnewayNode(relationMember2) && !bl) {
                    if (MemberTableModel.isBackward(relationMember2)) {
                        return WayConnectionType.Direction.BACKWARD;
                    }
                    return WayConnectionType.Direction.FORWARD;
                }
                if (node != RelationNodeMap.lastOnewayNode(relationMember2) || !bl) continue;
                if (MemberTableModel.isBackward(relationMember2)) {
                    return WayConnectionType.Direction.FORWARD;
                }
                return WayConnectionType.Direction.BACKWARD;
            }
            if (node == way2.firstNode()) {
                return WayConnectionType.Direction.FORWARD;
            }
            if (node != way2.lastNode()) continue;
            return WayConnectionType.Direction.BACKWARD;
        }
        return WayConnectionType.Direction.NONE;
    }

    private WayConnectionType.Direction roundaboutType(int n) {
        RelationMember relationMember = this.members.get(n);
        if (relationMember == null || !relationMember.isWay()) {
            return WayConnectionType.Direction.NONE;
        }
        Way way = relationMember.getWay();
        return MemberTableModel.roundaboutType(way);
    }

    static WayConnectionType.Direction roundaboutType(Way way) {
        if (way != null && "roundabout".equals(way.get("junction")) && way.getNodesCount() < 200 && way.getNodesCount() > 2 && way.getNode(0) != null && way.getNode(1) != null && way.getNode(2) != null && way.firstNode() == way.lastNode()) {
            EastNorth eastNorth = way.getNode(0).getEastNorth();
            EastNorth eastNorth2 = way.getNode(1).getEastNorth();
            EastNorth eastNorth3 = way.getNode(2).getEastNorth();
            if (eastNorth != null && eastNorth2 != null && eastNorth3 != null) {
                eastNorth = eastNorth.sub(eastNorth2);
                eastNorth2 = eastNorth2.sub(eastNorth3);
                return eastNorth.north() * eastNorth2.east() - eastNorth2.north() * eastNorth.east() > 0.0 ? WayConnectionType.Direction.ROUNDABOUT_LEFT : WayConnectionType.Direction.ROUNDABOUT_RIGHT;
            }
        }
        return WayConnectionType.Direction.NONE;
    }

    WayConnectionType getWayConnection(int n) {
        if (this.connectionType == null) {
            this.updateLinks();
        }
        return this.connectionType.get(n);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.connectionType = null;
    }

    void reverse() {
        List<Integer> list = this.getSelectedIndices();
        List<Integer> list2 = this.getSelectedIndices();
        if (list.size() <= 1) {
            Collections.reverse(this.members);
            this.fireTableDataChanged();
            this.setSelectedMembers(this.members);
        } else {
            Collections.reverse(list2);
            ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>(this.members);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.set(list.get(i), this.members.get(list2.get(i)));
            }
            if (this.members.size() != arrayList.size()) {
                throw new AssertionError();
            }
            this.members.clear();
            this.members.addAll(arrayList);
            this.fireTableDataChanged();
            this.setSelectedMembersIdx(list);
        }
    }

    public void updateLinks() {
        this.connectionType = null;
        ArrayList<WayConnectionType> arrayList = new ArrayList<WayConnectionType>();
        for (int i = 0; i < this.members.size(); ++i) {
            arrayList.add(null);
        }
        this.firstGroupIdx = 0;
        this.lastForwardWay = Integer.MIN_VALUE;
        this.lastBackwardWay = Integer.MIN_VALUE;
        this.onewayBeginning = false;
        WayConnectionType wayConnectionType = null;
        for (int i = 0; i < this.members.size(); ++i) {
            RelationMember relationMember = this.members.get(i);
            if (!relationMember.isWay() || relationMember.getWay() == null || relationMember.getWay().isIncomplete()) {
                if (i > 0) {
                    this.makeLoopIfNeeded(arrayList, i - 1);
                }
                arrayList.set(i, new WayConnectionType());
                this.firstGroupIdx = i;
                continue;
            }
            WayConnectionType wayConnectionType2 = new WayConnectionType(false);
            wayConnectionType2.linkPrev = i > 0 && arrayList.get(i - 1) != null && ((WayConnectionType)arrayList.get(i - 1)).isValid();
            wayConnectionType2.direction = WayConnectionType.Direction.NONE;
            if (MemberTableModel.isOneway(relationMember)) {
                if (wayConnectionType != null && wayConnectionType.isOnewayTail) {
                    wayConnectionType2.isOnewayHead = true;
                }
                if (this.lastBackwardWay == Integer.MIN_VALUE && this.lastForwardWay == Integer.MIN_VALUE) {
                    wayConnectionType2.isOnewayHead = true;
                    this.lastForwardWay = i - 1;
                    this.lastBackwardWay = i - 1;
                    this.onewayBeginning = true;
                }
            }
            if (wayConnectionType2.linkPrev) {
                if (this.lastBackwardWay != Integer.MIN_VALUE && this.lastForwardWay != Integer.MIN_VALUE) {
                    wayConnectionType2 = this.determineOnewayConnectionType(arrayList, relationMember, i, wayConnectionType2);
                    if (!wayConnectionType2.linkPrev) {
                        this.firstGroupIdx = i;
                    }
                }
                if (!MemberTableModel.isOneway(relationMember)) {
                    wayConnectionType2.direction = this.determineDirection(i - 1, wayConnectionType.direction, i);
                    boolean bl = wayConnectionType2.linkPrev = wayConnectionType2.direction != WayConnectionType.Direction.NONE;
                }
            }
            if (!wayConnectionType2.linkPrev) {
                wayConnectionType2.direction = this.determineDirectionOfFirst(i, relationMember);
                if (MemberTableModel.isOneway(relationMember)) {
                    wayConnectionType2.isOnewayLoopForwardPart = true;
                    this.lastForwardWay = i;
                }
            }
            wayConnectionType2.linkNext = false;
            if (wayConnectionType != null) {
                wayConnectionType.linkNext = wayConnectionType2.linkPrev;
            }
            arrayList.set(i, wayConnectionType2);
            wayConnectionType = wayConnectionType2;
            if (wayConnectionType2.linkPrev) continue;
            if (i > 0) {
                this.makeLoopIfNeeded(arrayList, i - 1);
            }
            this.firstGroupIdx = i;
        }
        this.makeLoopIfNeeded(arrayList, this.members.size() - 1);
        this.connectionType = arrayList;
    }

    private static WayConnectionType.Direction reverse(WayConnectionType.Direction direction) {
        if (direction == WayConnectionType.Direction.FORWARD) {
            return WayConnectionType.Direction.BACKWARD;
        }
        if (direction == WayConnectionType.Direction.BACKWARD) {
            return WayConnectionType.Direction.FORWARD;
        }
        return direction;
    }

    private static boolean isBackward(RelationMember relationMember) {
        return relationMember.getRole().equals("backward");
    }

    private static boolean isForward(RelationMember relationMember) {
        return relationMember.getRole().equals("forward");
    }

    public static boolean isOneway(RelationMember relationMember) {
        return MemberTableModel.isForward(relationMember) || MemberTableModel.isBackward(relationMember);
    }

    private void makeLoopIfNeeded(List<WayConnectionType> list, int n) {
        boolean bl;
        if (n == this.firstGroupIdx) {
            bl = this.determineDirection(n, WayConnectionType.Direction.FORWARD, n) == WayConnectionType.Direction.FORWARD;
        } else {
            boolean bl2 = bl = this.determineDirection(n, list.get((int)n).direction, this.firstGroupIdx) == list.get((int)this.firstGroupIdx).direction;
        }
        if (bl) {
            for (int i = this.firstGroupIdx; i <= n; ++i) {
                list.get((int)i).isLoop = true;
            }
        }
    }

    private WayConnectionType.Direction determineDirectionOfFirst(int n, RelationMember relationMember) {
        if (this.roundaboutType(n) != WayConnectionType.Direction.NONE) {
            return this.roundaboutType(n);
        }
        if (MemberTableModel.isOneway(relationMember)) {
            if (MemberTableModel.isBackward(relationMember)) {
                return WayConnectionType.Direction.BACKWARD;
            }
            return WayConnectionType.Direction.FORWARD;
        }
        if (this.determineDirection(n, WayConnectionType.Direction.FORWARD, n + 1) != WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.FORWARD;
        }
        if (this.determineDirection(n, WayConnectionType.Direction.BACKWARD, n + 1) != WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.BACKWARD;
        }
        return WayConnectionType.Direction.NONE;
    }

    private WayConnectionType determineOnewayConnectionType(List<WayConnectionType> list, RelationMember relationMember, int n, WayConnectionType wayConnectionType) {
        WayConnectionType.Direction direction = this.determineDirection(this.lastForwardWay, list.get((int)this.lastForwardWay).direction, n);
        WayConnectionType.Direction direction2 = WayConnectionType.Direction.NONE;
        if (this.onewayBeginning) {
            direction2 = this.lastBackwardWay < 0 ? this.determineDirection(this.firstGroupIdx, MemberTableModel.reverse(list.get((int)this.firstGroupIdx).direction), n, true) : this.determineDirection(this.lastBackwardWay, list.get((int)this.lastBackwardWay).direction, n, true);
            if (direction2 != WayConnectionType.Direction.NONE) {
                this.onewayBeginning = false;
            }
        } else {
            direction2 = this.determineDirection(this.lastBackwardWay, list.get((int)this.lastBackwardWay).direction, n, true);
        }
        if (MemberTableModel.isOneway(relationMember)) {
            if (direction2 != WayConnectionType.Direction.NONE) {
                wayConnectionType.direction = direction2;
                this.lastBackwardWay = n;
                wayConnectionType.isOnewayLoopBackwardPart = true;
            }
            if (direction != WayConnectionType.Direction.NONE) {
                wayConnectionType.direction = direction;
                this.lastForwardWay = n;
                wayConnectionType.isOnewayLoopForwardPart = true;
            }
            if (direction == WayConnectionType.Direction.NONE && direction2 == WayConnectionType.Direction.NONE) {
                wayConnectionType.linkPrev = false;
                if (MemberTableModel.isOneway(relationMember)) {
                    wayConnectionType.isOnewayHead = true;
                    this.lastForwardWay = n - 1;
                    this.lastBackwardWay = n - 1;
                } else {
                    this.lastForwardWay = Integer.MIN_VALUE;
                    this.lastBackwardWay = Integer.MIN_VALUE;
                }
                this.onewayBeginning = true;
            }
            if (direction != WayConnectionType.Direction.NONE && direction2 != WayConnectionType.Direction.NONE) {
                if (n + 1 < this.members.size() && this.determineDirection(n, direction, n + 1) != WayConnectionType.Direction.NONE) {
                    wayConnectionType.isOnewayLoopBackwardPart = false;
                    direction2 = WayConnectionType.Direction.NONE;
                    wayConnectionType.direction = direction;
                } else {
                    wayConnectionType.isOnewayLoopForwardPart = false;
                    direction = WayConnectionType.Direction.NONE;
                    wayConnectionType.direction = direction2;
                }
                wayConnectionType.isOnewayTail = true;
            }
        } else {
            this.lastForwardWay = Integer.MIN_VALUE;
            this.lastBackwardWay = Integer.MIN_VALUE;
            if (direction == WayConnectionType.Direction.NONE || direction2 == WayConnectionType.Direction.NONE) {
                wayConnectionType.linkPrev = false;
            }
        }
        return wayConnectionType;
    }

    static {
        additionalSorters.add(new AssociatedStreetSorter());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AssociatedStreetSorter
    implements AdditionalSorter {
        private AssociatedStreetSorter() {
        }

        @Override
        public boolean acceptsMember(RelationMember relationMember) {
            return relationMember != null && relationMember.getRole() != null && relationMember.getRole().equals("house") && relationMember.getMember() != null && relationMember.getMember().get("addr:housenumber") != null;
        }

        @Override
        public List<RelationMember> sortMembers(List<RelationMember> list) {
            Collections.sort(list, new Comparator<RelationMember>(){

                @Override
                public int compare(RelationMember relationMember, RelationMember relationMember2) {
                    String string;
                    if (relationMember == relationMember2 || relationMember.getMember() == relationMember2.getMember()) {
                        return 0;
                    }
                    String string2 = relationMember.getMember().get("addr:housenumber").trim();
                    if (string2.equals(string = relationMember2.getMember().get("addr:housenumber").trim())) {
                        return 0;
                    }
                    String string3 = string2.replaceAll("\\D+", "");
                    String string4 = string.replaceAll("\\D+", "");
                    try {
                        Integer n = Integer.parseInt(string3) - Integer.parseInt(string4);
                        if (n != 0) {
                            return n;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    return string2.compareTo(string);
                }
            });
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AdditionalSorter {
        public boolean acceptsMember(RelationMember var1);

        public List<RelationMember> sortMembers(List<RelationMember> var1);
    }
}

