/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.plugin.PluginListPanel;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreferencesModel;
import org.openstreetmap.josm.gui.preferences.plugin.PluginUpdatePolicyPanel;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.ReadLocalPluginInformationTask;
import org.openstreetmap.josm.plugins.ReadRemotePluginInformationTask;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginPreference
extends DefaultTabPreferenceSetting {
    private JTextField tfFilter;
    private PluginListPanel pnlPluginPreferences;
    private PluginPreferencesModel model;
    private JScrollPane spPluginPreferences;
    private PluginUpdatePolicyPanel pnlPluginUpdatePolicy;
    private boolean pluginPreferencesActivated = false;

    private PluginPreference() {
        super("plugin", I18n.tr("Plugins", new Object[0]), I18n.tr("Configure available plugins.", new Object[0]));
    }

    public static String buildDownloadSummary(PluginDownloadTask pluginDownloadTask) {
        Collection<PluginInformation> collection = pluginDownloadTask.getDownloadedPlugins();
        Collection<PluginInformation> collection2 = pluginDownloadTask.getFailedPlugins();
        StringBuilder stringBuilder = new StringBuilder();
        if (!collection.isEmpty()) {
            stringBuilder.append(I18n.trn("The following plugin has been downloaded <strong>successfully</strong>:", "The following {0} plugins have been downloaded <strong>successfully</strong>:", collection.size(), collection.size()));
            stringBuilder.append("<ul>");
            for (PluginInformation pluginInformation : collection) {
                stringBuilder.append("<li>").append(pluginInformation.name).append(" (").append(pluginInformation.version).append(")").append("</li>");
            }
            stringBuilder.append("</ul>");
        }
        if (!collection2.isEmpty()) {
            stringBuilder.append(I18n.trn("Downloading the following plugin has <strong>failed</strong>:", "Downloading the following {0} plugins has <strong>failed</strong>:", collection2.size(), collection2.size()));
            stringBuilder.append("<ul>");
            for (PluginInformation pluginInformation : collection2) {
                stringBuilder.append("<li>").append(pluginInformation.name).append("</li>");
            }
            stringBuilder.append("</ul>");
        }
        return stringBuilder.toString();
    }

    protected JPanel buildSearchFieldPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel.add((Component)new JLabel(I18n.tr("Search:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.tfFilter = new JTextField();
        jPanel.add((Component)this.tfFilter, gridBagConstraints);
        this.tfFilter.setToolTipText(I18n.tr("Enter a search expression", new Object[0]));
        SelectAllOnFocusGainedDecorator.decorate(this.tfFilter);
        this.tfFilter.getDocument().addDocumentListener(new SearchFieldAdapter());
        return jPanel;
    }

    protected JPanel buildActionPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        jPanel.add(new JButton(new DownloadAvailablePluginsAction()));
        jPanel.add(new JButton(new UpdateSelectedPluginsAction()));
        jPanel.add(new JButton(new ConfigureSitesAction()));
        return jPanel;
    }

    protected JPanel buildPluginListPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.buildSearchFieldPanel(), "North");
        this.model = new PluginPreferencesModel();
        this.pnlPluginPreferences = new PluginListPanel(this.model);
        this.spPluginPreferences = new JScrollPane(this.pnlPluginPreferences);
        this.spPluginPreferences.setHorizontalScrollBarPolicy(31);
        this.spPluginPreferences.setVerticalScrollBarPolicy(20);
        this.spPluginPreferences.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                PluginPreference.this.spPluginPreferences.setBorder(UIManager.getBorder("ScrollPane.border"));
            }

            public void componentHidden(ComponentEvent componentEvent) {
                PluginPreference.this.spPluginPreferences.setBorder(null);
            }
        });
        jPanel.add((Component)this.spPluginPreferences, "Center");
        jPanel.add((Component)this.buildActionPanel(), "South");
        return jPanel;
    }

    protected JPanel buildContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(this.buildPluginListPanel());
        this.pnlPluginUpdatePolicy = new PluginUpdatePolicyPanel();
        jTabbedPane.add(this.pnlPluginUpdatePolicy);
        jTabbedPane.setTitleAt(0, I18n.tr("Plugins", new Object[0]));
        jTabbedPane.setTitleAt(1, I18n.tr("Plugin update policy", new Object[0]));
        jPanel.add((Component)jTabbedPane, "Center");
        return jPanel;
    }

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        PreferenceTabbedPane.PreferencePanel preferencePanel = preferenceTabbedPane.createPreferenceTab(this);
        preferencePanel.add((Component)this.buildContentPanel(), gridBagConstraints);
        this.readLocalPluginInformation();
        this.pluginPreferencesActivated = true;
    }

    private void configureSites() {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("OK", new Object[0]), ImageProvider.get("ok"), I18n.tr("Accept the new plugin sites and close the dialog", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Close the dialog", new Object[0]), null)};
        PluginConfigurationSitesPanel pluginConfigurationSitesPanel = new PluginConfigurationSitesPanel();
        int n = HelpAwareOptionPane.showOptionDialog(this.pnlPluginPreferences, pluginConfigurationSitesPanel, I18n.tr("Configure Plugin Sites", new Object[0]), 3, null, buttonSpecArray, buttonSpecArray[0], null);
        if (n != 0) {
            return;
        }
        List<String> list = pluginConfigurationSitesPanel.getUpdateSites();
        Main.pref.setPluginSites(list);
    }

    public List<PluginInformation> getPluginsScheduledForUpdateOrDownload() {
        return this.model != null ? this.model.getPluginsScheduledForUpdateOrDownload() : null;
    }

    @Override
    public boolean ok() {
        if (!this.pluginPreferencesActivated) {
            return false;
        }
        this.pnlPluginUpdatePolicy.rememberInPreferences();
        if (this.model.isActivePluginsChanged()) {
            LinkedList<String> linkedList = new LinkedList<String>(this.model.getSelectedPluginNames());
            Collections.sort(linkedList);
            Main.pref.putCollection("plugins", linkedList);
            return true;
        }
        return false;
    }

    public void readLocalPluginInformation() {
        final ReadLocalPluginInformationTask readLocalPluginInformationTask = new ReadLocalPluginInformationTask();
        Runnable runnable = new Runnable(){

            public void run() {
                if (readLocalPluginInformationTask.isCanceled()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PluginPreference.this.model.setAvailablePlugins(readLocalPluginInformationTask.getAvailablePlugins());
                        PluginPreference.this.pnlPluginPreferences.refreshView();
                    }
                });
            }
        };
        Main.worker.submit(readLocalPluginInformationTask);
        Main.worker.submit(runnable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PluginConfigurationSitesPanel
    extends JPanel {
        private DefaultListModel model;

        protected void build() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(I18n.tr("Add JOSM Plugin description URL.", new Object[0])), GBC.eol());
            this.model = new DefaultListModel();
            for (String object2 : Main.pref.getPluginSites()) {
                this.model.addElement(object2);
            }
            final JList jList = new JList(this.model);
            this.add((Component)new JScrollPane(jList), GBC.std().fill());
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JButton(new AbstractAction(I18n.tr("Add", new Object[0])){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = JOptionPane.showInputDialog(JOptionPane.getFrameForComponent(PluginConfigurationSitesPanel.this), I18n.tr("Add JOSM Plugin description URL.", new Object[0]), I18n.tr("Enter URL", new Object[0]), 3);
                    if (string != null) {
                        PluginConfigurationSitesPanel.this.model.addElement(string);
                    }
                }
            }), GBC.eol().fill(2));
            jPanel.add((Component)new JButton(new AbstractAction(I18n.tr("Edit", new Object[0])){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jList.getSelectedValue() == null) {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(PluginConfigurationSitesPanel.this), I18n.tr("Please select an entry.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                        return;
                    }
                    String string = (String)JOptionPane.showInputDialog(Main.parent, I18n.tr("Edit JOSM Plugin description URL.", new Object[0]), I18n.tr("JOSM Plugin description URL", new Object[0]), 3, null, null, jList.getSelectedValue());
                    if (string != null) {
                        PluginConfigurationSitesPanel.this.model.setElementAt(string, jList.getSelectedIndex());
                    }
                }
            }), GBC.eol().fill(2));
            jPanel.add((Component)new JButton(new AbstractAction(I18n.tr("Delete", new Object[0])){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jList.getSelectedValue() == null) {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(PluginConfigurationSitesPanel.this), I18n.tr("Please select an entry.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                        return;
                    }
                    PluginConfigurationSitesPanel.this.model.removeElement(jList.getSelectedValue());
                }
            }), GBC.eol().fill(2));
            this.add((Component)jPanel, GBC.eol());
        }

        public PluginConfigurationSitesPanel() {
            this.build();
        }

        public List<String> getUpdateSites() {
            if (this.model.getSize() == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> arrayList = new ArrayList<String>(this.model.getSize());
            for (int i = 0; i < this.model.getSize(); ++i) {
                arrayList.add((String)this.model.get(i));
            }
            return arrayList;
        }
    }

    class SearchFieldAdapter
    implements DocumentListener {
        SearchFieldAdapter() {
        }

        public void filter() {
            String string = PluginPreference.this.tfFilter.getText().trim();
            if (string.equals("")) {
                string = null;
            }
            PluginPreference.this.model.filterDisplayedPlugins(string);
            PluginPreference.this.pnlPluginPreferences.refreshView();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.filter();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.filter();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.filter();
        }
    }

    class ConfigureSitesAction
    extends AbstractAction {
        public ConfigureSitesAction() {
            this.putValue("Name", I18n.tr("Configure sites...", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Configure the list of sites where plugins are downloaded from", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "settings"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PluginPreference.this.configureSites();
        }
    }

    class UpdateSelectedPluginsAction
    extends AbstractAction {
        public UpdateSelectedPluginsAction() {
            this.putValue("Name", I18n.tr("Update plugins", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Update the selected plugins", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
        }

        protected void notifyDownloadResults(PluginDownloadTask pluginDownloadTask) {
            Collection<PluginInformation> collection = pluginDownloadTask.getDownloadedPlugins();
            Collection<PluginInformation> collection2 = pluginDownloadTask.getFailedPlugins();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            stringBuilder.append(PluginPreference.buildDownloadSummary(pluginDownloadTask));
            if (!collection.isEmpty()) {
                stringBuilder.append(I18n.tr("Please restart JOSM to activate the downloaded plugins.", new Object[0]));
            }
            stringBuilder.append("</html>");
            HelpAwareOptionPane.showOptionDialog(PluginPreference.this.pnlPluginPreferences, stringBuilder.toString(), I18n.tr("Update plugins", new Object[0]), !collection2.isEmpty() ? 2 : 1, HelpUtil.ht("/Preferences/Plugins"));
        }

        protected void alertNothingToUpdate() {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        HelpAwareOptionPane.showOptionDialog(PluginPreference.this.pnlPluginPreferences, I18n.tr("All installed plugins are up to date. JOSM does not have to download newer versions.", new Object[0]), I18n.tr("Plugins up to date", new Object[0]), 1, null);
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final List<PluginInformation> list = PluginPreference.this.model.getSelectedPlugins();
            final PluginDownloadTask pluginDownloadTask = new PluginDownloadTask((Component)PluginPreference.this.pnlPluginPreferences, list, I18n.tr("Update plugins", new Object[0]));
            final ReadRemotePluginInformationTask readRemotePluginInformationTask = new ReadRemotePluginInformationTask(Main.pref.getPluginSites());
            final Runnable runnable = new Runnable(){

                public void run() {
                    if (pluginDownloadTask.isCanceled()) {
                        return;
                    }
                    UpdateSelectedPluginsAction.this.notifyDownloadResults(pluginDownloadTask);
                    PluginPreference.this.model.refreshLocalPluginVersion(pluginDownloadTask.getDownloadedPlugins());
                    PluginPreference.this.model.clearPendingPlugins(pluginDownloadTask.getDownloadedPlugins());
                    PluginPreference.this.pnlPluginPreferences.refreshView();
                }
            };
            Runnable runnable2 = new Runnable(){

                public void run() {
                    if (readRemotePluginInformationTask.isCanceled()) {
                        return;
                    }
                    PluginPreference.this.model.updateAvailablePlugins(readRemotePluginInformationTask.getAvailabePlugins());
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        PluginInformation pluginInformation = (PluginInformation)iterator.next();
                        if (pluginInformation.isUpdateRequired()) continue;
                        iterator.remove();
                    }
                    if (list.isEmpty()) {
                        UpdateSelectedPluginsAction.this.alertNothingToUpdate();
                        return;
                    }
                    pluginDownloadTask.setPluginsToDownload(list);
                    Main.worker.submit(pluginDownloadTask);
                    Main.worker.submit(runnable);
                }
            };
            Main.worker.submit(readRemotePluginInformationTask);
            Main.worker.submit(runnable2);
        }
    }

    class DownloadAvailablePluginsAction
    extends AbstractAction {
        public DownloadAvailablePluginsAction() {
            this.putValue("Name", I18n.tr("Download list", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Download the list of available plugins", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("download"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final ReadRemotePluginInformationTask readRemotePluginInformationTask = new ReadRemotePluginInformationTask(Main.pref.getPluginSites());
            Runnable runnable = new Runnable(){

                public void run() {
                    if (readRemotePluginInformationTask.isCanceled()) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            PluginPreference.this.model.updateAvailablePlugins(readRemotePluginInformationTask.getAvailabePlugins());
                            PluginPreference.this.pnlPluginPreferences.refreshView();
                            Main.pref.putInteger("pluginmanager.version", Version.getInstance().getVersion());
                        }
                    });
                }
            };
            Main.worker.submit(readRemotePluginInformationTask);
            Main.worker.submit(runnable);
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new PluginPreference();
        }
    }
}

