/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.io.imagery.HTMLGrabber;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class WMSSettingsPanel
extends JPanel {
    private final JosmComboBox browser = new JosmComboBox(new String[]{"webkit-image {0}", "gnome-web-photo --mode=photo --format=png {0} /dev/stdout", "gnome-web-photo-fixed {0}", "webkit-image-gtk {0}"});
    private final JCheckBox overlapCheckBox;
    private final JSpinner spinEast;
    private final JSpinner spinNorth;
    private final JSpinner spinSimConn;

    public WMSSettingsPanel() {
        super(new GridBagLayout());
        this.browser.setEditable(true);
        this.add((Component)new JLabel(I18n.tr("Downloader:", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.browser, GBC.eol().fill(2));
        this.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        JLabel jLabel = new JLabel(I18n.tr("Simultaneous connections:", new Object[0]));
        this.spinSimConn = new JSpinner(new SpinnerNumberModel(WMSLayer.PROP_SIMULTANEOUS_CONNECTIONS.get(), 1, 30, 1));
        this.add((Component)jLabel, GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.spinSimConn, GBC.eol());
        this.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        this.overlapCheckBox = new JCheckBox(I18n.tr("Overlap tiles", new Object[0]));
        JLabel jLabel2 = new JLabel(I18n.tr("% of east:", new Object[0]));
        JLabel jLabel3 = new JLabel(I18n.tr("% of north:", new Object[0]));
        this.spinEast = new JSpinner(new SpinnerNumberModel(WMSLayer.PROP_OVERLAP_EAST.get(), 1, 50, 1));
        this.spinNorth = new JSpinner(new SpinnerNumberModel(WMSLayer.PROP_OVERLAP_NORTH.get(), 1, 50, 1));
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.overlapCheckBox);
        jPanel.add(jLabel2);
        jPanel.add(this.spinEast);
        jPanel.add(jLabel3);
        jPanel.add(this.spinNorth);
        this.add((Component)jPanel, GBC.eop());
    }

    public void loadSettings() {
        this.browser.setSelectedItem(HTMLGrabber.PROP_BROWSER.get());
        this.overlapCheckBox.setSelected(WMSLayer.PROP_OVERLAP.get());
        this.spinEast.setValue(WMSLayer.PROP_OVERLAP_EAST.get());
        this.spinNorth.setValue(WMSLayer.PROP_OVERLAP_NORTH.get());
        this.spinSimConn.setValue(WMSLayer.PROP_SIMULTANEOUS_CONNECTIONS.get());
    }

    public boolean saveSettings() {
        WMSLayer.PROP_OVERLAP.put(this.overlapCheckBox.getModel().isSelected());
        WMSLayer.PROP_OVERLAP_EAST.put((Integer)this.spinEast.getModel().getValue());
        WMSLayer.PROP_OVERLAP_NORTH.put((Integer)this.spinNorth.getModel().getValue());
        WMSLayer.PROP_SIMULTANEOUS_CONNECTIONS.put((Integer)this.spinSimConn.getModel().getValue());
        HTMLGrabber.PROP_BROWSER.put(this.browser.getEditor().getItem().toString());
        return false;
    }
}

