/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadPrimitiveAction;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadAndZoomHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class LoadObjectHandler
extends RequestHandler {
    public static final String command = "load_object";

    public String[] getMandatoryParams() {
        return new String[]{"objects"};
    }

    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException {
        if (!PermissionPrefWithDefault.LOAD_DATA.isAllowed()) {
            System.out.println("RemoteControl: download forbidden by preferences");
        }
        final LinkedList<PrimitiveId> linkedList = new LinkedList<PrimitiveId>();
        for (String string : ((String)this.args.get("objects")).split(",\\s*")) {
            linkedList.add(SimplePrimitiveId.fromString(string));
        }
        boolean bl = this.isLoadInNewLayer();
        int n = Boolean.parseBoolean((String)this.args.get("relation_members")) ? 1 : 0;
        DownloadPrimitiveAction.processItems(bl, linkedList, true, n != 0);
        Main.worker.submit(new Runnable(){

            public void run() {
                Main.main.getCurrentDataSet().setSelected(linkedList);
                LoadAndZoomHandler.addTags(LoadObjectHandler.this.args);
            }
        });
    }

    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to load objects (specified by their id) from the API.", new Object[0]);
    }

    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.LOAD_DATA;
    }
}

