/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.SVGException;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.xml.StyleAttribute;
import com.kitfox.svg.xml.XMLParseUtil;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class Polyline
extends ShapeElement {
    int fillRule = 1;
    String pointsStrn = "";
    GeneralPath path;

    public void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("points"))) {
            this.pointsStrn = styleAttribute.getStringValue();
        }
        String string = this.getStyle(styleAttribute.setName("fill-rule")) ? styleAttribute.getStringValue() : "nonzero";
        this.fillRule = string.equals("evenodd") ? 0 : 1;
        this.buildPath();
    }

    protected void buildPath() {
        float[] fArray = XMLParseUtil.parseFloatList(this.pointsStrn);
        this.path = new GeneralPath(this.fillRule, fArray.length / 2);
        this.path.moveTo(fArray[0], fArray[1]);
        for (int i = 2; i < fArray.length; i += 2) {
            this.path.lineTo(fArray[i], fArray[i + 1]);
        }
    }

    public void render(Graphics2D graphics2D) throws SVGException {
        this.beginLayer(graphics2D);
        this.renderShape(graphics2D, this.path);
        this.finishLayer(graphics2D);
    }

    public Shape getShape() {
        return this.shapeToParent(this.path);
    }

    public Rectangle2D getBoundingBox() throws SVGException {
        return this.boundsToParent(this.includeStrokeInBounds(this.path.getBounds2D()));
    }

    public boolean updateTime(double d) throws SVGException {
        String string;
        boolean bl = super.updateTime(d);
        StyleAttribute styleAttribute = new StyleAttribute();
        boolean bl2 = false;
        if (this.getStyle(styleAttribute.setName("fill-rule"))) {
            int n;
            int n2 = n = styleAttribute.getStringValue().equals("evenodd") ? 0 : 1;
            if (n != this.fillRule) {
                this.fillRule = n;
                bl2 = true;
            }
        }
        if (this.getPres(styleAttribute.setName("points")) && !(string = styleAttribute.getStringValue()).equals(this.pointsStrn)) {
            this.pointsStrn = string;
            bl2 = true;
        }
        if (bl2) {
            this.build();
        }
        return bl || bl2;
    }
}

