/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Group;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class Symbol
extends Group {
    AffineTransform viewXform;
    Rectangle2D viewBox;

    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("viewBox"))) {
            float[] fArray = styleAttribute.getFloatList();
            this.viewBox = new Rectangle2D.Float(fArray[0], fArray[1], fArray[2], fArray[3]);
        }
        if (this.viewBox == null) {
            this.viewBox = new Rectangle(0, 0, 1, 1);
        }
        this.viewXform = new AffineTransform();
        this.viewXform.scale(1.0 / this.viewBox.getWidth(), 1.0 / this.viewBox.getHeight());
        this.viewXform.translate(-this.viewBox.getX(), -this.viewBox.getY());
    }

    protected boolean outsideClip(Graphics2D graphics2D) throws SVGException {
        graphics2D.getClipBounds(this.clipBounds);
        Rectangle2D rectangle2D = super.getBoundingBox();
        return !rectangle2D.intersects(this.clipBounds);
    }

    public void render(Graphics2D graphics2D) throws SVGException {
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.transform(this.viewXform);
        super.render(graphics2D);
        graphics2D.setTransform(affineTransform);
    }

    public Shape getShape() {
        Shape shape = super.getShape();
        return this.viewXform.createTransformedShape(shape);
    }

    public Rectangle2D getBoundingBox() throws SVGException {
        Rectangle2D rectangle2D = super.getBoundingBox();
        return this.viewXform.createTransformedShape(rectangle2D).getBounds2D();
    }

    public boolean updateTime(double d) throws SVGException {
        boolean bl = super.updateTime(d);
        return bl;
    }
}

