/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class TileController {
    protected TileLoader tileLoader;
    protected TileCache tileCache;
    protected TileSource tileSource = new OsmTileSource.Mapnik();
    JobDispatcher jobDispatcher;

    public TileController(TileSource tileSource, TileCache tileCache, TileLoaderListener tileLoaderListener) {
        this.tileLoader = new OsmTileLoader(tileLoaderListener);
        this.tileCache = tileCache;
        this.jobDispatcher = JobDispatcher.getInstance();
    }

    public Tile getTile(int n, int n2, int n3) {
        int n4 = 1 << n3;
        if (n < 0 || n >= n4 || n2 < 0 || n2 >= n4) {
            return null;
        }
        Tile tile = this.tileCache.getTile(this.tileSource, n, n2, n3);
        if (tile == null) {
            tile = new Tile(this.tileSource, n, n2, n3);
            this.tileCache.addTile(tile);
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        if (tile.error) {
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        if (!tile.isLoaded()) {
            this.jobDispatcher.addJob(this.tileLoader.createTileLoaderJob(tile));
        }
        return tile;
    }

    public TileCache getTileCache() {
        return this.tileCache;
    }

    public void setTileCache(TileCache tileCache) {
        this.tileCache = tileCache;
    }

    public TileLoader getTileLoader() {
        return this.tileLoader;
    }

    public void setTileLoader(TileLoader tileLoader) {
        this.tileLoader = tileLoader;
    }

    public TileSource getTileLayerSource() {
        return this.tileSource;
    }

    public TileSource getTileSource() {
        return this.tileSource;
    }

    public void setTileSource(TileSource tileSource) {
        this.tileSource = tileSource;
    }

    public void cancelOutstandingJobs() {
        this.jobDispatcher.cancelOutstandingJobs();
    }
}

