/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DuplicateRelationAction
extends AbstractRelationAction {
    public DuplicateRelationAction() {
        this.putValue("ShortDescription", I18n.tr("Create a copy of this relation and open it in another editor window", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("duplicate"));
        this.putValue("Name", I18n.tr("Duplicate", new Object[0]));
    }

    public static void duplicateRelationAndLaunchEditor(Relation relation) {
        Relation relation2 = new Relation(relation, true);
        relation2.setModified(true);
        RelationEditor relationEditor = RelationEditor.getEditor(Main.main.getEditLayer(), relation2, null);
        relationEditor.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled() || this.relations.size() == 0) {
            return;
        }
        Relation relation = (Relation)this.relations.iterator().next();
        DuplicateRelationAction.duplicateRelationAndLaunchEditor(relation);
    }

    protected void updateEnabledState() {
        this.setEnabled(this.relations.size() == 1);
    }
}

