/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shape {
    private List<Coordinate> coords = new ArrayList<Coordinate>();

    public Shape(String string, String string2) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(string, "asString");
        String[] stringArray = string.split(string2);
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException(MessageFormat.format("Even number of doubles expected in string, got {0}: {1}", stringArray.length, string));
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            this.addPoint(stringArray[i], stringArray[i + 1]);
        }
    }

    public Shape() {
    }

    public String encodeAsString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Coordinate coordinate : this.coords) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(coordinate.getLat()).append(string).append(coordinate.getLon());
        }
        return stringBuffer.toString();
    }

    public List<Coordinate> getPoints() {
        return this.coords;
    }

    public boolean contains(LatLon latLon) {
        if (latLon == null) {
            return false;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(this.coords.size());
        for (Coordinate coordinate : this.coords) {
            arrayList.add(new Node(new LatLon(coordinate.getLat(), coordinate.getLon())));
        }
        return Geometry.nodeInsidePolygon(new Node(latLon), arrayList);
    }

    public void addPoint(String string, String string2) throws IllegalArgumentException {
        double d;
        double d2;
        CheckParameterUtil.ensureParameterNotNull(string, "sLat");
        CheckParameterUtil.ensureParameterNotNull(string2, "sLon");
        try {
            d2 = Double.parseDouble(string);
            if (!LatLon.isValidLat(d2)) {
                throw new IllegalArgumentException(I18n.tr("Illegal latitude value ''{0}''", d2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal double value ''{0}''", string));
        }
        try {
            d = Double.parseDouble(string2);
            if (!LatLon.isValidLon(d)) {
                throw new IllegalArgumentException(I18n.tr("Illegal longitude value ''{0}''", d));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal double value ''{0}''", string2));
        }
        this.coords.add(new Coordinate(LatLon.roundToOsmPrecision(d2), LatLon.roundToOsmPrecision(d)));
    }
}

