/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;

public class TransverseMercator
implements Proj {
    protected double a;
    protected double b;

    public String getName() {
        return I18n.tr("Transverse Mercator", new Object[0]);
    }

    public String getProj4Id() {
        return "tmerc";
    }

    public void initialize(ProjParameters projParameters) throws ProjectionConfigurationException {
        this.a = projParameters.ellps.a;
        this.b = projParameters.ellps.b;
    }

    public double[] project(double d, double d2) {
        double d3 = (Math.pow(this.a, 2.0) - Math.pow(this.b, 2.0)) / Math.pow(this.b, 2.0);
        double d4 = d3 * Math.pow(Math.cos(d), 2.0);
        double d5 = this.a / (this.b * Math.sqrt(1.0 + d4));
        double d6 = Math.tan(d);
        double d7 = d6 * d6;
        double d8 = d2;
        double d9 = 1.0 - d7 + d4;
        double d10 = 5.0 - d7 + 9.0 * d4 + 4.0 * (d4 * d4);
        double d11 = 5.0 - 18.0 * d7 + d7 * d7 + 14.0 * d4 - 58.0 * d7 * d4;
        double d12 = 61.0 - 58.0 * d7 + d7 * d7 + 270.0 * d4 - 330.0 * d7 * d4;
        double d13 = 61.0 - 479.0 * d7 + 179.0 * (d7 * d7) - d7 * d7 * d7;
        double d14 = 1385.0 - 3111.0 * d7 + 543.0 * (d7 * d7) - d7 * d7 * d7;
        return new double[]{d5 * Math.cos(d) * d8 + d5 / 6.0 * Math.pow(Math.cos(d), 3.0) * d9 * Math.pow(d8, 3.0) + d5 / 120.0 * Math.pow(Math.cos(d), 5.0) * d11 * Math.pow(d8, 5.0) + d5 / 5040.0 * Math.pow(Math.cos(d), 7.0) * d13 * Math.pow(d8, 7.0), this.ArcLengthOfMeridian(d) / this.a + d6 / 2.0 * d5 * Math.pow(Math.cos(d), 2.0) * Math.pow(d8, 2.0) + d6 / 24.0 * d5 * Math.pow(Math.cos(d), 4.0) * d10 * Math.pow(d8, 4.0) + d6 / 720.0 * d5 * Math.pow(Math.cos(d), 6.0) * d12 * Math.pow(d8, 6.0) + d6 / 40320.0 * d5 * Math.pow(Math.cos(d), 8.0) * d14 * Math.pow(d8, 8.0)};
    }

    public double[] invproject(double d, double d2) {
        double d3;
        double d4 = this.footpointLatitude(d2);
        double d5 = (this.a * this.a - this.b * this.b) / (this.b * this.b);
        double d6 = Math.cos(d4);
        double d7 = d5 * Math.pow(d6, 2.0);
        double d8 = d3 = this.a / (this.b * Math.sqrt(1.0 + d7));
        double d9 = Math.tan(d4);
        double d10 = d9 * d9;
        double d11 = d10 * d10;
        double d12 = 1.0 / (d8 * d6);
        double d13 = d9 / (2.0 * (d8 *= d3));
        double d14 = 1.0 / (6.0 * (d8 *= d3) * d6);
        double d15 = d9 / (24.0 * (d8 *= d3));
        double d16 = 1.0 / (120.0 * (d8 *= d3) * d6);
        double d17 = d9 / (720.0 * (d8 *= d3));
        double d18 = 1.0 / (5040.0 * (d8 *= d3) * d6);
        double d19 = d9 / (40320.0 * (d8 *= d3));
        double d20 = -1.0 - d7;
        double d21 = -1.0 - 2.0 * d10 - d7;
        double d22 = 5.0 + 3.0 * d10 + 6.0 * d7 - 6.0 * d10 * d7 - 3.0 * (d7 * d7) - 9.0 * d10 * (d7 * d7);
        double d23 = 5.0 + 28.0 * d10 + 24.0 * d11 + 6.0 * d7 + 8.0 * d10 * d7;
        double d24 = -61.0 - 90.0 * d10 - 45.0 * d11 - 107.0 * d7 + 162.0 * d10 * d7;
        double d25 = -61.0 - 662.0 * d10 - 1320.0 * d11 - 720.0 * (d11 * d10);
        double d26 = 1385.0 + 3633.0 * d10 + 4095.0 * d11 + 1575.0 * (d11 * d10);
        return new double[]{d4 + d13 * d20 * (d * d) + d15 * d22 * Math.pow(d, 4.0) + d17 * d24 * Math.pow(d, 6.0) + d19 * d26 * Math.pow(d, 8.0), d12 * d + d14 * d21 * Math.pow(d, 3.0) + d16 * d23 * Math.pow(d, 5.0) + d18 * d25 * Math.pow(d, 7.0)};
    }

    private double ArcLengthOfMeridian(double d) {
        double d2 = (this.a - this.b) / (this.a + this.b);
        double d3 = (this.a + this.b) / 2.0 * (1.0 + Math.pow(d2, 2.0) / 4.0 + Math.pow(d2, 4.0) / 64.0);
        double d4 = -3.0 * d2 / 2.0 + 9.0 * Math.pow(d2, 3.0) / 16.0 + -3.0 * Math.pow(d2, 5.0) / 32.0;
        double d5 = 15.0 * Math.pow(d2, 2.0) / 16.0 + -15.0 * Math.pow(d2, 4.0) / 32.0;
        double d6 = -35.0 * Math.pow(d2, 3.0) / 48.0 + 105.0 * Math.pow(d2, 5.0) / 256.0;
        double d7 = 315.0 * Math.pow(d2, 4.0) / 512.0;
        return d3 * (d + d4 * Math.sin(2.0 * d) + d5 * Math.sin(4.0 * d) + d6 * Math.sin(6.0 * d) + d7 * Math.sin(8.0 * d));
    }

    private double footpointLatitude(double d) {
        double d2 = (this.a - this.b) / (this.a + this.b);
        double d3 = (this.a + this.b) / 2.0 * (1.0 + Math.pow(d2, 2.0) / 4.0 + Math.pow(d2, 4.0) / 64.0);
        double d4 = d / d3 * this.a;
        double d5 = 3.0 * d2 / 2.0 + -27.0 * Math.pow(d2, 3.0) / 32.0 + 269.0 * Math.pow(d2, 5.0) / 512.0;
        double d6 = 21.0 * Math.pow(d2, 2.0) / 16.0 + -55.0 * Math.pow(d2, 4.0) / 32.0;
        double d7 = 151.0 * Math.pow(d2, 3.0) / 96.0 + -417.0 * Math.pow(d2, 5.0) / 128.0;
        double d8 = 1097.0 * Math.pow(d2, 4.0) / 512.0;
        return d4 + d5 * Math.sin(2.0 * d4) + d6 * Math.sin(4.0 * d4) + d7 * Math.sin(6.0 * d4) + d8 * Math.sin(8.0 * d4);
    }
}

