/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class Highways
extends Test {
    protected static final int WRONG_ROUNDABOUT_HIGHWAY = 2701;
    protected static final List<String> CLASSIFIED_HIGHWAYS = Arrays.asList("motorway", "trunk", "primary", "secondary", "tertiary", "living_street", "residential", "unclassified");

    public Highways() {
        super(I18n.tr("Highways", new Object[0]), I18n.tr("Performs semantic checks on highways.", new Object[0]));
    }

    public void visit(Way way) {
        if (way.isUsable() && way.hasKey("highway") && way.hasKey("junction") && way.get("junction").equals("roundabout")) {
            List list;
            HashMap hashMap = new HashMap();
            for (Node object : new HashSet<Node>(way.getNodes())) {
                for (Comparable<OsmPrimitive> comparable : Utils.filteredCollection(object.getReferrers(), Way.class)) {
                    if (comparable == way || !((AbstractPrimitive)((Object)comparable)).hasKey("highway")) continue;
                    list = (List)hashMap.get(((AbstractPrimitive)((Object)comparable)).get("highway"));
                    if (list == null) {
                        list = new ArrayList();
                        hashMap.put(((AbstractPrimitive)((Object)comparable)).get("highway"), list);
                    }
                    list.add(comparable);
                }
            }
            for (String string : CLASSIFIED_HIGHWAYS) {
                Comparable<OsmPrimitive> comparable;
                List list2 = (List)hashMap.get(string);
                if (list2 == null || list2.size() < 2) continue;
                comparable = OsmUtils.getOsmBoolean(((Way)list2.get(0)).get("oneway"));
                list = OsmUtils.getOsmBoolean(((Way)list2.get(1)).get("oneway"));
                if (list2.size() <= 2 && comparable != null && list != null && ((Boolean)comparable).booleanValue() && ((Boolean)((Object)list)).booleanValue()) continue;
                if (way.get("highway").equals(string)) break;
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Incorrect roundabout (highway: {0} instead of {1})", way.get("highway"), string), 2701, way));
                break;
            }
        }
    }

    public boolean isFixable(TestError testError) {
        return testError instanceof WrongRoundaboutHighway;
    }

    public Command fixError(TestError testError) {
        if (testError instanceof WrongRoundaboutHighway) {
            return new ChangePropertyCommand(testError.getPrimitives().iterator().next(), "highway", ((WrongRoundaboutHighway)testError).correctValue);
        }
        return null;
    }

    protected class WrongRoundaboutHighway
    extends TestError {
        public final String correctValue;

        public WrongRoundaboutHighway(Way way, String string) {
            super((Test)Highways.this, Severity.WARNING, I18n.tr("Incorrect roundabout (highway: {0} instead of {1})", way.get("highway"), string), 2701, way);
            this.correctValue = string;
        }
    }
}

