/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.ValUtil;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;

public class SimilarNamedWays
extends Test {
    protected static final int SIMILAR_NAMED = 701;
    Map<Point2D, List<Way>> cellWays;
    MultiMap<Way, Way> errorWays;

    public SimilarNamedWays() {
        super(I18n.tr("Similarly named ways", new Object[0]), I18n.tr("This test checks for ways with similar names that may have been misspelled.", new Object[0]));
    }

    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.cellWays = new HashMap<Point2D, List<Way>>(1000);
        this.errorWays = new MultiMap();
    }

    public void endTest() {
        this.cellWays = null;
        this.errorWays = null;
        super.endTest();
    }

    public void visit(Way way) {
        if (!way.isUsable()) {
            return;
        }
        String string = way.get("name");
        if (string == null || string.length() < 6) {
            return;
        }
        List<List<Way>> list = ValUtil.getWaysInCell(way, this.cellWays);
        for (List<Way> list2 : list) {
            for (Way way2 : list2) {
                int n;
                String string2;
                if (this.errorWays.contains(way, way2) || this.errorWays.contains(way2, way) || (string2 = way2.get("name")) == null || string2.length() < 6 || 0 >= (n = this.getLevenshteinDistance(string, string2)) || n > 2) continue;
                ArrayList<Way> arrayList = new ArrayList<Way>();
                arrayList.add(way);
                arrayList.add(way2);
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Similarly named ways", new Object[0]), 701, arrayList));
                this.errorWays.put(way, way2);
            }
            list2.add(way);
        }
    }

    public int getLevenshteinDistance(String string, String string2) {
        int n;
        int n2;
        int n3 = string.length();
        int n4 = string2.length();
        if (n3 == 0) {
            return n4;
        }
        if (n4 == 0) {
            return n3;
        }
        int[][] nArray = new int[n3 + 1][n4 + 1];
        for (n2 = 0; n2 <= n3; ++n2) {
            nArray[n2][0] = n2;
        }
        for (n = 0; n <= n4; ++n) {
            nArray[0][n] = n;
        }
        for (n2 = 1; n2 <= n3; ++n2) {
            char c = string.charAt(n2 - 1);
            for (n = 1; n <= n4; ++n) {
                char c2 = string2.charAt(n - 1);
                int n5 = c == c2 ? 0 : 1;
                nArray[n2][n] = Utils.min(nArray[n2 - 1][n] + 1, nArray[n2][n - 1] + 1, nArray[n2 - 1][n - 1] + n5);
            }
        }
        return nArray[n3][n4];
    }
}

