/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatableComponent
extends JComponent
implements Helpful {
    public static final IntegerProperty PROP_SNAP_DISTANCE = new IntegerProperty("mappaint.node.snap-distance", 10);
    public static final String PROPNAME_CENTER = "center";
    public static final String PROPNAME_SCALE = "scale";
    private static final CopyOnWriteArrayList<ZoomChangeListener> zoomChangeListeners = new CopyOnWriteArrayList();
    private double scale = Main.getProjection().getDefaultZoomInPPD();
    protected EastNorth center = this.calculateDefaultCenter();
    private final Object paintRequestLock = new Object();
    private Rectangle paintRect = null;
    private Polygon paintPoly = null;
    private Stack<ZoomData> zoomUndoBuffer = new Stack();
    private Stack<ZoomData> zoomRedoBuffer = new Stack();
    private Date zoomTimestamp = new Date();
    public static final SystemOfMeasurement METRIC_SOM = new SystemOfMeasurement(1.0, "m", 1000.0, "km", 10000.0, "ha");
    public static final SystemOfMeasurement CHINESE_SOM = new SystemOfMeasurement(0.3333333333333333, "\u5e02\u5c3a", 500.0, "\u5e02\u91cc");
    public static final SystemOfMeasurement IMPERIAL_SOM = new SystemOfMeasurement(0.3048, "ft", 1609.344, "mi");
    public static final SystemOfMeasurement NAUTICAL_MILE_SOM = new SystemOfMeasurement(185.2, "kbl", 1852.0, "NM");
    public static final Map<String, SystemOfMeasurement> SYSTEMS_OF_MEASUREMENT = new LinkedHashMap<String, SystemOfMeasurement>();
    private LinkedList<CursorInfo> Cursors = new LinkedList();

    public static void removeZoomChangeListener(ZoomChangeListener zoomChangeListener) {
        zoomChangeListeners.remove(zoomChangeListener);
    }

    public static void addZoomChangeListener(ZoomChangeListener zoomChangeListener) {
        if (zoomChangeListener != null) {
            zoomChangeListeners.addIfAbsent(zoomChangeListener);
        }
    }

    protected static void fireZoomChanged() {
        for (ZoomChangeListener zoomChangeListener : zoomChangeListeners) {
            zoomChangeListener.zoomChanged();
        }
    }

    public NavigatableComponent() {
        this.setLayout(null);
    }

    protected DataSet getCurrentDataSet() {
        return Main.main.getCurrentDataSet();
    }

    private EastNorth calculateDefaultCenter() {
        Bounds bounds = Main.getProjection().getWorldBoundsLatLon();
        double d = (bounds.getMax().lat() + bounds.getMin().lat()) / 2.0;
        double d2 = (bounds.getMax().lon() + bounds.getMin().lon()) / 2.0;
        return Main.getProjection().latlon2eastNorth(new LatLon(d, d2));
    }

    public static String getDistText(double d) {
        return NavigatableComponent.getSystemOfMeasurement().getDistText(d);
    }

    public static String getAreaText(double d) {
        return NavigatableComponent.getSystemOfMeasurement().getAreaText(d);
    }

    public String getDist100PixelText() {
        return NavigatableComponent.getDistText(this.getDist100Pixel());
    }

    public double getDist100Pixel() {
        int n = this.getWidth() / 2;
        int n2 = this.getHeight() / 2;
        LatLon latLon = this.getLatLon(n - 50, n2);
        LatLon latLon2 = this.getLatLon(n + 50, n2);
        return latLon.greatCircleDistance(latLon2);
    }

    public EastNorth getCenter() {
        return this.center;
    }

    public double getScale() {
        return this.scale;
    }

    public EastNorth getEastNorth(int n, int n2) {
        return new EastNorth(this.center.east() + ((double)n - (double)this.getWidth() / 2.0) * this.scale, this.center.north() - ((double)n2 - (double)this.getHeight() / 2.0) * this.scale);
    }

    public ProjectionBounds getProjectionBounds() {
        return new ProjectionBounds(new EastNorth(this.center.east() - (double)this.getWidth() / 2.0 * this.scale, this.center.north() - (double)this.getHeight() / 2.0 * this.scale), new EastNorth(this.center.east() + (double)this.getWidth() / 2.0 * this.scale, this.center.north() + (double)this.getHeight() / 2.0 * this.scale));
    }

    public ProjectionBounds getMaxProjectionBounds() {
        Bounds bounds = this.getProjection().getWorldBoundsLatLon();
        return new ProjectionBounds(this.getProjection().latlon2eastNorth(bounds.getMin()), this.getProjection().latlon2eastNorth(bounds.getMax()));
    }

    public Bounds getRealBounds() {
        return new Bounds(this.getProjection().eastNorth2latlon(new EastNorth(this.center.east() - (double)this.getWidth() / 2.0 * this.scale, this.center.north() - (double)this.getHeight() / 2.0 * this.scale)), this.getProjection().eastNorth2latlon(new EastNorth(this.center.east() + (double)this.getWidth() / 2.0 * this.scale, this.center.north() + (double)this.getHeight() / 2.0 * this.scale)));
    }

    public LatLon getLatLon(int n, int n2) {
        return this.getProjection().eastNorth2latlon(this.getEastNorth(n, n2));
    }

    public LatLon getLatLon(double d, double d2) {
        return this.getLatLon((int)d, (int)d2);
    }

    public Bounds getLatLonBounds(Rectangle rectangle) {
        EastNorth eastNorth = this.getEastNorth(rectangle.x, rectangle.y);
        EastNorth eastNorth2 = this.getEastNorth(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        Bounds bounds = new Bounds(Main.getProjection().eastNorth2latlon(eastNorth));
        double d = Math.min(eastNorth.east(), eastNorth2.east());
        double d2 = Math.max(eastNorth.east(), eastNorth2.east());
        double d3 = Math.min(eastNorth.north(), eastNorth2.north());
        double d4 = Math.max(eastNorth.north(), eastNorth2.north());
        double d5 = (d2 - d) / 10.0;
        double d6 = (d4 - d3) / 10.0;
        for (int i = 0; i < 10; ++i) {
            bounds.extend(Main.getProjection().eastNorth2latlon(new EastNorth(d + (double)i * d5, d3)));
            bounds.extend(Main.getProjection().eastNorth2latlon(new EastNorth(d + (double)i * d5, d4)));
            bounds.extend(Main.getProjection().eastNorth2latlon(new EastNorth(d, d3 + (double)i * d6)));
            bounds.extend(Main.getProjection().eastNorth2latlon(new EastNorth(d2, d3 + (double)i * d6)));
        }
        return bounds;
    }

    public AffineTransform getAffineTransform() {
        return new AffineTransform(1.0 / this.scale, 0.0, 0.0, -1.0 / this.scale, (double)this.getWidth() / 2.0 - this.center.east() / this.scale, (double)this.getHeight() / 2.0 + this.center.north() / this.scale);
    }

    public Point2D getPoint2D(EastNorth eastNorth) {
        if (null == eastNorth) {
            return new Point();
        }
        double d = (eastNorth.east() - this.center.east()) / this.scale + (double)(this.getWidth() / 2);
        double d2 = (this.center.north() - eastNorth.north()) / this.scale + (double)(this.getHeight() / 2);
        return new Point2D.Double(d, d2);
    }

    public Point2D getPoint2D(LatLon latLon) {
        if (latLon == null) {
            return new Point();
        }
        if (latLon instanceof CachedLatLon) {
            return this.getPoint2D(((CachedLatLon)latLon).getEastNorth());
        }
        return this.getPoint2D(this.getProjection().latlon2eastNorth(latLon));
    }

    public Point2D getPoint2D(Node node) {
        return this.getPoint2D(node.getEastNorth());
    }

    public Point getPoint(EastNorth eastNorth) {
        Point2D point2D = this.getPoint2D(eastNorth);
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }

    public Point getPoint(LatLon latLon) {
        Point2D point2D = this.getPoint2D(latLon);
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }

    public Point getPoint(Node node) {
        Point2D point2D = this.getPoint2D(node);
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }

    public void zoomTo(EastNorth eastNorth, double d) {
        Bounds bounds = this.getProjection().getWorldBoundsLatLon();
        LatLon latLon = Projections.inverseProject(eastNorth);
        boolean bl = false;
        double d2 = latLon.lat();
        double d3 = latLon.lon();
        if (d2 < bounds.getMin().lat()) {
            bl = true;
            d2 = bounds.getMin().lat();
        } else if (d2 > bounds.getMax().lat()) {
            bl = true;
            d2 = bounds.getMax().lat();
        }
        if (d3 < bounds.getMin().lon()) {
            bl = true;
            d3 = bounds.getMin().lon();
        } else if (d3 > bounds.getMax().lon()) {
            bl = true;
            d3 = bounds.getMax().lon();
        }
        if (bl) {
            eastNorth = Projections.project(new LatLon(d2, d3));
        }
        int n = this.getWidth() / 2;
        int n2 = this.getHeight() / 2;
        LatLon latLon2 = new LatLon(bounds.getMin().lat(), d3);
        LatLon latLon3 = new LatLon(bounds.getMax().lat(), d3);
        EastNorth eastNorth2 = this.getProjection().latlon2eastNorth(latLon2);
        EastNorth eastNorth3 = this.getProjection().latlon2eastNorth(latLon3);
        double d4 = eastNorth3.north() - eastNorth2.north();
        if (d4 < (double)n2 * d) {
            double d5 = d4 / (double)n2;
            eastNorth2 = this.getProjection().latlon2eastNorth(new LatLon(d2, bounds.getMin().lon()));
            eastNorth3 = this.getProjection().latlon2eastNorth(new LatLon(d2, bounds.getMax().lon()));
            d4 = eastNorth3.east() - eastNorth2.east();
            if (d4 < (double)n * d) {
                d = Math.max(d5, d4 / (double)n);
            }
        } else if (d < (d4 /= latLon2.greatCircleDistance(latLon3) * (double)n2 * 10.0)) {
            d = d4;
        }
        if (!eastNorth.equals(this.center) || this.scale != d) {
            this.pushZoomUndo(this.center, this.scale);
            this.zoomNoUndoTo(eastNorth, d);
        }
    }

    private void zoomNoUndoTo(EastNorth eastNorth, double d) {
        if (!eastNorth.equals(this.center)) {
            EastNorth eastNorth2 = this.center;
            this.center = eastNorth;
            this.firePropertyChange(PROPNAME_CENTER, eastNorth2, eastNorth);
        }
        if (this.scale != d) {
            double d2 = this.scale;
            this.scale = d;
            this.firePropertyChange(PROPNAME_SCALE, d2, d);
        }
        this.repaint();
        NavigatableComponent.fireZoomChanged();
    }

    public void zoomTo(EastNorth eastNorth) {
        this.zoomTo(eastNorth, this.scale);
    }

    public void zoomTo(LatLon latLon) {
        this.zoomTo(Projections.project(latLon));
    }

    public void smoothScrollTo(LatLon latLon) {
        this.smoothScrollTo(Projections.project(latLon));
    }

    public void smoothScrollTo(EastNorth eastNorth) {
        if (!eastNorth.equals(this.center)) {
            final EastNorth eastNorth2 = this.center;
            double d = eastNorth.distance(eastNorth2) / this.scale;
            double d2 = d / (double)this.getWidth() * 1500.0;
            final double d3 = d2 * 20.0 / 1000.0;
            final EastNorth eastNorth3 = eastNorth;
            new Thread(){

                public void run() {
                    int n = 0;
                    while ((double)n < d3) {
                        NavigatableComponent.this.zoomTo(eastNorth2.interpolate(eastNorth3, (double)(n + 1) / d3));
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++n;
                    }
                }
            }.start();
        }
    }

    public void zoomToFactor(double d, double d2, double d3) {
        double d4 = this.scale * d3;
        this.zoomTo(new EastNorth(this.center.east() - (d - (double)this.getWidth() / 2.0) * (d4 - this.scale), this.center.north() + (d2 - (double)this.getHeight() / 2.0) * (d4 - this.scale)), d4);
    }

    public void zoomToFactor(EastNorth eastNorth, double d) {
        this.zoomTo(eastNorth, this.scale * d);
    }

    public void zoomToFactor(double d) {
        this.zoomTo(this.center, this.scale * d);
    }

    public void zoomTo(ProjectionBounds projectionBounds) {
        int n;
        int n2 = this.getWidth() - 20;
        if (n2 < 20) {
            n2 = 20;
        }
        if ((n = this.getHeight() - 20) < 20) {
            n = 20;
        }
        double d = (projectionBounds.maxEast - projectionBounds.minEast) / (double)n2;
        double d2 = (projectionBounds.maxNorth - projectionBounds.minNorth) / (double)n;
        double d3 = Math.max(d, d2);
        this.zoomTo(projectionBounds.getCenter(), d3);
    }

    public void zoomTo(Bounds bounds) {
        this.zoomTo(new ProjectionBounds(this.getProjection().latlon2eastNorth(bounds.getMin()), this.getProjection().latlon2eastNorth(bounds.getMax())));
    }

    private void pushZoomUndo(EastNorth eastNorth, double d) {
        Date date = new Date();
        if ((double)(date.getTime() - this.zoomTimestamp.getTime()) > Main.pref.getDouble("zoom.undo.delay", 1.0) * 1000.0) {
            this.zoomUndoBuffer.push(new ZoomData(eastNorth, d));
            if (this.zoomUndoBuffer.size() > Main.pref.getInteger("zoom.undo.max", 50)) {
                this.zoomUndoBuffer.remove(0);
            }
            this.zoomRedoBuffer.clear();
        }
        this.zoomTimestamp = date;
    }

    public void zoomPrevious() {
        if (!this.zoomUndoBuffer.isEmpty()) {
            ZoomData zoomData = this.zoomUndoBuffer.pop();
            this.zoomRedoBuffer.push(new ZoomData(this.center, this.scale));
            this.zoomNoUndoTo(zoomData.getCenterEastNorth(), zoomData.getScale());
        }
    }

    public void zoomNext() {
        if (!this.zoomRedoBuffer.isEmpty()) {
            ZoomData zoomData = this.zoomRedoBuffer.pop();
            this.zoomUndoBuffer.push(new ZoomData(this.center, this.scale));
            this.zoomNoUndoTo(zoomData.getCenterEastNorth(), zoomData.getScale());
        }
    }

    public boolean hasZoomUndoEntries() {
        return !this.zoomUndoBuffer.isEmpty();
    }

    public boolean hasZoomRedoEntries() {
        return !this.zoomRedoBuffer.isEmpty();
    }

    private BBox getBBox(Point point, int n) {
        return new BBox(this.getLatLon(point.x - n, point.y - n), this.getLatLon(point.x + n, point.y + n));
    }

    private Map<Double, List<Node>> getNearestNodesImpl(Point point, Predicate<OsmPrimitive> predicate) {
        TreeMap<Double, List<Node>> treeMap = new TreeMap<Double, List<Node>>();
        DataSet dataSet = this.getCurrentDataSet();
        if (dataSet != null) {
            double d = PROP_SNAP_DISTANCE.get().intValue();
            d *= d;
            for (Node node : dataSet.searchNodes(this.getBBox(point, PROP_SNAP_DISTANCE.get()))) {
                List<Object> list;
                double d2;
                if (!predicate.evaluate(node)) continue;
                double d3 = this.getPoint2D(node).distanceSq(point);
                if (!(d2 < d)) continue;
                if (treeMap.containsKey(d3)) {
                    list = treeMap.get(d3);
                } else {
                    list = new LinkedList();
                    treeMap.put(d3, list);
                }
                list.add(node);
            }
        }
        return treeMap;
    }

    public final List<Node> getNearestNodes(Point point, Collection<Node> collection, Predicate<OsmPrimitive> predicate) {
        Map<Double, List<Node>> map;
        List<Node> list = Collections.emptyList();
        if (collection == null) {
            collection = Collections.emptySet();
        }
        if (!(map = this.getNearestNodesImpl(point, predicate)).isEmpty()) {
            Double d = null;
            for (Double d2 : map.keySet()) {
                List<Node> list2 = map.get(d2);
                list2.removeAll(collection);
                if (d == null) {
                    if (list2.isEmpty()) continue;
                    d = d2;
                    list = new ArrayList<Node>();
                    list.addAll(list2);
                    continue;
                }
                if (!(d2 - d < 16.0)) continue;
                list.addAll(list2);
            }
        }
        return list;
    }

    public final List<Node> getNearestNodes(Point point, Predicate<OsmPrimitive> predicate) {
        return this.getNearestNodes(point, null, predicate);
    }

    public final Node getNearestNode(Point point, Predicate<OsmPrimitive> predicate, boolean bl) {
        Node node = null;
        Map<Double, List<Node>> map = this.getNearestNodesImpl(point, predicate);
        if (!map.isEmpty()) {
            Node node2 = null;
            Node node3 = null;
            double d = map.keySet().iterator().next();
            for (Double d2 : map.keySet()) {
                for (Node node4 : map.get(d2)) {
                    if (node2 == null && node4.isSelected()) {
                        node2 = node4;
                        bl |= d2 == d;
                    }
                    if (node3 != null || !node4.isNew() || !(d2 - d < 1.0)) continue;
                    node3 = node4;
                }
            }
            node = node2 != null && bl ? node2 : (node3 != null ? node3 : map.values().iterator().next().get(0));
        }
        return node;
    }

    public final Node getNearestNode(Point point, Predicate<OsmPrimitive> predicate) {
        return this.getNearestNode(point, predicate, true);
    }

    private Map<Double, List<WaySegment>> getNearestWaySegmentsImpl(Point point, Predicate<OsmPrimitive> predicate) {
        TreeMap<Double, List<WaySegment>> treeMap = new TreeMap<Double, List<WaySegment>>();
        DataSet dataSet = this.getCurrentDataSet();
        if (dataSet != null) {
            double d = Main.pref.getInteger("mappaint.segment.snap-distance", 10);
            d *= d;
            for (Way way : dataSet.searchWays(this.getBBox(point, Main.pref.getInteger("mappaint.segment.snap-distance", 10)))) {
                if (!predicate.evaluate(way)) continue;
                Node node = null;
                int n = -2;
                for (Node node2 : way.getNodes()) {
                    double d2;
                    ++n;
                    if (node2.isDeleted() || node2.isIncomplete()) continue;
                    if (node == null) {
                        node = node2;
                        continue;
                    }
                    Point2D point2D = this.getPoint2D(node);
                    Point2D point2D2 = this.getPoint2D(node2);
                    double d3 = point2D.distanceSq(point2D2);
                    double d4 = point.distanceSq(point2D2);
                    double d5 = Double.longBitsToDouble(Double.doubleToLongBits(d4 - (d4 - (d2 = point.distanceSq(point2D)) + d3) * (d4 - d2 + d3) / 4.0 / d3) >> 32 << 32);
                    if (d5 < d && d4 < d3 + d && d2 < d3 + d) {
                        List<WaySegment> list;
                        if (treeMap.containsKey(d5)) {
                            list = (List)treeMap.get(d5);
                        } else {
                            list = new LinkedList();
                            treeMap.put(d5, list);
                        }
                        list.add(new WaySegment(way, n));
                    }
                    node = node2;
                }
            }
        }
        return treeMap;
    }

    public final List<WaySegment> getNearestWaySegments(Point point, Collection<WaySegment> collection, Predicate<OsmPrimitive> predicate) {
        ArrayList<WaySegment> arrayList = new ArrayList<WaySegment>();
        LinkedList linkedList = new LinkedList();
        for (List<WaySegment> list : this.getNearestWaySegmentsImpl(point, predicate).values()) {
            for (WaySegment waySegment : list) {
                (waySegment.way.isSelected() ? arrayList : linkedList).add((WaySegment)waySegment);
            }
            arrayList.addAll(linkedList);
            linkedList.clear();
        }
        if (collection != null) {
            arrayList.removeAll(collection);
        }
        return arrayList;
    }

    public final List<WaySegment> getNearestWaySegments(Point point, Predicate<OsmPrimitive> predicate) {
        return this.getNearestWaySegments(point, null, predicate);
    }

    public final WaySegment getNearestWaySegment(Point point, Predicate<OsmPrimitive> predicate, boolean bl) {
        WaySegment waySegment = null;
        WaySegment waySegment2 = null;
        for (List<WaySegment> list : this.getNearestWaySegmentsImpl(point, predicate).values()) {
            if (waySegment != null && waySegment2 != null) break;
            for (WaySegment waySegment3 : list) {
                if (waySegment == null) {
                    waySegment = waySegment3;
                }
                if (waySegment2 != null || !waySegment3.way.isSelected()) continue;
                waySegment2 = waySegment3;
            }
        }
        return waySegment2 != null && bl ? waySegment2 : waySegment;
    }

    public final WaySegment getNearestWaySegment(Point point, Predicate<OsmPrimitive> predicate) {
        return this.getNearestWaySegment(point, predicate, true);
    }

    public final List<Way> getNearestWays(Point point, Collection<Way> collection, Predicate<OsmPrimitive> predicate) {
        ArrayList<Way> arrayList = new ArrayList<Way>();
        HashSet<Way> hashSet = new HashSet<Way>();
        for (List<WaySegment> list : this.getNearestWaySegmentsImpl(point, predicate).values()) {
            for (WaySegment waySegment : list) {
                if (!hashSet.add(waySegment.way)) continue;
                arrayList.add(waySegment.way);
            }
        }
        if (collection != null) {
            arrayList.removeAll(collection);
        }
        return arrayList;
    }

    public final List<Way> getNearestWays(Point point, Predicate<OsmPrimitive> predicate) {
        return this.getNearestWays(point, null, predicate);
    }

    public final Way getNearestWay(Point point, Predicate<OsmPrimitive> predicate) {
        WaySegment waySegment = this.getNearestWaySegment(point, predicate);
        return waySegment == null ? null : waySegment.way;
    }

    public final List<OsmPrimitive> getNearestNodesOrWays(Point point, Collection<OsmPrimitive> collection, Predicate<OsmPrimitive> predicate) {
        List<OsmPrimitive> list = Collections.emptyList();
        OsmPrimitive osmPrimitive = this.getNearestNodeOrWay(point, predicate, false);
        if (osmPrimitive != null) {
            if (osmPrimitive instanceof Node) {
                list = new ArrayList<Node>(this.getNearestNodes(point, predicate));
            } else if (osmPrimitive instanceof Way) {
                list = new ArrayList<Way>(this.getNearestWays(point, predicate));
            }
            if (collection != null) {
                list.removeAll(collection);
            }
        }
        return list;
    }

    public final List<OsmPrimitive> getNearestNodesOrWays(Point point, Predicate<OsmPrimitive> predicate) {
        return this.getNearestNodesOrWays(point, null, predicate);
    }

    private boolean isPrecedenceNode(Node node, Point point, boolean bl) {
        boolean bl2 = false;
        if (node != null) {
            bl2 |= !(point.distanceSq(this.getPoint2D(node)) > 16.0);
            bl2 |= node.isTagged();
            if (bl) {
                bl2 |= node.isSelected();
            }
        }
        return bl2;
    }

    public final OsmPrimitive getNearestNodeOrWay(Point point, Predicate<OsmPrimitive> predicate, boolean bl) {
        OsmPrimitive osmPrimitive = this.getNearestNode(point, predicate, bl);
        WaySegment waySegment = null;
        if (!this.isPrecedenceNode((Node)osmPrimitive, point, bl) && (waySegment = this.getNearestWaySegment(point, predicate, bl)) != null) {
            if (waySegment.way.isSelected() && bl || osmPrimitive == null) {
                osmPrimitive = waySegment.way;
            } else {
                Point2D point2D;
                int n = 3 * PROP_SNAP_DISTANCE.get();
                n *= n;
                Point2D point2D2 = this.getPoint2D(waySegment.way.getNode(waySegment.lowerIndex));
                if (point2D2.distanceSq(point2D = this.getPoint2D(waySegment.way.getNode(waySegment.lowerIndex + 1))) < (double)n && point.distanceSq(NavigatableComponent.project(0.5, point2D2, point2D)) < point.distanceSq(this.getPoint2D((Node)osmPrimitive))) {
                    osmPrimitive = waySegment.way;
                }
            }
        }
        return osmPrimitive;
    }

    public static <T> Collection<T> asColl(T t) {
        if (t == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(t);
    }

    public static double perDist(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        if (point2D != null && point2D2 != null && point2D3 != null) {
            double d = (point2D2.getX() - point2D.getX()) * (point2D3.getX() - point2D2.getX()) - (point2D2.getY() - point2D.getY()) * (point2D3.getY() - point2D2.getY());
            return Math.abs(d) / point2D2.distance(point2D3);
        }
        return 0.0;
    }

    public static Point2D project(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        if (point2D != null && point2D2 != null && point2D3 != null) {
            double d = ((point2D.getX() - point2D2.getX()) * (point2D3.getX() - point2D2.getX()) + (point2D.getY() - point2D2.getY()) * (point2D3.getY() - point2D2.getY())) / point2D2.distanceSq(point2D3);
            return NavigatableComponent.project(d, point2D2, point2D3);
        }
        return null;
    }

    public static Point2D project(double d, Point2D point2D, Point2D point2D2) {
        Point2D.Double double_ = null;
        if (point2D != null && point2D2 != null) {
            double_ = new Point2D.Double(point2D.getX() + d * (point2D2.getX() - point2D.getX()), point2D.getY() + d * (point2D2.getY() - point2D.getY()));
        }
        return double_;
    }

    public final List<OsmPrimitive> getAllNearest(Point point, Collection<OsmPrimitive> collection, Predicate<OsmPrimitive> predicate) {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        HashSet<Way> hashSet = new HashSet<Way>();
        for (List<WaySegment> object : this.getNearestWaySegmentsImpl(point, predicate).values()) {
            for (Object object2 : object) {
                if (!hashSet.add(((WaySegment)object2).way)) continue;
                arrayList.add(((WaySegment)object2).way);
            }
        }
        for (List<Comparable<WaySegment>> list : this.getNearestNodesImpl(point, predicate).values()) {
            arrayList.addAll(list);
        }
        HashSet hashSet2 = new HashSet();
        for (OsmPrimitive osmPrimitive : arrayList) {
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                if (!(osmPrimitive2 instanceof Relation) || !predicate.evaluate(osmPrimitive2)) continue;
                hashSet2.add(osmPrimitive2);
            }
        }
        arrayList.addAll(hashSet2);
        if (collection != null) {
            arrayList.removeAll(collection);
        }
        return arrayList;
    }

    public final List<OsmPrimitive> getAllNearest(Point point, Predicate<OsmPrimitive> predicate) {
        return this.getAllNearest(point, null, predicate);
    }

    public Projection getProjection() {
        return Main.getProjection();
    }

    @Override
    public String helpTopic() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public int getViewID() {
        String string = this.center.east() + "_" + this.center.north() + "_" + this.scale + "_" + this.getWidth() + "_" + this.getHeight() + "_" + ((Object)this.getProjection()).toString();
        CRC32 cRC32 = new CRC32();
        cRC32.update(string.getBytes());
        return (int)cRC32.getValue();
    }

    public static SystemOfMeasurement getSystemOfMeasurement() {
        SystemOfMeasurement systemOfMeasurement = SYSTEMS_OF_MEASUREMENT.get(ProjectionPreference.PROP_SYSTEM_OF_MEASUREMENT.get());
        if (systemOfMeasurement == null) {
            return METRIC_SOM;
        }
        return systemOfMeasurement;
    }

    public void setNewCursor(Cursor cursor, Object object) {
        if (this.Cursors.size() > 0) {
            CursorInfo cursorInfo = this.Cursors.getLast();
            if (cursorInfo != null && cursorInfo.cursor == cursor && cursorInfo.object == object) {
                return;
            }
            this.stripCursors(object);
        }
        this.Cursors.add(new CursorInfo(cursor, object));
        this.setCursor(cursor);
    }

    public void setNewCursor(int n, Object object) {
        this.setNewCursor(Cursor.getPredefinedCursor(n), object);
    }

    public void resetCursor(Object object) {
        if (this.Cursors.size() == 0) {
            this.setCursor(null);
            return;
        }
        CursorInfo cursorInfo = this.Cursors.getLast();
        this.stripCursors(object);
        if (cursorInfo != null && cursorInfo.object == object) {
            if (this.Cursors.size() == 0) {
                this.setCursor(null);
            } else {
                this.setCursor(this.Cursors.getLast().cursor);
            }
        }
    }

    private void stripCursors(Object object) {
        LinkedList<CursorInfo> linkedList = new LinkedList<CursorInfo>();
        for (CursorInfo cursorInfo : this.Cursors) {
            if (cursorInfo.object == object) continue;
            linkedList.add(cursorInfo);
        }
        this.Cursors = linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        Object object = this.paintRequestLock;
        synchronized (object) {
            Graphics graphics2;
            if (this.paintRect != null) {
                graphics2 = graphics.create();
                graphics2.setColor(Utils.complement(PaintColors.getBackgroundColor()));
                graphics2.drawRect(this.paintRect.x, this.paintRect.y, this.paintRect.width, this.paintRect.height);
                graphics2.dispose();
            }
            if (this.paintPoly != null) {
                graphics2 = graphics.create();
                graphics2.setColor(Utils.complement(PaintColors.getBackgroundColor()));
                graphics2.drawPolyline(this.paintPoly.xpoints, this.paintPoly.ypoints, this.paintPoly.npoints);
                graphics2.dispose();
            }
        }
        super.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPaintRect(Rectangle rectangle) {
        if (rectangle != null) {
            Object object = this.paintRequestLock;
            synchronized (object) {
                this.paintRect = rectangle;
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPaintPoly(Polygon polygon) {
        if (polygon != null) {
            Object object = this.paintRequestLock;
            synchronized (object) {
                this.paintPoly = polygon;
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestClearRect() {
        Object object = this.paintRequestLock;
        synchronized (object) {
            this.paintRect = null;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestClearPoly() {
        Object object = this.paintRequestLock;
        synchronized (object) {
            this.paintPoly = null;
        }
        this.repaint();
    }

    static {
        SYSTEMS_OF_MEASUREMENT.put(I18n.marktr("Metric"), METRIC_SOM);
        SYSTEMS_OF_MEASUREMENT.put(I18n.marktr("Chinese"), CHINESE_SOM);
        SYSTEMS_OF_MEASUREMENT.put(I18n.marktr("Imperial"), IMPERIAL_SOM);
        SYSTEMS_OF_MEASUREMENT.put(I18n.marktr("Nautical Mile"), NAUTICAL_MILE_SOM);
    }

    private static class CursorInfo {
        public Cursor cursor;
        public Object object;

        public CursorInfo(Cursor cursor, Object object) {
            this.cursor = cursor;
            this.object = object;
        }
    }

    public static class SystemOfMeasurement {
        public final double aValue;
        public final double bValue;
        public final String aName;
        public final String bName;
        public final double areaCustomValue;
        public final String areaCustomName;

        public SystemOfMeasurement(double d, String string, double d2, String string2) {
            this(d, string, d2, string2, -1.0, null);
        }

        public SystemOfMeasurement(double d, String string, double d2, String string2, double d3, String string3) {
            this.aValue = d;
            this.aName = string;
            this.bValue = d2;
            this.bName = string2;
            this.areaCustomValue = d3;
            this.areaCustomName = string3;
        }

        public String getDistText(double d) {
            double d2 = d / this.aValue;
            if (!Main.pref.getBoolean("system_of_measurement.use_only_lower_unit", false) && d2 > this.bValue / this.aValue) {
                return SystemOfMeasurement.formatText(d / this.bValue, this.bName);
            }
            if (d2 < 0.01) {
                return "< 0.01 " + this.aName;
            }
            return SystemOfMeasurement.formatText(d2, this.aName);
        }

        public String getAreaText(double d) {
            double d2 = d / (this.aValue * this.aValue);
            boolean bl = Main.pref.getBoolean("system_of_measurement.use_only_lower_unit", false);
            if (!bl && this.areaCustomValue > 0.0 && d2 > this.areaCustomValue / this.aValue * this.aValue && d2 < this.bValue * this.bValue / this.aValue * this.aValue) {
                return SystemOfMeasurement.formatText(d / this.areaCustomValue, this.areaCustomName);
            }
            if (!bl && d2 >= this.bValue * this.bValue / this.aValue * this.aValue) {
                return SystemOfMeasurement.formatText(d / (this.bValue * this.bValue), this.bName + "\u00b2");
            }
            if (d2 < 0.01) {
                return "< 0.01 " + this.aName + "\u00b2";
            }
            return SystemOfMeasurement.formatText(d2, this.aName + "\u00b2");
        }

        private static String formatText(double d, String string) {
            return String.format(Locale.US, "%." + (d < 9.999999 ? 2 : 1) + "f %s", d, string);
        }
    }

    private class ZoomData {
        LatLon center;
        double scale;

        public ZoomData(EastNorth eastNorth, double d) {
            this.center = Projections.inverseProject(eastNorth);
            this.scale = d;
        }

        public EastNorth getCenterEastNorth() {
            return NavigatableComponent.this.getProjection().latlon2eastNorth(this.center);
        }

        public double getScale() {
            return this.scale;
        }
    }

    public static class ViewportData {
        private EastNorth center;
        private Double scale;

        public ViewportData(EastNorth eastNorth, Double d) {
            this.center = eastNorth;
            this.scale = d;
        }

        public EastNorth getCenter() {
            return this.center;
        }

        public Double getScale() {
            return this.scale;
        }
    }

    public static interface ZoomChangeListener {
        public void zoomChanged();
    }
}

