/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.tools.GBC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresetListPanel
extends JPanel {
    public PresetListPanel() {
        super(new GridBagLayout());
    }

    public void updatePresets(Collection<TaggingPreset.PresetType> collection, Map<String, String> map, PresetHandler presetHandler) {
        this.removeAll();
        if (collection.isEmpty()) {
            this.setVisible(false);
            return;
        }
        for (Cloneable cloneable : TaggingPreset.getMatchingPresets(collection, map, true)) {
            JLabel jLabel = new JLabel(cloneable.getName() + " \u2026");
            jLabel.setIcon((Icon)cloneable.getValue("SmallIcon"));
            jLabel.addMouseListener(new PresetLabelML(jLabel, (TaggingPreset)cloneable, presetHandler));
            this.add((Component)jLabel, GBC.eol().fill(2));
        }
        if (this.getComponentCount() > 0) {
            Cloneable cloneable;
            this.setVisible(true);
            int n = this.getComponentCount() * this.getComponent(0).getHeight();
            cloneable = new Dimension(this.getWidth(), n);
            this.setMaximumSize((Dimension)cloneable);
            this.setMinimumSize((Dimension)cloneable);
        } else {
            this.setVisible(false);
        }
    }

    private static class PresetLabelML
    implements MouseListener {
        final JLabel label;
        final Font hover;
        final Font normal;
        final TaggingPreset tag;
        final PresetHandler presetHandler;

        PresetLabelML(JLabel jLabel, TaggingPreset taggingPreset, PresetHandler presetHandler) {
            this.label = jLabel;
            jLabel.setCursor(new Cursor(12));
            this.normal = this.label.getFont();
            this.hover = this.normal.deriveFont(Collections.singletonMap(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_DOTTED));
            this.tag = taggingPreset;
            this.presetHandler = presetHandler;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Collection<OsmPrimitive> collection = this.tag.createSelection(this.presetHandler.getSelection());
            if (collection == null || collection.isEmpty()) {
                return;
            }
            int n = this.tag.showDialog(collection, false);
            if (n == 1) {
                this.presetHandler.updateTags(this.tag.getChangedTags());
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.label.setFont(this.hover);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.label.setFont(this.normal);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PresetHandler {
        public Collection<OsmPrimitive> getSelection();

        public void updateTags(List<Tag> var1);
    }
}

