/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.relation.DownloadMembersAction;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.actions.relation.SelectInRelationListAction;
import org.openstreetmap.josm.actions.relation.SelectMembersAction;
import org.openstreetmap.josm.actions.relation.SelectRelationAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.properties.PresetListPanel;
import org.openstreetmap.josm.gui.dialogs.properties.TagEditHelper;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesDialog
extends ToggleDialog
implements SelectionChangedListener,
MapView.EditLayerChangeListener,
DataSetListenerAdapter.Listener {
    public static final JPanel pluginHook = new JPanel();
    private final DefaultTableModel propertyData = new ReadOnlyTableModel();
    private final DefaultTableModel membershipData = new ReadOnlyTableModel();
    private final JTable propertyTable = new JTable(this.propertyData);
    private final JTable membershipTable = new JTable(this.membershipData);
    private final JPopupMenu propertyMenu = new JPopupMenu();
    private final JPopupMenu membershipMenu = new JPopupMenu();
    private final PopupMenuHandler propertyMenuHandler = new PopupMenuHandler(this.propertyMenu);
    private final PopupMenuHandler membershipMenuHandler = new PopupMenuHandler(this.membershipMenu);
    private final Map<String, Map<String, Integer>> valueCount = new TreeMap<String, Map<String, Integer>>();
    private final TagEditHelper editHelper = new TagEditHelper(this.propertyData, this.valueCount);
    private final DataSetListenerAdapter dataChangedAdapter = new DataSetListenerAdapter(this);
    private final HelpAction helpAction = new HelpAction();
    private final PasteValueAction pasteValueAction = new PasteValueAction();
    private final CopyValueAction copyValueAction = new CopyValueAction();
    private final CopyKeyValueAction copyKeyValueAction = new CopyKeyValueAction();
    private final CopyAllKeyValueAction copyAllKeyValueAction = new CopyAllKeyValueAction();
    private final SearchAction searchActionSame = new SearchAction(true);
    private final SearchAction searchActionAny = new SearchAction(false);
    private final AddAction addAction = new AddAction();
    private final EditAction editAction = new EditAction();
    private final DeleteAction deleteAction = new DeleteAction();
    private final JosmAction[] josmActions = new JosmAction[]{this.addAction, this.editAction, this.deleteAction};
    private final SelectInRelationListAction setRelationSelectionAction = new SelectInRelationListAction();
    private final SelectRelationAction selectRelationAction = new SelectRelationAction(false);
    private final SelectRelationAction addRelationToSelectionAction = new SelectRelationAction(true);
    private final DownloadMembersAction downloadMembersAction = new DownloadMembersAction();
    private final DownloadSelectedIncompleteMembersAction downloadSelectedIncompleteMembersAction = new DownloadSelectedIncompleteMembersAction();
    private final SelectMembersAction selectMembersAction = new SelectMembersAction(false);
    private final SelectMembersAction addMembersToSelectionAction = new SelectMembersAction(true);
    private final SideButton btnAdd = new SideButton(this.addAction);
    private final SideButton btnEdit = new SideButton(this.editAction);
    private final SideButton btnDel = new SideButton(this.deleteAction);
    private final PresetListPanel presets = new PresetListPanel();
    private final JLabel selectSth = new JLabel("<html><p>" + I18n.tr("Select objects for which to change properties.", new Object[0]) + "</p></html>");
    private PresetListPanel.PresetHandler presetHandler = new PresetListPanel.PresetHandler(){

        @Override
        public void updateTags(List<Tag> list) {
            Command command = TaggingPreset.createCommand(this.getSelection(), list);
            if (command != null) {
                Main.main.undoRedo.add(command);
            }
        }

        @Override
        public Collection<OsmPrimitive> getSelection() {
            if (Main.main == null) {
                return null;
            }
            if (Main.main.getCurrentDataSet() == null) {
                return null;
            }
            return Main.main.getCurrentDataSet().getSelected();
        }
    };

    public PropertiesDialog(MapFrame mapFrame) {
        super(I18n.tr("Properties/Memberships", new Object[0]), "propertiesdialog", I18n.tr("Properties for selected objects.", new Object[0]), Shortcut.registerShortcut("subwindow:properties", I18n.tr("Toggle: {0}", I18n.tr("Properties/Memberships", new Object[0])), 80, 5007), 150, true);
        this.setupPropertiesMenu();
        this.buildPropertiesTable();
        this.setupMembershipMenu();
        this.buildMembershipTable();
        JPanel jPanel = new JPanel();
        boolean bl = Main.pref.getBoolean("properties.presets.top", true);
        jPanel.setLayout(new GridBagLayout());
        if (bl) {
            jPanel.add((Component)this.presets, GBC.std().fill(2).insets(5, 2, 5, 2).anchor(18));
            double d = Double.MIN_VALUE;
            jPanel.add((Component)pluginHook, GBC.eol().insets(0, 1, 1, 1).anchor(12).weight(d, d));
        }
        jPanel.add((Component)this.selectSth, GBC.eol().fill().insets(10, 10, 10, 10));
        jPanel.add((Component)this.propertyTable.getTableHeader(), GBC.eol().fill(2));
        jPanel.add((Component)this.propertyTable, GBC.eol().fill(1));
        jPanel.add((Component)this.membershipTable.getTableHeader(), GBC.eol().fill(2));
        jPanel.add((Component)this.membershipTable, GBC.eol().fill(1));
        if (!bl) {
            jPanel.add((Component)this.presets, GBC.eol().fill(2).insets(5, 2, 5, 2));
        }
        this.setupKeyboardShortcuts();
        this.propertyTable.getSelectionModel().addListSelectionListener(this.editAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(this.editAction);
        this.propertyTable.getSelectionModel().addListSelectionListener(this.deleteAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(this.deleteAction);
        JScrollPane jScrollPane = (JScrollPane)this.createLayout(jPanel, true, Arrays.asList(this.btnAdd, this.btnEdit, this.btnDel));
        MouseClickWatch mouseClickWatch = new MouseClickWatch();
        this.propertyTable.addMouseListener(mouseClickWatch);
        this.membershipTable.addMouseListener(mouseClickWatch);
        jScrollPane.addMouseListener(mouseClickWatch);
        this.selectSth.setPreferredSize(jScrollPane.getSize());
        this.presets.setSize(jScrollPane.getSize());
        this.editHelper.loadTagsIfNeeded();
    }

    private void buildPropertiesTable() {
        this.propertyData.setColumnIdentifiers(new String[]{I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])});
        this.propertyTable.setSelectionMode(2);
        this.propertyTable.getTableHeader().setReorderingAllowed(false);
        this.propertyTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (object == null) {
                    return this;
                }
                if (component instanceof JLabel) {
                    String string = null;
                    if (object instanceof String) {
                        string = (String)object;
                    } else if (object instanceof Map) {
                        Map map = (Map)object;
                        if (map.size() != 1) {
                            string = I18n.tr("<different>", new Object[0]);
                            component.setFont(component.getFont().deriveFont(2));
                        } else {
                            Map.Entry entry = map.entrySet().iterator().next();
                            string = (String)entry.getKey();
                        }
                    }
                    ((JLabel)component).setText(string);
                }
                return component;
            }
        });
    }

    private void buildMembershipTable() {
        this.membershipData.setColumnIdentifiers(new String[]{I18n.tr("Member Of", new Object[0]), I18n.tr("Role", new Object[0]), I18n.tr("Position", new Object[0])});
        this.membershipTable.setSelectionMode(2);
        TableColumnModel tableColumnModel = this.membershipTable.getColumnModel();
        this.membershipTable.getTableHeader().setReorderingAllowed(false);
        tableColumnModel.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (object == null) {
                    return this;
                }
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    Relation relation = (Relation)object;
                    jLabel.setText(relation.getDisplayName(DefaultNameFormatter.getInstance()));
                    if (relation.isDisabledAndHidden()) {
                        jLabel.setFont(jLabel.getFont().deriveFont(2));
                    }
                }
                return component;
            }
        });
        tableColumnModel.getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object == null) {
                    return this;
                }
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                boolean bl3 = ((Relation)jTable.getValueAt(n, 0)).isDisabledAndHidden();
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    MemberInfo memberInfo = (MemberInfo)object;
                    String string = null;
                    for (RelationMember relationMember : memberInfo.role) {
                        if (string == null) {
                            string = relationMember.getRole();
                            continue;
                        }
                        if (string.equals(relationMember.getRole())) continue;
                        string = I18n.tr("<different>", new Object[0]);
                        break;
                    }
                    jLabel.setText(string);
                    if (bl3) {
                        jLabel.setFont(jLabel.getFont().deriveFont(2));
                    }
                }
                return component;
            }
        });
        tableColumnModel.getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                boolean bl3 = ((Relation)jTable.getValueAt(n, 0)).isDisabledAndHidden();
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    jLabel.setText(((MemberInfo)jTable.getValueAt(n, 1)).getPositionString());
                    if (bl3) {
                        jLabel.setFont(jLabel.getFont().deriveFont(2));
                    }
                }
                return component;
            }
        });
        tableColumnModel.getColumn(2).setPreferredWidth(20);
        tableColumnModel.getColumn(1).setPreferredWidth(40);
        tableColumnModel.getColumn(0).setPreferredWidth(200);
    }

    private void setupMembershipMenu() {
        this.membershipMenuHandler.addAction(this.setRelationSelectionAction);
        this.membershipMenuHandler.addAction(this.selectRelationAction);
        this.membershipMenuHandler.addAction(this.addRelationToSelectionAction);
        this.membershipMenuHandler.addAction(this.selectMembersAction);
        this.membershipMenuHandler.addAction(this.addMembersToSelectionAction);
        this.membershipMenu.addSeparator();
        this.membershipMenuHandler.addAction(this.downloadMembersAction);
        this.membershipMenuHandler.addAction(this.downloadSelectedIncompleteMembersAction);
        this.membershipMenu.addSeparator();
        this.membershipMenu.add(this.helpAction);
        this.membershipTable.addMouseListener(new PopupMenuLauncher(){

            public void launch(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = PropertiesDialog.this.membershipTable.rowAtPoint(point);
                int[] nArray = PropertiesDialog.this.membershipTable.getSelectedRows();
                if (nArray.length < 2 && n > -1) {
                    PropertiesDialog.this.membershipTable.changeSelection(n, 0, false, false);
                    nArray = new int[]{n};
                }
                ArrayList<Relation> arrayList = new ArrayList<Relation>();
                for (int n2 : nArray) {
                    Relation relation = (Relation)PropertiesDialog.this.membershipData.getValueAt(n2, 0);
                    arrayList.add(relation);
                }
                PropertiesDialog.this.membershipMenuHandler.setPrimitives(arrayList);
                PropertiesDialog.this.membershipMenu.show(PropertiesDialog.this.membershipTable, point.x, point.y - 3);
            }
        });
    }

    private void setupPropertiesMenu() {
        this.propertyMenu.add(this.pasteValueAction);
        this.propertyMenu.add(this.copyValueAction);
        this.propertyMenu.add(this.copyKeyValueAction);
        this.propertyMenu.add(this.copyAllKeyValueAction);
        this.propertyMenu.addSeparator();
        this.propertyMenu.add(this.searchActionAny);
        this.propertyMenu.add(this.searchActionSame);
        this.propertyMenu.addSeparator();
        this.propertyMenu.add(this.helpAction);
        this.propertyTable.addMouseListener(new PopupMenuLauncher(){

            public void launch(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = PropertiesDialog.this.propertyTable.rowAtPoint(point);
                int n2 = PropertiesDialog.this.propertyTable.getSelectedRowCount();
                if (n2 < 2 && n > -1) {
                    PropertiesDialog.this.propertyTable.changeSelection(n, 0, false, false);
                }
                if (n2 >= 2 || n > -1) {
                    PropertiesDialog.this.propertyMenu.show(PropertiesDialog.this.propertyTable, point.x, point.y - 3);
                }
            }
        });
    }

    private void setupKeyboardShortcuts() {
        this.propertyTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "onTableEnter");
        this.propertyTable.getActionMap().put("onTableEnter", this.editAction);
        this.membershipTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "onTableEnter");
        this.membershipTable.getActionMap().put("onTableEnter", this.editAction);
        this.propertyTable.getInputMap(1).put(KeyStroke.getKeyStroke(155, 0), "onTableInsert");
        this.propertyTable.getActionMap().put("onTableInsert", this.addAction);
        InputMapUtils.unassignCtrlShiftUpDown(this.propertyTable, 1);
        this.propertyTable.setTransferHandler(null);
        this.propertyTable.getInputMap(1).put(KeyStroke.getKeyStroke(67, 2), "onCopy");
        this.propertyTable.getActionMap().put("onCopy", this.copyKeyValueAction);
        InputMapUtils.enableEnter(this.btnAdd);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", this.deleteAction);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(112, 0), "onHelp");
        this.getActionMap().put("onHelp", this.helpAction);
    }

    private void editMembership(int n) {
        Relation relation = (Relation)this.membershipData.getValueAt(n, 0);
        Main.map.relationListDialog.selectRelation(relation);
        RelationEditor.getEditor(Main.map.mapView.getEditLayer(), relation, ((MemberInfo)this.membershipData.getValueAt((int)n, (int)1)).role).setVisible(true);
    }

    private int findRow(TableModel tableModel, Object object) {
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (!tableModel.getValueAt(i, 0).equals(object)) continue;
            return i;
        }
        return -1;
    }

    private void updateSelection() {
        if (Main.main.getCurrentDataSet() == null) {
            this.selectionChanged(Collections.emptyList());
        } else {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    @Override
    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener(this.dataChangedAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        SelectionEventManager.getInstance().addSelectionListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        MapView.addEditLayerChangeListener(this);
        for (JosmAction josmAction : this.josmActions) {
            Main.registerActionShortcut(josmAction);
        }
        this.updateSelection();
    }

    @Override
    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener(this.dataChangedAdapter);
        SelectionEventManager.getInstance().removeSelectionListener(this);
        MapView.removeEditLayerChangeListener(this);
        for (JosmAction josmAction : this.josmActions) {
            Main.unregisterActionShortcut(josmAction);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && Main.main.getCurrentDataSet() != null) {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        for (JosmAction josmAction : this.josmActions) {
            josmAction.destroy();
        }
        Container container = pluginHook.getParent();
        if (container != null) {
            container.remove(pluginHook);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        int n;
        int n2;
        Object object;
        if (!this.isVisible()) {
            return;
        }
        if (this.propertyTable == null) {
            return;
        }
        if (this.propertyTable.getCellEditor() != null) {
            this.propertyTable.getCellEditor().cancelCellEditing();
        }
        Relation relation = null;
        String string = this.editHelper.getChangedKey();
        if (string == null && this.propertyTable.getSelectedRowCount() == 1) {
            string = (String)this.propertyData.getValueAt(this.propertyTable.getSelectedRow(), 0);
        }
        if (this.membershipTable.getSelectedRowCount() == 1) {
            relation = (Relation)this.membershipData.getValueAt(this.membershipTable.getSelectedRow(), 0);
        }
        this.propertyData.setRowCount(0);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        this.valueCount.clear();
        EnumSet<TaggingPreset.PresetType> enumSet = EnumSet.noneOf(TaggingPreset.PresetType.class);
        for (OsmPrimitive object22 : collection) {
            enumSet.add(TaggingPreset.PresetType.forPrimitive(object22));
            for (String string2 : object22.keySet()) {
                String string3 = object22.get(string2);
                hashMap.put(string2, hashMap.containsKey(string2) ? (Integer)hashMap.get(string2) + 1 : 1);
                if (this.valueCount.containsKey(string2)) {
                    object.put((Object)string3, (object = this.valueCount.get(string2)).containsKey(string3) ? (Integer)object.get(string3) + 1 : 1);
                    continue;
                }
                object = new TreeMap<String, Integer>();
                ((TreeMap)object).put(string3, 1);
                this.valueCount.put(string2, (Map<String, Integer>)object);
            }
        }
        for (Map.Entry entry : this.valueCount.entrySet()) {
            void var9_15;
            boolean bl = false;
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                var9_15 += ((Integer)entry2.getValue()).intValue();
            }
            if (var9_15 < collection.size()) {
                ((Map)entry.getValue()).put("", collection.size() - var9_15);
            }
            this.propertyData.addRow(new Object[]{entry.getKey(), entry.getValue()});
            hashMap2.put((String)entry.getKey(), ((Map)entry.getValue()).size() == 1 ? (String)((Map)entry.getValue()).keySet().iterator().next() : I18n.tr("<different>", new Object[0]));
        }
        this.membershipData.setRowCount(0);
        HashMap hashMap3 = new HashMap();
        for (OsmPrimitive osmPrimitive : collection) {
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                if (!(osmPrimitive2 instanceof Relation) || osmPrimitive2.isIncomplete() || osmPrimitive2.isDeleted()) continue;
                object = (Relation)osmPrimitive2;
                MemberInfo memberInfo = (MemberInfo)hashMap3.get(object);
                if (memberInfo == null) {
                    memberInfo = new MemberInfo();
                }
                hashMap3.put(object, memberInfo);
                int n3 = 1;
                for (RelationMember relationMember : ((Relation)object).getMembers()) {
                    if (relationMember.getMember() == osmPrimitive) {
                        memberInfo.add(relationMember, n3);
                    }
                    ++n3;
                }
            }
        }
        ArrayList arrayList = new ArrayList(hashMap3.keySet());
        Collections.sort(arrayList, new Comparator<Relation>(){

            @Override
            public int compare(Relation relation, Relation relation2) {
                int n = Boolean.valueOf(relation.isDisabledAndHidden()).compareTo(relation2.isDisabledAndHidden());
                if (n == 0) {
                    n = relation.getDisplayName(DefaultNameFormatter.getInstance()).compareTo(relation2.getDisplayName(DefaultNameFormatter.getInstance()));
                }
                return n;
            }
        });
        for (Relation relation2 : arrayList) {
            this.membershipData.addRow(new Object[]{relation2, hashMap3.get(relation2)});
        }
        this.presets.updatePresets(enumSet, hashMap2, this.presetHandler);
        this.membershipTable.getTableHeader().setVisible(this.membershipData.getRowCount() > 0);
        this.membershipTable.setVisible(this.membershipData.getRowCount() > 0);
        boolean bl = !collection.isEmpty();
        boolean bl2 = bl && this.propertyData.getRowCount() > 0;
        boolean bl3 = bl && this.membershipData.getRowCount() > 0;
        this.btnAdd.setEnabled(bl);
        this.btnEdit.setEnabled(bl2 || bl3);
        this.btnDel.setEnabled(bl2 || bl3);
        this.propertyTable.setVisible(bl2);
        this.propertyTable.getTableHeader().setVisible(bl2);
        this.selectSth.setVisible(!bl);
        pluginHook.setVisible(bl);
        if (string != null && (n2 = this.findRow(this.propertyData, string)) != -1) {
            this.propertyTable.changeSelection(n2, 0, false, false);
        } else if (relation != null && (n = this.findRow(this.membershipData, relation)) != -1) {
            this.membershipTable.changeSelection(n, 0, false, false);
        } else if (bl2) {
            this.propertyTable.changeSelection(0, 0, false, false);
        } else if (bl3) {
            this.membershipTable.changeSelection(0, 0, false, false);
        }
        if (this.propertyData.getRowCount() != 0 || this.membershipData.getRowCount() != 0) {
            this.setTitle(I18n.tr("Properties: {0} / Memberships: {1}", this.propertyData.getRowCount(), this.membershipData.getRowCount()));
        } else {
            this.setTitle(I18n.tr("Properties / Memberships", new Object[0]));
        }
    }

    @Override
    public void editLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
        if (osmDataLayer2 == null) {
            this.editHelper.saveTagsIfNeeded();
        }
        this.updateSelection();
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        this.updateSelection();
    }

    public PopupMenuHandler getPropertyPopupMenuHandler() {
        return this.propertyMenuHandler;
    }

    public Tag getSelectedProperty() {
        int n = this.propertyTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        TreeMap treeMap = (TreeMap)this.propertyData.getValueAt(n, 1);
        return new Tag(this.propertyData.getValueAt(n, 0).toString(), treeMap.size() > 1 ? "" : (String)treeMap.keySet().iterator().next());
    }

    public PopupMenuHandler getMembershipPopupMenuHandler() {
        return this.membershipMenuHandler;
    }

    public IRelation getSelectedMembershipRelation() {
        int n = this.membershipTable.getSelectedRow();
        return n > -1 ? (IRelation)this.membershipData.getValueAt(n, 0) : null;
    }

    class SearchAction
    extends AbstractAction {
        final boolean sameType;

        public SearchAction(boolean bl) {
            this.sameType = bl;
            if (bl) {
                this.putValue("Name", I18n.tr("Search Key/Value/Type", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Search with the key and value of the selected tag, restrict to type (i.e., node/way/relation)", new Object[0]));
            } else {
                this.putValue("Name", I18n.tr("Search Key/Value", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Search with the key and value of the selected tag", new Object[0]));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertiesDialog.this.propertyTable.getSelectedRowCount() != 1) {
                return;
            }
            String string = PropertiesDialog.this.propertyData.getValueAt(PropertiesDialog.this.propertyTable.getSelectedRow(), 0).toString();
            Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
            if (collection.isEmpty()) {
                return;
            }
            String string2 = "";
            String string3 = "";
            for (OsmPrimitive osmPrimitive : collection) {
                String string4 = osmPrimitive.get(string);
                if (string4 == null) continue;
                String string5 = "";
                if (!this.sameType) {
                    string5 = "";
                } else if (osmPrimitive instanceof Node) {
                    string5 = "type:node ";
                } else if (osmPrimitive instanceof Way) {
                    string5 = "type:way ";
                } else if (osmPrimitive instanceof Relation) {
                    string5 = "type:relation ";
                }
                string3 = string3 + string2 + "(" + string5 + "\"" + org.openstreetmap.josm.actions.search.SearchAction.escapeStringForSearch(string) + "\"=\"" + org.openstreetmap.josm.actions.search.SearchAction.escapeStringForSearch(string4) + "\")";
                string2 = " OR ";
            }
            SearchAction.SearchSetting searchSetting = new SearchAction.SearchSetting(string3, SearchAction.SearchMode.replace, true, false, false);
            org.openstreetmap.josm.actions.search.SearchAction.searchWithoutHistory(searchSetting);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CopyAllKeyValueAction
    extends AbstractCopyAction {
        public CopyAllKeyValueAction() {
            this.putValue("Name", I18n.tr("Copy all Keys/Values", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Copy the key and value of the all tags to clipboard", new Object[0]));
        }

        @Override
        protected Collection<String> getString(OsmPrimitive osmPrimitive, String string) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (Map.Entry<String, String> entry : osmPrimitive.getKeys().entrySet()) {
                linkedList.add(new Tag(entry.getKey(), entry.getValue()).toString());
            }
            return linkedList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CopyKeyValueAction
    extends AbstractCopyAction {
        public CopyKeyValueAction() {
            this.putValue("Name", I18n.tr("Copy Key/Value", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Copy the key and value of the selected tag to clipboard", new Object[0]));
        }

        @Override
        protected Collection<String> getString(OsmPrimitive osmPrimitive, String string) {
            String string2 = osmPrimitive.get(string);
            return string2 == null ? null : Collections.singleton(new Tag(string, string2).toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CopyValueAction
    extends AbstractCopyAction {
        public CopyValueAction() {
            this.putValue("Name", I18n.tr("Copy Value", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Copy the value of the selected tag to clipboard", new Object[0]));
        }

        @Override
        protected Collection<String> getString(OsmPrimitive osmPrimitive, String string) {
            String string2 = osmPrimitive.get(string);
            return string2 == null ? null : Collections.singleton(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractCopyAction
    extends AbstractAction {
        AbstractCopyAction() {
        }

        protected abstract Collection<String> getString(OsmPrimitive var1, String var2);

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = PropertiesDialog.this.propertyTable.getSelectedRows();
            TreeSet<String> treeSet = new TreeSet<String>();
            Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
            if (nArray.length == 0 || collection.isEmpty()) {
                return;
            }
            for (int n : nArray) {
                String string = PropertiesDialog.this.propertyData.getValueAt(n, 0).toString();
                if (collection.isEmpty()) {
                    return;
                }
                for (OsmPrimitive osmPrimitive : collection) {
                    Collection<String> collection2 = this.getString(osmPrimitive, string);
                    if (collection2 == null) continue;
                    treeSet.addAll(collection2);
                }
            }
            if (!treeSet.isEmpty()) {
                Utils.copyToClipboard(Utils.join("\n", treeSet));
            }
        }
    }

    class PasteValueAction
    extends AbstractAction {
        public PasteValueAction() {
            this.putValue("Name", I18n.tr("Paste Value", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Paste the value of the selected tag from clipboard", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertiesDialog.this.propertyTable.getSelectedRowCount() != 1) {
                return;
            }
            String string = PropertiesDialog.this.propertyData.getValueAt(PropertiesDialog.this.propertyTable.getSelectedRow(), 0).toString();
            Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
            String string2 = Utils.getClipboardContent();
            if (collection.isEmpty() || string2 == null) {
                return;
            }
            Main.main.undoRedo.add(new ChangePropertyCommand(collection, string, Utils.strip(string2)));
        }
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("Name", I18n.tr("Go to OSM wiki for tag help (F1)", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Launch browser with wiki help for selected object", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "search"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = Main.pref.get("url.openstreetmap-wiki", "http://wiki.openstreetmap.org/wiki/");
                String string2 = LanguageInfo.getWikiLanguagePrefix();
                final ArrayList<URI> arrayList = new ArrayList<URI>();
                if (PropertiesDialog.this.propertyTable.getSelectedRowCount() == 1) {
                    int n = PropertiesDialog.this.propertyTable.getSelectedRow();
                    String string3 = URLEncoder.encode(PropertiesDialog.this.propertyData.getValueAt(n, 0).toString(), "UTF-8");
                    Map map = (Map)PropertiesDialog.this.propertyData.getValueAt(n, 1);
                    String string4 = URLEncoder.encode((String)map.entrySet().iterator().next().getKey(), "UTF-8");
                    arrayList.add(new URI(String.format("%s%sTag:%s=%s", string, string2, string3, string4)));
                    arrayList.add(new URI(String.format("%sTag:%s=%s", string, string3, string4)));
                    arrayList.add(new URI(String.format("%s%sKey:%s", string, string2, string3)));
                    arrayList.add(new URI(String.format("%sKey:%s", string, string3)));
                    arrayList.add(new URI(String.format("%s%sMap_Features", string, string2)));
                    arrayList.add(new URI(String.format("%sMap_Features", string)));
                } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1) {
                    int n = PropertiesDialog.this.membershipTable.getSelectedRow();
                    String string5 = URLEncoder.encode(((Relation)PropertiesDialog.this.membershipData.getValueAt(n, 0)).get("type"), "UTF-8");
                    if (string5 != null && !string5.equals("")) {
                        arrayList.add(new URI(String.format("%s%sRelation:%s", string, string2, string5)));
                        arrayList.add(new URI(String.format("%sRelation:%s", string, string5)));
                    }
                    arrayList.add(new URI(String.format("%s%sRelations", string, string2)));
                    arrayList.add(new URI(String.format("%sRelations", string)));
                } else {
                    arrayList.add(new URI(String.format("%s%sMap_Features", string, string2)));
                    arrayList.add(new URI(String.format("%sMap_Features", string)));
                }
                Main.worker.execute(new Runnable(){

                    public void run() {
                        try {
                            for (URI uRI : arrayList) {
                                HttpURLConnection httpURLConnection = Utils.openHttpConnection(uRI.toURL());
                                httpURLConnection.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
                                if (httpURLConnection.getResponseCode() != 200) {
                                    Main.info("{0} does not exist", uRI);
                                    httpURLConnection.disconnect();
                                    continue;
                                }
                                int n = httpURLConnection.getContentLength();
                                httpURLConnection.disconnect();
                                httpURLConnection = Utils.openHttpConnection(new URI(uRI.toString().replace("=", "%3D").replaceFirst("/wiki/", "/w/index.php?redirect=no&title=")).toURL());
                                httpURLConnection.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
                                if (Math.abs(httpURLConnection.getContentLength() - n) > 200) {
                                    Main.info("{0} is a mediawiki redirect", uRI);
                                    httpURLConnection.disconnect();
                                    continue;
                                }
                                Main.info("browsing to {0}", uRI);
                                httpURLConnection.disconnect();
                                OpenBrowser.displayUrl(uRI.toString());
                                break;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class EditAction
    extends JosmAction
    implements ListSelectionListener {
        public EditAction() {
            super(I18n.tr("Edit", new Object[0]), "dialogs/edit", I18n.tr("Edit the value of the selected key for all objects", new Object[0]), Shortcut.registerShortcut("properties:edit", I18n.tr("Edit Properties", new Object[0]), 83, 5004), false);
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            if (PropertiesDialog.this.propertyTable.getSelectedRowCount() == 1) {
                int n = PropertiesDialog.this.propertyTable.getSelectedRow();
                PropertiesDialog.this.editHelper.editProperty(n, false);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1) {
                int n = PropertiesDialog.this.membershipTable.getSelectedRow();
                PropertiesDialog.this.editMembership(n);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled((PropertiesDialog.this.propertyTable != null && PropertiesDialog.this.propertyTable.getSelectedRowCount() == 1) ^ (PropertiesDialog.this.membershipTable != null && PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1));
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends JosmAction {
        public AddAction() {
            super(I18n.tr("Add", new Object[0]), "dialogs/add", I18n.tr("Add a new key/value pair to all objects", new Object[0]), Shortcut.registerShortcut("properties:add", I18n.tr("Add Property", new Object[0]), 65, 5004), false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesDialog.this.editHelper.addProperty();
            PropertiesDialog.this.btnAdd.requestFocusInWindow();
        }
    }

    class DeleteAction
    extends JosmAction
    implements ListSelectionListener {
        public DeleteAction() {
            super(I18n.tr("Delete", new Object[0]), "dialogs/delete", I18n.tr("Delete the selected key in all objects", new Object[0]), Shortcut.registerShortcut("properties:delete", I18n.tr("Delete Properties", new Object[0]), 68, 5010), false);
            this.updateEnabledState();
        }

        /*
         * WARNING - void declaration
         */
        protected void deleteProperties(int[] nArray) {
            void var4_7;
            HashMap<String, String> hashMap = new HashMap<String, String>(nArray.length);
            int n = nArray[0];
            for (int n2 : nArray) {
                String string = PropertiesDialog.this.propertyData.getValueAt(n2, 0).toString();
                if (n2 == n + 1) {
                    n = n2;
                }
                hashMap.put(string, null);
            }
            Object var4_5 = null;
            int n3 = PropertiesDialog.this.propertyData.getRowCount();
            if (n3 > nArray.length) {
                n = n == nArray[nArray.length - 1] ? (n + 1 < n3 ? n + 1 : nArray[0] - 1) : ++n;
                String string = (String)PropertiesDialog.this.propertyData.getValueAt(n, 0);
            }
            Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
            Main.main.undoRedo.add(new ChangePropertyCommand(collection, hashMap));
            PropertiesDialog.this.membershipTable.clearSelection();
            if (var4_7 != null) {
                PropertiesDialog.this.propertyTable.changeSelection(PropertiesDialog.this.findRow(PropertiesDialog.this.propertyData, var4_7), 0, false, false);
            }
        }

        protected void deleteFromRelation(int n) {
            Relation relation = (Relation)PropertiesDialog.this.membershipData.getValueAt(n, 0);
            Relation relation2 = null;
            int n2 = PropertiesDialog.this.membershipTable.getRowCount();
            if (n2 > 1) {
                relation2 = (Relation)PropertiesDialog.this.membershipData.getValueAt(n + 1 < n2 ? n + 1 : n - 1, 0);
            }
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Change relation", new Object[0]), new String[]{I18n.tr("Delete from relation", new Object[0]), I18n.tr("Cancel", new Object[0])});
            extendedDialog.setButtonIcons(new String[]{"dialogs/delete.png", "cancel.png"});
            extendedDialog.setContent(I18n.tr("Really delete selection from relation {0}?", relation.getDisplayName(DefaultNameFormatter.getInstance())));
            extendedDialog.toggleEnable("delete_from_relation");
            extendedDialog.showDialog();
            if (extendedDialog.getValue() != 1) {
                return;
            }
            Relation relation3 = new Relation(relation);
            Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
            for (OsmPrimitive osmPrimitive : collection) {
                relation3.removeMembersFor(osmPrimitive);
            }
            Main.main.undoRedo.add(new ChangeCommand(relation, relation3));
            PropertiesDialog.this.propertyTable.clearSelection();
            if (relation2 != null) {
                PropertiesDialog.this.membershipTable.changeSelection(PropertiesDialog.this.findRow(PropertiesDialog.this.membershipData, relation2), 0, false, false);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertiesDialog.this.propertyTable.getSelectedRowCount() > 0) {
                int[] nArray = PropertiesDialog.this.propertyTable.getSelectedRows();
                this.deleteProperties(nArray);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0) {
                int[] nArray = PropertiesDialog.this.membershipTable.getSelectedRows();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    this.deleteFromRelation(nArray[i]);
                }
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(PropertiesDialog.this.propertyTable != null && PropertiesDialog.this.propertyTable.getSelectedRowCount() >= 1 || PropertiesDialog.this.membershipTable != null && PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReadOnlyTableModel
    extends DefaultTableModel {
        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    }

    static class MemberInfo {
        List<RelationMember> role = new ArrayList<RelationMember>();
        List<Integer> position = new ArrayList<Integer>();
        private String positionString = null;

        MemberInfo() {
        }

        void add(RelationMember relationMember, Integer n) {
            this.role.add(relationMember);
            this.position.add(n);
        }

        String getPositionString() {
            if (this.positionString == null) {
                Collections.sort(this.position);
                this.positionString = String.valueOf(this.position.get(0));
                int n = 0;
                int n2 = this.position.get(0);
                for (int i = 1; i < this.position.size(); ++i) {
                    int n3 = this.position.get(i);
                    if (n3 == n2 + 1) {
                        ++n;
                    } else if (n == 0) {
                        this.positionString = this.positionString + "," + String.valueOf(n3);
                    } else {
                        this.positionString = this.positionString + "-" + String.valueOf(n2);
                        this.positionString = this.positionString + "," + String.valueOf(n3);
                        n = 0;
                    }
                    n2 = n3;
                }
                if (n >= 1) {
                    this.positionString = this.positionString + "-" + String.valueOf(n2);
                }
            }
            if (this.positionString.length() > 20) {
                this.positionString = this.positionString.substring(0, 17) + "...";
            }
            return this.positionString;
        }
    }

    public class MouseClickWatch
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() < 2) {
                if (mouseEvent.getSource() == PropertiesDialog.this.propertyTable) {
                    PropertiesDialog.this.membershipTable.clearSelection();
                } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                    PropertiesDialog.this.propertyTable.clearSelection();
                }
            } else if (mouseEvent.getSource() == PropertiesDialog.this.propertyTable) {
                int n = PropertiesDialog.this.propertyTable.rowAtPoint(mouseEvent.getPoint());
                if (n > -1) {
                    boolean bl = PropertiesDialog.this.propertyTable.columnAtPoint(mouseEvent.getPoint()) == 0;
                    PropertiesDialog.this.editHelper.editProperty(n, bl);
                } else {
                    PropertiesDialog.this.editHelper.addProperty();
                    PropertiesDialog.this.btnAdd.requestFocusInWindow();
                }
            } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                int n = PropertiesDialog.this.membershipTable.rowAtPoint(mouseEvent.getPoint());
                if (n > -1) {
                    PropertiesDialog.this.editMembership(n);
                }
            } else {
                PropertiesDialog.this.editHelper.addProperty();
                PropertiesDialog.this.btnAdd.requestFocusInWindow();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == PropertiesDialog.this.propertyTable) {
                PropertiesDialog.this.membershipTable.clearSelection();
            } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                PropertiesDialog.this.propertyTable.clearSelection();
            }
        }
    }
}

