/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.OsmIdTextField;
import org.openstreetmap.josm.gui.widgets.OsmPrimitiveTypesComboBox;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadObjectDialog
extends ExtendedDialog
implements WindowListener {
    protected final JPanel panel = new JPanel();
    protected final OsmPrimitiveTypesComboBox cbType = new OsmPrimitiveTypesComboBox();
    protected final OsmIdTextField tfId = new OsmIdTextField();
    protected final HistoryComboBox cbId = new HistoryComboBox();
    protected final JCheckBox referrers = new JCheckBox(I18n.tr("Download referrers (parent relations)", new Object[0]));
    protected final JCheckBox fullRel = new JCheckBox(I18n.tr("Download relation members", new Object[0]));
    protected final JCheckBox newLayer = new JCheckBox(I18n.tr("Separate Layer", new Object[0]));

    public DownloadObjectDialog() {
        this(Main.parent);
    }

    public DownloadObjectDialog(Component component) {
        super(component, I18n.tr("Download object", new Object[0]), new String[]{I18n.tr("Download object", new Object[0]), I18n.tr("Cancel", new Object[0])});
        this.init();
    }

    protected void init() {
        GroupLayout groupLayout = new GroupLayout(this.panel);
        this.panel.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        JLabel jLabel = new JLabel(I18n.tr("Object type:", new Object[0]));
        this.cbType.addItem(I18n.trc("osm object types", "mixed"));
        this.cbType.setToolTipText(I18n.tr("Choose the OSM object type", new Object[0]));
        JLabel jLabel2 = new JLabel(I18n.tr("Object ID:", new Object[0]));
        this.cbId.setEditor(new BasicComboBoxEditor(){

            protected JosmTextField createEditorComponent() {
                return DownloadObjectDialog.this.tfId;
            }
        });
        this.cbId.setToolTipText(I18n.tr("Enter the ID of the object that should be downloaded", new Object[0]));
        this.restorePrimitivesHistory(this.cbId);
        this.tfId.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0, false));
        this.tfId.setPreferredSize(new Dimension(400, this.tfId.getPreferredSize().height));
        this.newLayer.setToolTipText(I18n.tr("Select if the data should be downloaded into a new layer", new Object[0]));
        this.newLayer.setSelected(Main.pref.getBoolean("download.newlayer"));
        this.referrers.setToolTipText(I18n.tr("Select if the referrers of the object should be downloaded as well, i.e.,parent relations and for nodes, additionally, parent ways", new Object[0]));
        this.referrers.setSelected(Main.pref.getBoolean("downloadprimitive.referrers", true));
        this.fullRel.setToolTipText(I18n.tr("Select if the members of a relation should be downloaded as well", new Object[0]));
        this.fullRel.setSelected(Main.pref.getBoolean("downloadprimitive.full", true));
        HtmlPanel htmlPanel = new HtmlPanel(I18n.tr("Object IDs can be separated by comma or space.<br/> Examples: <b><ul><li>1 2 5</li><li>1,2,5</li></ul><br/></b> In mixed mode, specify objects like this: <b>w123, n110, w12, r15</b><br/>", new Object[0]));
        htmlPanel.setBorder(BorderFactory.createEtchedBorder(1));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(jLabel).addComponent(this.cbType, -2, -2, -2)).addGroup(groupLayout.createParallelGroup().addComponent(jLabel2).addComponent(this.cbId, -2, -2, -2)).addComponent(this.referrers).addComponent(this.fullRel).addComponent(this.newLayer).addComponent(htmlPanel));
        this.cbType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DownloadObjectDialog.this.tfId.setType(DownloadObjectDialog.this.cbType.getType());
                DownloadObjectDialog.this.tfId.performValidation();
                DownloadObjectDialog.this.referrers.setText(DownloadObjectDialog.this.cbType.getType() == OsmPrimitiveType.NODE ? I18n.tr("Download referrers (parent relations and ways)", new Object[0]) : I18n.tr("Download referrers (parent relations)", new Object[0]));
            }
        });
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(jLabel).addComponent(jLabel2)).addGroup(groupLayout.createParallelGroup().addComponent(this.cbType).addComponent(this.cbId))).addComponent(this.referrers).addComponent(this.fullRel).addComponent(this.newLayer).addComponent(htmlPanel));
    }

    @Override
    public void setupDialog() {
        this.setContent(this.panel, false);
        this.setButtonIcons(new String[]{"download.png", "cancel.png"});
        this.setToolTipTexts(new String[]{I18n.tr("Start downloading", new Object[0]), I18n.tr("Close dialog and cancel downloading", new Object[0])});
        this.setDefaultButton(1);
        this.configureContextsensitiveHelp("/Action/DownloadObject", true);
        this.cbType.setSelectedIndex(Main.pref.getInteger("downloadprimitive.lasttype", 0));
        this.tfId.setType(this.cbType.getType());
        if (Main.pref.getBoolean("downloadprimitive.autopaste", true)) {
            this.tryToPasteFromClipboard(this.tfId, this.cbType);
        }
        this.addWindowListener(this);
        super.setupDialog();
    }

    protected void restorePrimitivesHistory(HistoryComboBox historyComboBox) {
        LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection(this.getClass().getName() + ".primitivesHistory", new LinkedList<String>()));
        Collections.reverse(linkedList);
        historyComboBox.setPossibleItems(linkedList);
    }

    protected void remindPrimitivesHistory(HistoryComboBox historyComboBox) {
        historyComboBox.addCurrentItemToHistory();
        Main.pref.putCollection(this.getClass().getName() + ".primitivesHistory", historyComboBox.getHistory());
    }

    protected void tryToPasteFromClipboard(OsmIdTextField osmIdTextField, OsmPrimitiveTypesComboBox osmPrimitiveTypesComboBox) {
        String string = Utils.getClipboardContent();
        if (string != null) {
            String string2;
            String[] stringArray;
            if (string.contains("node")) {
                osmPrimitiveTypesComboBox.setSelectedIndex(0);
            }
            if (string.contains("way")) {
                osmPrimitiveTypesComboBox.setSelectedIndex(1);
            }
            if (string.contains("relation")) {
                osmPrimitiveTypesComboBox.setSelectedIndex(2);
            }
            if ((stringArray = string.split("/")).length > 0) {
                string2 = stringArray[stringArray.length - 1];
                if (string2.isEmpty() && string2.length() > 1) {
                    string2 = stringArray[stringArray.length - 2];
                }
            } else {
                string2 = string;
            }
            if (string.length() <= Main.pref.getInteger("downloadprimitive.max-autopaste-length", 2000)) {
                osmIdTextField.tryToPasteFrom(string2);
            }
        }
    }

    public final boolean isNewLayerRequested() {
        return this.newLayer.isSelected();
    }

    public final boolean isFullRelationRequested() {
        return this.fullRel.isSelected();
    }

    public final boolean isReferrersRequested() {
        return this.referrers.isSelected();
    }

    public final List<PrimitiveId> getOsmIds() {
        return this.tfId.getIds();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        if (windowEvent != null && windowEvent.getComponent() == this && this.getValue() == 1) {
            Main.pref.putInteger("downloadprimitive.lasttype", this.cbType.getSelectedIndex());
            Main.pref.put("downloadprimitive.referrers", this.referrers.isSelected());
            Main.pref.put("downloadprimitive.full", this.fullRel.isSelected());
            Main.pref.put("download.newlayer", this.newLayer.isSelected());
            if (!this.tfId.readIds()) {
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("Invalid ID list specified\nCannot download object.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                return;
            }
            this.remindPrimitivesHistory(this.cbId);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

