/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.VersionInfoPanel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class CoordinateInfoViewer
extends JPanel {
    public static final Color BGCOLOR_DIFFERENCE = new Color(255, 197, 197);
    private HistoryBrowserModel model;
    private VersionInfoPanel referenceInfoPanel;
    private VersionInfoPanel currentInfoPanel;
    private LatLonViewer referenceLatLonViewer;
    private LatLonViewer currentLatLonViewer;
    private DistanceViewer distanceViewer;

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.referenceInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceInfoPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        this.currentInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentInfoPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.referenceLatLonViewer = new LatLonViewer(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceLatLonViewer, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.currentLatLonViewer = new LatLonViewer(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentLatLonViewer, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.distanceViewer = new DistanceViewer(this.model);
        this.add((Component)this.distanceViewer, gridBagConstraints);
    }

    public CoordinateInfoViewer(HistoryBrowserModel historyBrowserModel) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(historyBrowserModel, "model");
        this.setModel(historyBrowserModel);
        this.build();
        this.registerAsObserver(historyBrowserModel);
    }

    protected void unregisterAsObserver(HistoryBrowserModel historyBrowserModel) {
        if (this.currentInfoPanel != null) {
            historyBrowserModel.deleteObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            historyBrowserModel.deleteObserver(this.referenceInfoPanel);
        }
        if (this.currentLatLonViewer != null) {
            historyBrowserModel.deleteObserver(this.currentLatLonViewer);
        }
        if (this.referenceLatLonViewer != null) {
            historyBrowserModel.deleteObserver(this.referenceLatLonViewer);
        }
        if (this.distanceViewer != null) {
            historyBrowserModel.deleteObserver(this.distanceViewer);
        }
    }

    protected void registerAsObserver(HistoryBrowserModel historyBrowserModel) {
        if (this.currentInfoPanel != null) {
            historyBrowserModel.addObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            historyBrowserModel.addObserver(this.referenceInfoPanel);
        }
        if (this.currentLatLonViewer != null) {
            historyBrowserModel.addObserver(this.currentLatLonViewer);
        }
        if (this.referenceLatLonViewer != null) {
            historyBrowserModel.addObserver(this.referenceLatLonViewer);
        }
        if (this.distanceViewer != null) {
            historyBrowserModel.addObserver(this.distanceViewer);
        }
    }

    public void setModel(HistoryBrowserModel historyBrowserModel) {
        if (this.model != null) {
            this.unregisterAsObserver(historyBrowserModel);
        }
        this.model = historyBrowserModel;
        if (this.model != null) {
            this.registerAsObserver(historyBrowserModel);
        }
    }

    private static class DistanceViewer
    extends LatLonViewer {
        private JLabel lblDistance;

        public DistanceViewer(HistoryBrowserModel historyBrowserModel) {
            super(historyBrowserModel, PointInTimeType.REFERENCE_POINT_IN_TIME);
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 18;
            this.add((Component)new JLabel(I18n.tr("Distance: ", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.lblDistance = new JLabel();
            this.add((Component)this.lblDistance, gridBagConstraints);
            this.lblDistance.setBackground(Color.WHITE);
            this.lblDistance.setOpaque(true);
            this.lblDistance.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        protected void refresh() {
            HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive();
            HistoryOsmPrimitive historyOsmPrimitive2 = this.getOppositePrimitive();
            if (historyOsmPrimitive == null || !(historyOsmPrimitive instanceof HistoryNode)) {
                return;
            }
            if (historyOsmPrimitive2 == null || !(historyOsmPrimitive2 instanceof HistoryNode)) {
                return;
            }
            HistoryNode historyNode = (HistoryNode)historyOsmPrimitive;
            HistoryNode historyNode2 = (HistoryNode)historyOsmPrimitive2;
            LatLon latLon = historyNode.getCoords();
            LatLon latLon2 = historyNode2.getCoords();
            if (latLon != null && latLon2 != null) {
                double d = latLon.greatCircleDistance(latLon2);
                if (d > 0.0) {
                    this.lblDistance.setBackground(BGCOLOR_DIFFERENCE);
                } else {
                    this.lblDistance.setBackground(Color.WHITE);
                }
                this.lblDistance.setText(NavigatableComponent.getDistText(d));
            } else {
                this.lblDistance.setBackground(latLon != latLon2 ? BGCOLOR_DIFFERENCE : Color.WHITE);
                this.lblDistance.setText(I18n.tr("(none)", new Object[0]));
            }
        }
    }

    private static class LatLonViewer
    extends JPanel
    implements Observer {
        private JLabel lblLat;
        private JLabel lblLon;
        private HistoryBrowserModel model;
        private PointInTimeType role;

        protected HistoryOsmPrimitive getPrimitive() {
            if (this.model == null || this.role == null) {
                return null;
            }
            return this.model.getPointInTime(this.role);
        }

        protected HistoryOsmPrimitive getOppositePrimitive() {
            if (this.model == null || this.role == null) {
                return null;
            }
            return this.model.getPointInTime(this.role.opposite());
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 18;
            this.add((Component)new JLabel(I18n.tr("Latitude: ", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.lblLat = new JLabel();
            this.add((Component)this.lblLat, gridBagConstraints);
            this.lblLat.setBackground(Color.WHITE);
            this.lblLat.setOpaque(true);
            this.lblLat.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 18;
            this.add((Component)new JLabel(I18n.tr("Longitude: ", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.lblLon = new JLabel();
            this.add((Component)this.lblLon, gridBagConstraints);
            this.lblLon.setBackground(Color.WHITE);
            this.lblLon.setOpaque(true);
            this.lblLon.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)new JPanel(), gridBagConstraints);
        }

        public LatLonViewer(HistoryBrowserModel historyBrowserModel, PointInTimeType pointInTimeType) {
            this.build();
            this.model = historyBrowserModel;
            this.role = pointInTimeType;
        }

        protected void refresh() {
            HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive();
            HistoryOsmPrimitive historyOsmPrimitive2 = this.getOppositePrimitive();
            if (historyOsmPrimitive == null || !(historyOsmPrimitive instanceof HistoryNode)) {
                return;
            }
            if (historyOsmPrimitive2 == null || !(historyOsmPrimitive2 instanceof HistoryNode)) {
                return;
            }
            HistoryNode historyNode = (HistoryNode)historyOsmPrimitive;
            HistoryNode historyNode2 = (HistoryNode)historyOsmPrimitive2;
            LatLon latLon = historyNode.getCoords();
            LatLon latLon2 = historyNode2.getCoords();
            this.lblLat.setText(latLon != null ? latLon.latToString(CoordinateFormat.DECIMAL_DEGREES) : I18n.tr("(none)", new Object[0]));
            this.lblLon.setText(latLon != null ? latLon.lonToString(CoordinateFormat.DECIMAL_DEGREES) : I18n.tr("(none)", new Object[0]));
            if (latLon == latLon2 || latLon != null && latLon2 != null && latLon.lat() == latLon2.lat()) {
                this.lblLat.setBackground(Color.WHITE);
            } else {
                this.lblLat.setBackground(BGCOLOR_DIFFERENCE);
            }
            if (latLon == latLon2 || latLon != null && latLon2 != null && latLon.lon() == latLon2.lon()) {
                this.lblLon.setBackground(Color.WHITE);
            } else {
                this.lblLon.setBackground(BGCOLOR_DIFFERENCE);
            }
        }

        public void update(Observable observable, Object object) {
            this.refresh();
        }
    }
}

