/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class DownloadFileTask
extends PleaseWaitRunnable {
    private final String address;
    private final File file;
    private final boolean mkdir;
    private final boolean unpack;
    private boolean canceled;
    private HttpURLConnection downloadConnection;

    public DownloadFileTask(Component component, String string, File file, boolean bl, boolean bl2) {
        super(component, I18n.tr("Downloading file", new Object[0]), false);
        this.address = string;
        this.file = file;
        this.mkdir = bl;
        this.unpack = bl2;
    }

    private synchronized void closeConnectionIfNeeded() {
        if (this.downloadConnection != null) {
            this.downloadConnection.disconnect();
        }
        this.downloadConnection = null;
    }

    protected void cancel() {
        this.canceled = true;
        this.closeConnectionIfNeeded();
    }

    protected void finish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void download() throws DownloadException {
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            int n;
            Serializable serializable;
            if (this.mkdir && !((File)(serializable = this.file.getParentFile())).exists()) {
                ((File)serializable).mkdirs();
            }
            serializable = new URL(this.address);
            Object object = this;
            synchronized (object) {
                this.downloadConnection = Utils.openHttpConnection((URL)serializable);
                this.downloadConnection.setRequestProperty("Cache-Control", "no-cache");
                this.downloadConnection.connect();
                n = this.downloadConnection.getContentLength();
            }
            this.progressMonitor.setTicksCount(100);
            this.progressMonitor.subTask(I18n.tr("Downloading File {0}: {1} bytes...", this.file.getName(), n));
            inputStream = this.downloadConnection.getInputStream();
            fileOutputStream = new FileOutputStream(this.file);
            object = new byte[32768];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = inputStream.read((byte[])object);
            while (n5 != -1) {
                ((OutputStream)fileOutputStream).write((byte[])object, 0, n5);
                n2 += n5;
                if (this.canceled) break;
                n4 = 100 * n2 / n;
                if (n4 != n3) {
                    this.progressMonitor.setTicks(n4);
                    n3 = n4;
                }
                n5 = inputStream.read((byte[])object);
            }
            Utils.close(fileOutputStream);
            if (!this.canceled) {
                System.out.println(I18n.tr("Download finished", new Object[0]));
                if (this.unpack) {
                    System.out.println(I18n.tr("Unpacking {0} into {1}", this.file.getAbsolutePath(), this.file.getParent()));
                    DownloadFileTask.unzipFileRecursively(this.file, this.file.getParent());
                    this.file.delete();
                }
            }
            this.closeConnectionIfNeeded();
        }
        catch (MalformedURLException malformedURLException) {
            String string = I18n.tr("Warning: Cannot download file ''{0}''. Its download link ''{1}'' is not a valid URL. Skipping download.", this.file.getName(), this.address);
            System.err.println(string);
            throw new DownloadException(string);
            catch (IOException iOException) {
                if (!this.canceled) throw new DownloadException(iOException.getMessage());
                return;
            }
        }
        Utils.close(fileOutputStream);
        return;
        finally {
            this.closeConnectionIfNeeded();
            Utils.close(fileOutputStream);
        }
    }

    protected void realRun() throws SAXException, IOException {
        if (this.canceled) {
            return;
        }
        try {
            this.download();
        }
        catch (DownloadException downloadException) {
            downloadException.printStackTrace();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFileRecursively(File file, String string) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        InputStream inputStream = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                ZipEntry zipEntry = enumeration.nextElement();
                File file2 = new File(string, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file2.mkdirs();
                    continue;
                }
                inputStream = zipFile.getInputStream(zipEntry);
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray)) != -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                }
                Utils.close(bufferedOutputStream);
                Utils.close(inputStream);
            }
        }
        catch (Throwable throwable) {
            Utils.close(zipFile);
            throw throwable;
        }
        Utils.close(zipFile);
    }

    private static class DownloadException
    extends Exception {
        public DownloadException(String string) {
            super(string);
        }
    }
}

