/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Graphics2D;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.PaintVisitor;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.MultiMap;

public class ValidatorLayer
extends Layer
implements MapView.LayerChangeListener {
    private int updateCount = -1;

    public ValidatorLayer() {
        super(I18n.tr("Validation errors", new Object[0]));
        MapView.addLayerChangeListener(this);
    }

    public Icon getIcon() {
        return ImageProvider.get("layer", "validator_small");
    }

    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        this.updateCount = Main.map.validatorDialog.tree.getUpdateCount();
        DefaultMutableTreeNode defaultMutableTreeNode = Main.map.validatorDialog.tree.getRoot();
        if (defaultMutableTreeNode == null || defaultMutableTreeNode.getChildCount() == 0) {
            return;
        }
        PaintVisitor paintVisitor = new PaintVisitor(graphics2D, mapView);
        for (DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getLastChild(); defaultMutableTreeNode2 != null; defaultMutableTreeNode2 = defaultMutableTreeNode2.getPreviousSibling()) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode2.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                Object object = ((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
                if (!(object instanceof TestError)) continue;
                paintVisitor.visit((TestError)object);
            }
        }
        paintVisitor.clearPaintedObjects();
    }

    public String getToolTipText() {
        MultiMap<Severity, TestError> multiMap = new MultiMap<Severity, TestError>();
        List<TestError> list = Main.map.validatorDialog.tree.getErrors();
        for (TestError severityArray : list) {
            multiMap.put(severityArray.getSeverity(), severityArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Severity severity : Severity.values()) {
            if (!multiMap.containsKey(severity)) continue;
            stringBuilder.append(I18n.tr(severity.toString(), new Object[0])).append(": ").append(multiMap.get(severity).size()).append("<br>");
        }
        if (stringBuilder.length() == 0) {
            return "<html>" + I18n.tr("No validation errors", new Object[0]) + "</html>";
        }
        return "<html>" + I18n.tr("Validation errors", new Object[0]) + ":<br>" + stringBuilder + "</html>";
    }

    public void mergeFrom(Layer layer) {
    }

    public boolean isMergable(Layer layer) {
        return false;
    }

    public boolean isChanged() {
        return this.updateCount != Main.map.validatorDialog.tree.getUpdateCount();
    }

    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(null, this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
    }

    public void destroy() {
    }

    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    public void layerAdded(Layer layer) {
    }

    public void layerRemoved(Layer layer) {
        if (layer instanceof OsmDataLayer && Main.map != null && Main.map.mapView.getEditLayer() == null) {
            Main.main.removeLayer(this);
        } else if (layer == this) {
            MapView.removeLayerChangeListener(this);
            OsmValidator.errorLayer = null;
        }
    }
}

