/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTaskList;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadAlongTrackAction
extends AbstractAction {
    static final int NEAR_TRACK = 0;
    static final int NEAR_WAYPOINTS = 1;
    static final int NEAR_BOTH = 2;
    private static final String PREF_DOWNLOAD_ALONG_TRACK_DISTANCE = "gpxLayer.downloadAlongTrack.distance";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_AREA = "gpxLayer.downloadAlongTrack.area";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_NEAR = "gpxLayer.downloadAlongTrack.near";
    private final Integer[] dist = new Integer[]{5000, 500, 50};
    private final Integer[] area = new Integer[]{20, 10, 5, 1};
    private final GpxData data;

    public DownloadAlongTrackAction(GpxData gpxData) {
        super(I18n.tr("Download from OSM along this track", new Object[0]), ImageProvider.get("downloadalongtrack"));
        this.data = gpxData;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Download everything within:", new Object[0])), GBC.eol());
        String[] stringArray = new String[this.dist.length];
        for (int i = 0; i < this.dist.length; ++i) {
            stringArray[i] = I18n.tr("{0} meters", this.dist[i]);
        }
        JList<String> jList = new JList<String>(stringArray);
        jList.setSelectedIndex(Main.pref.getInteger(PREF_DOWNLOAD_ALONG_TRACK_DISTANCE, 0));
        jPanel.add(jList, GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Maximum area per request:", new Object[0])), GBC.eol());
        stringArray = new String[this.area.length];
        for (int i = 0; i < this.area.length; ++i) {
            stringArray[i] = I18n.tr("{0} sq km", this.area[i]);
        }
        JList<String> jList2 = new JList<String>(stringArray);
        jList2.setSelectedIndex(Main.pref.getInteger(PREF_DOWNLOAD_ALONG_TRACK_AREA, 0));
        jPanel.add(jList2, GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Download near:", new Object[0])), GBC.eol());
        JList<String> jList3 = new JList<String>(new String[]{I18n.tr("track only", new Object[0]), I18n.tr("waypoints only", new Object[0]), I18n.tr("track and waypoints", new Object[0])});
        jList3.setSelectedIndex(Main.pref.getInteger(PREF_DOWNLOAD_ALONG_TRACK_NEAR, 0));
        jPanel.add(jList3, GBC.eol());
        int n = JOptionPane.showConfirmDialog(Main.parent, jPanel, I18n.tr("Download from OSM along this track", new Object[0]), 2, 3);
        switch (n) {
            case -1: 
            case 2: {
                return;
            }
        }
        Main.pref.putInteger(PREF_DOWNLOAD_ALONG_TRACK_DISTANCE, jList.getSelectedIndex());
        Main.pref.putInteger(PREF_DOWNLOAD_ALONG_TRACK_AREA, jList2.getSelectedIndex());
        final int n2 = jList3.getSelectedIndex();
        Main.pref.putInteger(PREF_DOWNLOAD_ALONG_TRACK_NEAR, n2);
        double d = 0.0;
        int n3 = 0;
        if (n2 == 0 || n2 == 2) {
            for (GpxTrack iWithAttributes : this.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : iWithAttributes.getSegments()) {
                    for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                        d += wayPoint.getCoor().lat();
                        ++n3;
                    }
                }
            }
        }
        if (n2 == 1 || n2 == 2) {
            for (WayPoint wayPoint : this.data.waypoints) {
                d += wayPoint.getCoor().lat();
                ++n3;
            }
        }
        double d2 = d / (double)n3;
        double d3 = Math.cos(Math.toRadians(d2));
        Object object = jList.getSelectedIndex();
        final int n4 = this.dist[(Integer)object < 0 ? 0 : (Integer)object];
        object = jList2.getSelectedIndex();
        final double d4 = (double)this.area[(Integer)object < 0 ? 0 : (Integer)object].intValue() / 10000.0 / d3;
        final double d5 = (double)n4 / 100000.0;
        final double d6 = d5 / d3;
        final int n5 = n3;
        final boolean bl = n5 > 2000 && d5 < 0.01;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CalculateDownloadArea
        extends PleaseWaitRunnable {
            private Area a;
            private boolean cancel;
            private int ticks;
            private Rectangle2D r;

            public CalculateDownloadArea() {
                super(I18n.tr("Calculating Download Area", new Object[0]), bl2 ? null : NullProgressMonitor.INSTANCE, false);
                this.a = new Area();
                this.cancel = false;
                this.ticks = 0;
                this.r = new Rectangle2D.Double();
            }

            @Override
            protected void cancel() {
                this.cancel = true;
            }

            @Override
            protected void finish() {
            }

            @Override
            protected void afterFinish() {
                if (this.cancel) {
                    return;
                }
                DownloadAlongTrackAction.this.confirmAndDownloadAreas(this.a, d4, this.progressMonitor);
            }

            private void tick() {
                ++this.ticks;
                if (this.ticks % 100 == 0) {
                    this.progressMonitor.worked(100);
                }
            }

            private LatLon calcAreaForWayPoint(WayPoint wayPoint, LatLon latLon) {
                this.tick();
                LatLon latLon2 = wayPoint.getCoor();
                if (latLon == null || latLon2.greatCircleDistance(latLon) > (double)n4) {
                    this.r.setRect(latLon2.lon() - d6, latLon2.lat() - d5, 2.0 * d6, 2.0 * d5);
                    this.a.add(new Area(this.r));
                    return latLon2;
                }
                return latLon;
            }

            @Override
            protected void realRun() {
                this.progressMonitor.setTicksCount(n5);
                LatLon latLon = null;
                if (n2 == 0 || n2 == 2) {
                    for (GpxTrack iWithAttributes : ((DownloadAlongTrackAction)DownloadAlongTrackAction.this).data.tracks) {
                        for (GpxTrackSegment gpxTrackSegment : iWithAttributes.getSegments()) {
                            for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                                if (this.cancel) {
                                    return;
                                }
                                latLon = this.calcAreaForWayPoint(wayPoint, latLon);
                            }
                        }
                    }
                }
                if (n2 == 1 || n2 == 2) {
                    for (WayPoint wayPoint : ((DownloadAlongTrackAction)DownloadAlongTrackAction.this).data.waypoints) {
                        if (this.cancel) {
                            return;
                        }
                        latLon = this.calcAreaForWayPoint(wayPoint, latLon);
                    }
                }
            }
        }
        Main.worker.submit(new CalculateDownloadArea());
    }

    private void confirmAndDownloadAreas(Area area, double d, ProgressMonitor progressMonitor) {
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        DownloadAlongTrackAction.addToDownload(area, area.getBounds(), arrayList, d);
        if (arrayList.isEmpty()) {
            return;
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("<html>This action will require {0} individual<br>download requests. Do you wish<br>to continue?</html>", arrayList.size())), GBC.eol());
        if (arrayList.size() > 1) {
            int n = JOptionPane.showConfirmDialog(Main.parent, jPanel, I18n.tr("Download from OSM along this track", new Object[0]), 2, -1);
            switch (n) {
                case -1: 
                case 2: {
                    return;
                }
            }
        }
        final PleaseWaitProgressMonitor pleaseWaitProgressMonitor = new PleaseWaitProgressMonitor(I18n.tr("Download data", new Object[0]));
        final Future<?> future = new DownloadOsmTaskList().download(false, (List<Rectangle2D>)arrayList, (ProgressMonitor)pleaseWaitProgressMonitor);
        Main.worker.submit(new Runnable(){

            public void run() {
                try {
                    future.get();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                pleaseWaitProgressMonitor.close();
            }
        });
    }

    private static void addToDownload(Area area, Rectangle2D rectangle2D, Collection<Rectangle2D> collection, double d) {
        Area area2 = new Area(rectangle2D);
        area2.intersect(area);
        if (area2.isEmpty()) {
            return;
        }
        Rectangle2D rectangle2D2 = area2.getBounds2D();
        if (rectangle2D2.getWidth() * rectangle2D2.getHeight() > d) {
            Rectangle2D.Double double_;
            Rectangle2D.Double double_2;
            if (rectangle2D2.getWidth() > rectangle2D2.getHeight()) {
                double_2 = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() / 2.0, rectangle2D2.getHeight());
                double_ = new Rectangle2D.Double(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0, rectangle2D2.getY(), rectangle2D2.getWidth() / 2.0, rectangle2D2.getHeight());
            } else {
                double_2 = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight() / 2.0);
                double_ = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0, rectangle2D2.getWidth(), rectangle2D2.getHeight() / 2.0);
            }
            DownloadAlongTrackAction.addToDownload(area, double_2, collection, d);
            DownloadAlongTrackAction.addToDownload(area, double_, collection, d);
        } else {
            collection.add(rectangle2D2);
        }
    }
}

