/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.I18n;

public class AccessTokenInfoPanel
extends JPanel {
    private JosmTextField tfAccessTokenKey;
    private JosmTextField tfAccessTokenSecret;
    private JCheckBox cbSaveAccessTokenInPreferences;

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 3);
        this.add((Component)new JLabel(I18n.tr("Access Token Key:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.tfAccessTokenKey = new JosmTextField();
        this.add((Component)this.tfAccessTokenKey, gridBagConstraints);
        this.tfAccessTokenKey.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 3);
        this.add((Component)new JLabel(I18n.tr("Access Token Secret:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.tfAccessTokenSecret = new JosmTextField();
        this.add((Component)this.tfAccessTokenSecret, gridBagConstraints);
        this.tfAccessTokenSecret.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        this.cbSaveAccessTokenInPreferences = new JCheckBox(I18n.tr("Save Access Token in preferences", new Object[0]));
        this.add((Component)this.cbSaveAccessTokenInPreferences, gridBagConstraints);
        this.cbSaveAccessTokenInPreferences.setToolTipText(I18n.tr("<html>Select to save the Access Token in the JOSM preferences.<br>Unselect to use the Access Token in this JOSM session only.</html>", new Object[0]));
        this.cbSaveAccessTokenInPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)new JPanel(), gridBagConstraints);
    }

    public AccessTokenInfoPanel() {
        this.build();
    }

    public void setAccessToken(OAuthToken oAuthToken) {
        if (oAuthToken == null) {
            this.tfAccessTokenKey.setText("");
            this.tfAccessTokenSecret.setText("");
            return;
        }
        this.tfAccessTokenKey.setText(oAuthToken.getKey());
        this.tfAccessTokenSecret.setText(oAuthToken.getSecret());
    }

    public void setSaveToPreferences(boolean bl) {
        this.cbSaveAccessTokenInPreferences.setSelected(bl);
    }

    public boolean isSaveToPreferences() {
        return this.cbSaveAccessTokenInPreferences.isSelected();
    }
}

