/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class TMSSettingsPanel
extends JPanel {
    private final JCheckBox autozoomActive = new JCheckBox();
    private final JCheckBox autoloadTiles = new JCheckBox();
    private final JSpinner minZoomLvl;
    private final JSpinner maxZoomLvl;
    private final JCheckBox addToSlippyMapChosser = new JCheckBox();
    private final JosmTextField tilecacheDir = new JosmTextField();

    public TMSSettingsPanel() {
        super(new GridBagLayout());
        this.minZoomLvl = new JSpinner(new SpinnerNumberModel(2, 2, 30, 1));
        this.maxZoomLvl = new JSpinner(new SpinnerNumberModel(20, 2, 30, 1));
        this.add((Component)new JLabel(I18n.tr("Auto zoom by default: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.autozoomActive, GBC.eol().fill(2));
        this.add((Component)new JLabel(I18n.tr("Autoload tiles by default: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.autoloadTiles, GBC.eol().fill(2));
        this.add((Component)new JLabel(I18n.tr("Min. zoom level: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.minZoomLvl, GBC.eol());
        this.add((Component)new JLabel(I18n.tr("Max. zoom level: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.maxZoomLvl, GBC.eol());
        this.add((Component)new JLabel(I18n.tr("Add to slippymap chooser: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.addToSlippyMapChosser, GBC.eol().fill(2));
        this.add((Component)new JLabel(I18n.tr("Tile cache directory: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.tilecacheDir, GBC.eol().fill(2));
    }

    public void loadSettings() {
        this.autozoomActive.setSelected(TMSLayer.PROP_DEFAULT_AUTOZOOM.get());
        this.autoloadTiles.setSelected(TMSLayer.PROP_DEFAULT_AUTOLOAD.get());
        this.addToSlippyMapChosser.setSelected(TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get());
        this.maxZoomLvl.setValue(TMSLayer.getMaxZoomLvl(null));
        this.minZoomLvl.setValue(TMSLayer.getMinZoomLvl(null));
        this.tilecacheDir.setText(TMSLayer.PROP_TILECACHE_DIR.get());
    }

    public boolean saveSettings() {
        boolean bl = false;
        if (TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get().booleanValue() != this.addToSlippyMapChosser.isSelected()) {
            bl = true;
        }
        TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.put(this.addToSlippyMapChosser.isSelected());
        TMSLayer.PROP_DEFAULT_AUTOZOOM.put(this.autozoomActive.isSelected());
        TMSLayer.PROP_DEFAULT_AUTOLOAD.put(this.autoloadTiles.isSelected());
        TMSLayer.setMaxZoomLvl((Integer)this.maxZoomLvl.getValue());
        TMSLayer.setMinZoomLvl((Integer)this.minZoomLvl.getValue());
        TMSLayer.PROP_TILECACHE_DIR.put(this.tilecacheDir.getText());
        return bl;
    }
}

