/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.shortcut;

import java.awt.Component;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.shortcut.PrefJPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ShortcutPreference
extends DefaultTabPreferenceSetting {
    private ShortcutPreference() {
        super("shortcuts", I18n.tr("Keyboard Shortcuts", new Object[0]), I18n.tr("Changing keyboard shortcuts manually.", new Object[0]));
    }

    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        PreferenceTabbedPane.PreferencePanel preferencePanel = preferenceTabbedPane.createPreferenceTab(this);
        PrefJPanel prefJPanel = new PrefJPanel(new scListModel());
        preferencePanel.add((Component)prefJPanel, GBC.eol().fill(1));
    }

    public boolean ok() {
        return Shortcut.savePrefs();
    }

    private static class scListModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{I18n.tr("Action", new Object[0]), I18n.tr("Shortcut", new Object[0])};
        private List<Shortcut> data = Shortcut.listAll();

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return n2 == 0 ? this.data.get(n).getLongText() : this.data.get(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new ShortcutPreference();
        }
    }
}

