/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.Utils;

public class NmeaReader {
    public GpxData data;
    private static final SimpleDateFormat RMCTIMEFMT = new SimpleDateFormat("ddMMyyHHmmss.SSS");
    private static final SimpleDateFormat RMCTIMEFMTSTD = new SimpleDateFormat("ddMMyyHHmmss");
    public NMEAParserState ps;

    private Date readTime(String string) {
        Date date = RMCTIMEFMT.parse(string, new ParsePosition(0));
        if (date == null) {
            date = RMCTIMEFMTSTD.parse(string, new ParsePosition(0));
        }
        if (date == null) {
            throw new RuntimeException("Date is malformed");
        }
        return date;
    }

    public int getParserUnknown() {
        return this.ps.unknown;
    }

    public int getParserZeroCoordinates() {
        return this.ps.zero_coord;
    }

    public int getParserChecksumErrors() {
        return this.ps.checksum_errors + this.ps.no_checksum;
    }

    public int getParserMalformed() {
        return this.ps.malformed;
    }

    public int getNumberOfCoordinates() {
        return this.ps.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public NmeaReader(InputStream inputStream, File file) {
        block9: {
            int n;
            StringBuffer stringBuffer;
            BufferedReader bufferedReader;
            ArrayList<Collection<WayPoint>> arrayList;
            block8: {
                this.data = new GpxData();
                arrayList = new ArrayList<Collection<WayPoint>>();
                bufferedReader = null;
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                stringBuffer = new StringBuffer(1024);
                n = bufferedReader.read();
                this.ps = new NMEAParserState();
                if (n != -1) break block8;
                Utils.close(bufferedReader);
                return;
            }
            try {
                stringBuffer.append((char)n);
                this.ps.p_Date = "010100";
                while (true) {
                    int n2;
                    if (stringBuffer.length() >= 1020) {
                        stringBuffer.delete(0, stringBuffer.length() - 1);
                    }
                    if ((n2 = bufferedReader.read()) == 36) {
                        this.ParseNMEASentence(stringBuffer.toString(), this.ps);
                        stringBuffer.delete(0, stringBuffer.length());
                        stringBuffer.append('$');
                        continue;
                    }
                    if (n2 == -1) break;
                    stringBuffer.append((char)n2);
                }
                this.ParseNMEASentence(stringBuffer.toString(), this.ps);
                arrayList.add(this.ps.waypoints);
                this.data.tracks.add(new ImmutableGpxTrack(arrayList, Collections.<String, Object>emptyMap()));
            }
            catch (IOException iOException) {
                Utils.close(bufferedReader);
                break block9;
                catch (Throwable throwable) {
                    Utils.close(bufferedReader);
                    throw throwable;
                }
            }
            Utils.close(bufferedReader);
        }
    }

    private boolean ParseNMEASentence(String string, NMEAParserState nMEAParserState) {
        try {
            Object[] objectArray;
            if (string.equals("")) {
                throw new NullPointerException();
            }
            String[] stringArray = string.split("\\*");
            if (stringArray.length > 1) {
                objectArray = stringArray[0].getBytes();
                int n = 0;
                for (int i = 1; i < objectArray.length; ++i) {
                    n ^= objectArray[i];
                }
                if (Integer.parseInt(stringArray[1].substring(0, 2), 16) != n) {
                    ++nMEAParserState.checksum_errors;
                    nMEAParserState.p_Wp = null;
                    return false;
                }
            } else {
                ++nMEAParserState.no_checksum;
            }
            objectArray = stringArray[0].split(",");
            WayPoint wayPoint = nMEAParserState.p_Wp;
            Object object = nMEAParserState.p_Date;
            if (objectArray[0].equals("$GPGGA") || objectArray[0].equals("$GNGGA")) {
                LatLon latLon = this.parseLatLon((String)objectArray[GPGGA.LATITUDE_NAME.position], (String)objectArray[GPGGA.LONGITUDE_NAME.position], (String)objectArray[GPGGA.LATITUDE.position], (String)objectArray[GPGGA.LONGITUDE.position]);
                if (latLon == null) {
                    throw new NullPointerException();
                }
                if (latLon.lat() == 0.0 && latLon.lon() == 0.0) {
                    ++nMEAParserState.zero_coord;
                    return false;
                }
                byte by = objectArray[GPGGA.TIME.position];
                Date date = this.readTime(object + (String)by);
                if (nMEAParserState.p_Time == null || wayPoint == null || !nMEAParserState.p_Time.equals(by)) {
                    nMEAParserState.p_Time = (String)by;
                    wayPoint = new WayPoint(latLon);
                }
                if (!wayPoint.attr.containsKey("time")) {
                    wayPoint.attr.put("time", DateUtils.fromDate(date));
                }
                if ((by = objectArray[GPGGA.HEIGHT_UNTIS.position]).equals("M") && !(by = objectArray[GPGGA.HEIGHT.position]).equals("")) {
                    Double.parseDouble((String)by);
                    if (!by.equals("")) {
                        wayPoint.attr.put("ele", by);
                    }
                }
                by = objectArray[GPGGA.SATELLITE_COUNT.position];
                int n = 0;
                if (!by.equals("")) {
                    n = Integer.parseInt((String)by);
                    wayPoint.attr.put("sat", by);
                }
                if (!(by = objectArray[GPGGA.HDOP.position]).equals("")) {
                    wayPoint.attr.put("hdop", Float.valueOf(Float.parseFloat((String)by)));
                }
                if (!(by = objectArray[GPGGA.QUALITY.position]).equals("")) {
                    int n2 = Integer.parseInt((String)by);
                    switch (n2) {
                        case 0: {
                            wayPoint.attr.put("fix", "none");
                            break;
                        }
                        case 1: {
                            if (n < 4) {
                                wayPoint.attr.put("fix", "2d");
                                break;
                            }
                            wayPoint.attr.put("fix", "3d");
                            break;
                        }
                        case 2: {
                            wayPoint.attr.put("fix", "dgps");
                            break;
                        }
                    }
                }
            } else if (objectArray[0].equals("$GPVTG") || objectArray[0].equals("$GNVTG")) {
                byte by = objectArray[GPVTG.COURSE_REF.position];
                if (by.equals("T") && !(by = objectArray[GPVTG.COURSE.position]).equals("")) {
                    Double.parseDouble((String)by);
                    wayPoint.attr.put("course", by);
                }
                if ((by = objectArray[GPVTG.SPEED_KMH_UNIT.position]).startsWith("K") && !(by = objectArray[GPVTG.SPEED_KMH.position]).equals("")) {
                    double d = Double.parseDouble((String)by);
                    wayPoint.attr.put("speed", Double.toString(d /= 3.6));
                }
            } else if (objectArray[0].equals("$GPGSA") || objectArray[0].equals("$GNGSA")) {
                byte by = objectArray[GPGSA.VDOP.position];
                if (!by.equals("")) {
                    wayPoint.attr.put("vdop", Float.valueOf(Float.parseFloat((String)by)));
                }
                if (!(by = objectArray[GPGSA.HDOP.position]).equals("")) {
                    wayPoint.attr.put("hdop", Float.valueOf(Float.parseFloat((String)by)));
                }
                if (!(by = objectArray[GPGSA.PDOP.position]).equals("")) {
                    wayPoint.attr.put("pdop", Float.valueOf(Float.parseFloat((String)by)));
                }
            } else if (objectArray[0].equals("$GPRMC") || objectArray[0].equals("$GNRMC")) {
                LatLon latLon = this.parseLatLon((String)objectArray[GPRMC.WIDTH_NORTH_NAME.position], (String)objectArray[GPRMC.LENGTH_EAST_NAME.position], (String)objectArray[GPRMC.WIDTH_NORTH.position], (String)objectArray[GPRMC.LENGTH_EAST.position]);
                if (latLon.lat() == 0.0 && latLon.lon() == 0.0) {
                    ++nMEAParserState.zero_coord;
                    return false;
                }
                object = objectArray[GPRMC.DATE.position];
                byte by = objectArray[GPRMC.TIME.position];
                Date date = this.readTime(object + (String)by);
                if (nMEAParserState.p_Time == null || wayPoint == null || !nMEAParserState.p_Time.equals(by)) {
                    nMEAParserState.p_Time = (String)by;
                    wayPoint = new WayPoint(latLon);
                }
                wayPoint.attr.put("time", DateUtils.fromDate(date));
                byte by2 = objectArray[GPRMC.SPEED.position];
                if (!by2.equals("") && !wayPoint.attr.containsKey("speed")) {
                    double d = Double.parseDouble((String)by2);
                    wayPoint.attr.put("speed", Double.toString(d *= 0.514444444));
                }
                if (!(by2 = objectArray[GPRMC.COURSE.position]).equals("") && !wayPoint.attr.containsKey("course")) {
                    Double.parseDouble((String)by2);
                    wayPoint.attr.put("course", by2);
                }
            } else {
                ++nMEAParserState.unknown;
                return false;
            }
            nMEAParserState.p_Date = object;
            if (nMEAParserState.p_Wp != wayPoint) {
                if (nMEAParserState.p_Wp != null) {
                    nMEAParserState.p_Wp.setTime();
                }
                nMEAParserState.p_Wp = wayPoint;
                nMEAParserState.waypoints.add(wayPoint);
                ++nMEAParserState.success;
                return true;
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            ++nMEAParserState.malformed;
            nMEAParserState.p_Wp = null;
            return false;
        }
    }

    private LatLon parseLatLon(String string, String string2, String string3, String string4) throws NumberFormatException {
        int n;
        String string5 = string3.trim();
        String string6 = string4.trim();
        if (string5.equals("") && string6.equals("")) {
            return new LatLon(0.0, 0.0);
        }
        int n2 = string5.indexOf(46) - 2;
        if (n2 < 0) {
            return null;
        }
        int n3 = Integer.parseInt(string5.substring(0, n2));
        double d = Double.parseDouble(string5.substring(n2));
        if (n3 < 0) {
            d *= -1.0;
        }
        double d2 = (double)n3 + d / 60.0;
        if ("S".equals(string)) {
            d2 = -d2;
        }
        if ((n = string6.indexOf(46) - 2) < 0) {
            return null;
        }
        int n4 = Integer.parseInt(string6.substring(0, n));
        double d3 = Double.parseDouble(string6.substring(n));
        if (n4 < 0) {
            d3 *= -1.0;
        }
        double d4 = (double)n4 + d3 / 60.0;
        if ("W".equals(string2)) {
            d4 = -d4;
        }
        return new LatLon(d2, d4);
    }

    private static class NMEAParserState {
        protected Collection<WayPoint> waypoints = new ArrayList<WayPoint>();
        protected String p_Time;
        protected String p_Date;
        protected WayPoint p_Wp;
        protected int success = 0;
        protected int malformed = 0;
        protected int checksum_errors = 0;
        protected int no_checksum = 0;
        protected int unknown = 0;
        protected int zero_coord = 0;

        private NMEAParserState() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GPGSA {
        AUTOMATIC(1),
        FIX_TYPE(2),
        PRN_1(3),
        PRN_2(4),
        PRN_3(5),
        PRN_4(6),
        PRN_5(7),
        PRN_6(8),
        PRN_7(9),
        PRN_8(10),
        PRN_9(11),
        PRN_10(12),
        PRN_11(13),
        PRN_12(14),
        PDOP(15),
        HDOP(16),
        VDOP(17);

        public final int position;

        private GPGSA(int n2) {
            this.position = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GPGGA {
        TIME(1),
        LATITUDE(2),
        LATITUDE_NAME(3),
        LONGITUDE(4),
        LONGITUDE_NAME(5),
        QUALITY(6),
        SATELLITE_COUNT(7),
        HDOP(8),
        HEIGHT(9),
        HEIGHT_UNTIS(10),
        HEIGHT_2(11),
        HEIGHT_2_UNTIS(12),
        GPS_AGE(13),
        REF(14);

        public final int position;

        private GPGGA(int n2) {
            this.position = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GPRMC {
        TIME(1),
        RECEIVER_WARNING(2),
        WIDTH_NORTH(3),
        WIDTH_NORTH_NAME(4),
        LENGTH_EAST(5),
        LENGTH_EAST_NAME(6),
        SPEED(7),
        COURSE(8),
        DATE(9),
        MAGNETIC_DECLINATION(10),
        UNKNOWN(11),
        MODE(12);

        public final int position;

        private GPRMC(int n2) {
            this.position = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GPVTG {
        COURSE(1),
        COURSE_REF(2),
        COURSE_M(3),
        COURSE_M_REF(4),
        SPEED_KN(5),
        SPEED_KN_UNIT(6),
        SPEED_KMH(7),
        SPEED_KMH_UNIT(8),
        REST(9);

        public final int position;

        private GPVTG(int n2) {
            this.position = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NMEA_TYPE {
        GPRMC("$GPRMC"),
        GPGGA("$GPGGA"),
        GPGSA("$GPGSA"),
        GPVTG("$GPVTG");

        private final String type;

        private NMEA_TYPE(String string2) {
            this.type = string2;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(String string) {
            return this.type.equals(string);
        }
    }
}

