/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodePositionComparator;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Geometry {
    public static Set<Node> addIntersections(List<Way> list, boolean bl, List<Command> list2) {
        Object object;
        int n;
        ArrayList[] arrayListArray = new ArrayList[list.size()];
        BBox[] bBoxArray = new BBox[list.size()];
        boolean[] blArray = new boolean[list.size()];
        LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
        for (int i = 0; i < list.size(); ++i) {
            arrayListArray[i] = new ArrayList<Node>(list.get(i).getNodes());
            bBoxArray[i] = Geometry.getNodesBounds(arrayListArray[i]);
            blArray[i] = false;
        }
        NodePositionComparator nodePositionComparator = new NodePositionComparator();
        for (n = 0; n < list.size(); ++n) {
            for (int i = n; i < list.size(); ++i) {
                if (!bBoxArray[n].intersects(bBoxArray[i])) continue;
                object = arrayListArray[n];
                ArrayList arrayList = arrayListArray[i];
                int n2 = 0;
                while (n2 + 1 < ((ArrayList)object).size()) {
                    int n3;
                    int n4 = n3 = n != i ? 0 : n2 + 2;
                    while (n4 + 1 < arrayList.size()) {
                        Node node = (Node)((ArrayList)object).get(n2);
                        Node node2 = (Node)((ArrayList)object).get(n2 + 1);
                        Node node3 = (Node)arrayList.get(n4);
                        Node node4 = (Node)arrayList.get(n4 + 1);
                        int n5 = 0;
                        if (node == node3 || node == node4) {
                            ++n5;
                            if (n != i || n2 != 0 || n4 != arrayList.size() - 2) {
                                linkedHashSet.add(node);
                            }
                        }
                        if (node2 == node3 || node2 == node4) {
                            ++n5;
                            linkedHashSet.add(node2);
                        }
                        if (n5 == 0) {
                            EastNorth eastNorth = Geometry.getSegmentSegmentIntersection(node.getEastNorth(), node2.getEastNorth(), node3.getEastNorth(), node4.getEastNorth());
                            if (eastNorth != null) {
                                Node node5;
                                if (bl) {
                                    linkedHashSet.add(node3);
                                    return linkedHashSet;
                                }
                                Node node6 = node5 = new Node(Main.getProjection().eastNorth2latlon(eastNorth));
                                boolean bl2 = false;
                                boolean bl3 = false;
                                if (nodePositionComparator.compare(node5, node) == 0) {
                                    node6 = node;
                                } else if (nodePositionComparator.compare(node5, node2) == 0) {
                                    node6 = node2;
                                } else {
                                    bl2 = true;
                                }
                                if (nodePositionComparator.compare(node5, node3) == 0) {
                                    node6 = node3;
                                } else if (nodePositionComparator.compare(node5, node4) == 0) {
                                    node6 = node4;
                                } else {
                                    bl3 = true;
                                }
                                if (bl2) {
                                    ((ArrayList)object).add(n2 + 1, node6);
                                    blArray[n] = true;
                                    if (i == n) {
                                        ++n4;
                                    }
                                }
                                if (bl3) {
                                    arrayList.add(n4 + 1, node6);
                                    blArray[i] = true;
                                    ++n4;
                                }
                                linkedHashSet.add(node6);
                                if (node6 == node5) {
                                    list2.add(new AddCommand(node6));
                                }
                            }
                        } else if (bl && linkedHashSet.size() > 0) {
                            return linkedHashSet;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        for (n = 0; n < list.size(); ++n) {
            if (!blArray[n]) continue;
            Way way = list.get(n);
            object = new Way(way);
            ((Way)object).setNodes(arrayListArray[n]);
            list2.add(new ChangeCommand(way, (OsmPrimitive)object));
        }
        return linkedHashSet;
    }

    private static BBox getNodesBounds(ArrayList<Node> arrayList) {
        BBox bBox = new BBox(arrayList.get(0));
        for (Node node : arrayList) {
            bBox.add(node.getCoor());
        }
        return bBox;
    }

    public static boolean isToTheRightSideOfLine(Node node, Node node2, Node node3, Node node4) {
        boolean bl = Geometry.angleIsClockwise(node, node2, node3);
        boolean bl2 = Geometry.angleIsClockwise(node, node2, node4);
        boolean bl3 = Geometry.angleIsClockwise(node2, node3, node4);
        if (bl) {
            return bl2 && bl3;
        }
        return bl2 || bl3;
    }

    public static boolean angleIsClockwise(Node node, Node node2, Node node3) {
        return Geometry.angleIsClockwise(node.getEastNorth(), node2.getEastNorth(), node3.getEastNorth());
    }

    public static EastNorth getSegmentSegmentIntersection(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8 = eastNorth.getX();
        if (!Line2D.linesIntersect(d8, d7 = eastNorth.getY(), d6 = eastNorth2.getX(), d5 = eastNorth2.getY(), d4 = eastNorth3.getX(), d3 = eastNorth3.getY(), d2 = eastNorth4.getX(), d = eastNorth4.getY())) {
            return null;
        }
        double d9 = d5 - d7;
        double d10 = d8 - d6;
        double d11 = d6 * d7 - d8 * d5;
        double d12 = d - d3;
        double d13 = d4 - d2;
        double d14 = d2 * d3 - d4 * d;
        double d15 = d9 * d13 - d12 * d10;
        if (d15 == 0.0) {
            return null;
        }
        double d16 = (d10 * d14 - d13 * d11) / d15;
        double d17 = (d12 * d11 - d9 * d14) / d15;
        return new EastNorth(d16, d17);
    }

    public static EastNorth getLineLineIntersection(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        double d = eastNorth2.getY() - eastNorth.getY();
        double d2 = eastNorth.getX() - eastNorth2.getX();
        double d3 = eastNorth2.getX() * eastNorth.getY() - eastNorth.getX() * eastNorth2.getY();
        double d4 = eastNorth4.getY() - eastNorth3.getY();
        double d5 = eastNorth3.getX() - eastNorth4.getX();
        double d6 = eastNorth4.getX() * eastNorth3.getY() - eastNorth3.getX() * eastNorth4.getY();
        double d7 = d * d5 - d4 * d2;
        if (d7 == 0.0) {
            return null;
        }
        return new EastNorth((d2 * d6 - d5 * d3) / d7, (d4 * d3 - d * d6) / d7);
    }

    public static boolean segmentsParallel(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        double d = eastNorth2.getY() - eastNorth.getY();
        double d2 = eastNorth.getX() - eastNorth2.getX();
        double d3 = eastNorth4.getY() - eastNorth3.getY();
        double d4 = eastNorth3.getX() - eastNorth4.getX();
        double d5 = d * d4 - d3 * d2;
        return Math.abs(d5 /= Math.sqrt(d * d + d2 * d2) * Math.sqrt(d3 * d3 + d4 * d4)) < 0.001;
    }

    private static EastNorth closestPointTo(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, boolean bl) {
        CheckParameterUtil.ensureParameterNotNull(eastNorth, "p1");
        CheckParameterUtil.ensureParameterNotNull(eastNorth2, "p2");
        CheckParameterUtil.ensureParameterNotNull(eastNorth3, "point");
        double d = eastNorth2.getX() - eastNorth.getX();
        double d2 = eastNorth2.getY() - eastNorth.getY();
        if (d == 0.0 && d2 == 0.0) {
            return eastNorth;
        }
        double d3 = eastNorth3.getX() - eastNorth.getX();
        double d4 = eastNorth3.getY() - eastNorth.getY();
        double d5 = (d3 * d + d4 * d2) / (d * d + d2 * d2);
        if (bl && d5 <= 0.0) {
            return eastNorth;
        }
        if (bl && d5 >= 1.0) {
            return eastNorth2;
        }
        return new EastNorth(eastNorth.getX() + d * d5, eastNorth.getY() + d2 * d5);
    }

    public static EastNorth closestPointToSegment(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3) {
        return Geometry.closestPointTo(eastNorth, eastNorth2, eastNorth3, true);
    }

    public static EastNorth closestPointToLine(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3) {
        return Geometry.closestPointTo(eastNorth, eastNorth2, eastNorth3, false);
    }

    public static boolean angleIsClockwise(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3) {
        double d = eastNorth2.getY() - eastNorth.getY();
        double d2 = eastNorth3.getY() - eastNorth.getY();
        double d3 = eastNorth2.getX() - eastNorth.getX();
        double d4 = eastNorth3.getX() - eastNorth.getX();
        return d * d4 - d3 * d2 > 0.0;
    }

    private static Area getArea(List<Node> list) {
        Path2D.Double double_ = new Path2D.Double();
        boolean bl = true;
        for (Node node : list) {
            if (bl) {
                ((Path2D)double_).moveTo(node.getEastNorth().getX(), node.getEastNorth().getY());
                bl = false;
                continue;
            }
            ((Path2D)double_).lineTo(node.getEastNorth().getX(), node.getEastNorth().getY());
        }
        if (!bl) {
            double_.closePath();
        }
        return new Area(double_);
    }

    public static PolygonIntersection polygonIntersection(List<Node> list, List<Node> list2) {
        Area area = Geometry.getArea(list);
        Area area2 = Geometry.getArea(list2);
        Area area3 = new Area(area);
        area3.intersect(area2);
        Rectangle rectangle = area3.getBounds();
        if (area3.isEmpty() || rectangle.getHeight() * rectangle.getWidth() <= 1.0) {
            return PolygonIntersection.OUTSIDE;
        }
        if (area3.equals(area)) {
            return PolygonIntersection.FIRST_INSIDE_SECOND;
        }
        if (area3.equals(area2)) {
            return PolygonIntersection.SECOND_INSIDE_FIRST;
        }
        return PolygonIntersection.CROSSING;
    }

    public static boolean nodeInsidePolygon(Node node, List<Node> list) {
        if (list.size() < 2) {
            return false;
        }
        boolean bl = false;
        Node node2 = list.get(list.size() - 1);
        for (Node node3 : list) {
            Node node4;
            Node node5;
            if (node3.equals(node2)) continue;
            if (node3.getEastNorth().getY() > node2.getEastNorth().getY()) {
                node5 = node2;
                node4 = node3;
            } else {
                node5 = node3;
                node4 = node2;
            }
            if (node3.getEastNorth().getY() < node.getEastNorth().getY() == node.getEastNorth().getY() <= node2.getEastNorth().getY() && (node.getEastNorth().getX() - node5.getEastNorth().getX()) * (node4.getEastNorth().getY() - node5.getEastNorth().getY()) < (node4.getEastNorth().getX() - node5.getEastNorth().getX()) * (node.getEastNorth().getY() - node5.getEastNorth().getY())) {
                bl = !bl;
            }
            node2 = node3;
        }
        return bl;
    }

    public static double closedWayArea(Way way) {
        double d = 0.0;
        Node node = null;
        for (Node node2 : way.getNodes()) {
            if (node != null) {
                node2.getEastNorth().getX();
                d += Geometry.calcX(node2) * Geometry.calcY(node) - Geometry.calcY(node2) * Geometry.calcX(node);
            }
            node = node2;
        }
        return Math.abs(d / 2.0);
    }

    protected static double calcX(Node node) {
        double d = node.getCoor().lat() * Math.PI / 180.0;
        double d2 = node.getCoor().lon() * Math.PI / 180.0;
        double d3 = d;
        double d4 = 0.0;
        double d5 = d4 - d2;
        double d6 = d3 - d;
        double d7 = Math.pow(Math.sin(d6 / 2.0), 2.0) + Math.cos(d) * Math.cos(d3) * Math.pow(Math.sin(d5 / 2.0), 2.0);
        double d8 = 2.0 * Math.atan2(Math.sqrt(d7), Math.sqrt(1.0 - d7));
        return 6367000.0 * d8;
    }

    protected static double calcY(Node node) {
        double d = node.getCoor().lat() * Math.PI / 180.0;
        double d2 = node.getCoor().lon() * Math.PI / 180.0;
        double d3 = 0.0;
        double d4 = d2;
        double d5 = d4 - d2;
        double d6 = d3 - d;
        double d7 = Math.pow(Math.sin(d6 / 2.0), 2.0) + Math.cos(d) * Math.cos(d3) * Math.pow(Math.sin(d5 / 2.0), 2.0);
        double d8 = 2.0 * Math.atan2(Math.sqrt(d7), Math.sqrt(1.0 - d7));
        return 6367000.0 * d8;
    }

    public static boolean isClockwise(Way way) {
        if (!way.isClosed()) {
            throw new IllegalArgumentException("Way must be closed to check orientation.");
        }
        double d = 0.0;
        int n = way.getNodesCount();
        for (int i = 1; i <= n; ++i) {
            LatLon latLon = way.getNode(i - 1).getCoor();
            LatLon latLon2 = way.getNode(i % n).getCoor();
            d += latLon.lon() * latLon2.lat();
            d -= latLon2.lon() * latLon.lat();
        }
        return d < 0.0;
    }

    public static double getSegmentAngle(EastNorth eastNorth, EastNorth eastNorth2) {
        return Math.atan2(eastNorth2.north() - eastNorth.north(), eastNorth2.east() - eastNorth.east());
    }

    public static double getCornerAngle(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3) {
        Double d = Geometry.getSegmentAngle(eastNorth2, eastNorth) - Geometry.getSegmentAngle(eastNorth2, eastNorth3);
        if (d <= -Math.PI) {
            d = d + Math.PI * 2;
        }
        if (d > Math.PI) {
            d = d - Math.PI * 2;
        }
        return d;
    }

    public static EastNorth getCentroid(List<Node> list) {
        BigDecimal bigDecimal = new BigDecimal(0);
        BigDecimal bigDecimal2 = new BigDecimal(0);
        BigDecimal bigDecimal3 = new BigDecimal(0);
        for (int i = 0; i < list.size(); ++i) {
            EastNorth eastNorth = list.get(i).getEastNorth();
            EastNorth eastNorth2 = list.get((i + 1) % list.size()).getEastNorth();
            BigDecimal bigDecimal4 = new BigDecimal(eastNorth.east());
            BigDecimal bigDecimal5 = new BigDecimal(eastNorth.north());
            BigDecimal bigDecimal6 = new BigDecimal(eastNorth2.east());
            BigDecimal bigDecimal7 = new BigDecimal(eastNorth2.north());
            BigDecimal bigDecimal8 = bigDecimal4.multiply(bigDecimal7, MathContext.DECIMAL128).subtract(bigDecimal5.multiply(bigDecimal6, MathContext.DECIMAL128));
            bigDecimal = bigDecimal.add(bigDecimal8, MathContext.DECIMAL128);
            bigDecimal3 = bigDecimal3.add(bigDecimal8.multiply(bigDecimal4.add(bigDecimal6, MathContext.DECIMAL128), MathContext.DECIMAL128));
            bigDecimal2 = bigDecimal2.add(bigDecimal8.multiply(bigDecimal5.add(bigDecimal7, MathContext.DECIMAL128), MathContext.DECIMAL128));
        }
        BigDecimal bigDecimal9 = new BigDecimal(3, MathContext.DECIMAL128);
        if ((bigDecimal = bigDecimal.multiply(bigDecimal9, MathContext.DECIMAL128)).compareTo(BigDecimal.ZERO) != 0) {
            bigDecimal2 = bigDecimal2.divide(bigDecimal, MathContext.DECIMAL128);
            bigDecimal3 = bigDecimal3.divide(bigDecimal, MathContext.DECIMAL128);
        }
        return new EastNorth(bigDecimal3.doubleValue(), bigDecimal2.doubleValue());
    }

    public static EastNorth getSegmentAltituteIntersection(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3) {
        Double d = eastNorth.distance(eastNorth2);
        Double d2 = Geometry.getSegmentAngle(eastNorth, eastNorth2) + 1.5707963267948966;
        EastNorth eastNorth4 = new EastNorth(eastNorth3.east() + 1000.0 * Math.cos(d2), eastNorth3.north() + 1000.0 * Math.sin(d2));
        EastNorth eastNorth5 = Geometry.getLineLineIntersection(eastNorth, eastNorth2, eastNorth3, eastNorth4);
        if (eastNorth5 != null && eastNorth5.distance(eastNorth) * 0.999 < d && eastNorth5.distance(eastNorth2) * 0.999 < d) {
            return eastNorth5;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PolygonIntersection {
        FIRST_INSIDE_SECOND,
        SECOND_INSIDE_FIRST,
        OUTSIDE,
        CROSSING;

    }
}

