/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.xml;

import com.kitfox.svg.xml.XMLParseUtil;
import java.io.Serializable;

public class NumberWithUnits
implements Serializable {
    public static final long serialVersionUID = 0L;
    public static final int UT_UNITLESS = 0;
    public static final int UT_PX = 1;
    public static final int UT_CM = 2;
    public static final int UT_MM = 3;
    public static final int UT_IN = 4;
    public static final int UT_EM = 5;
    public static final int UT_EX = 6;
    public static final int UT_PT = 7;
    public static final int UT_PC = 8;
    public static final int UT_PERCENT = 9;
    float value = 0.0f;
    int unitType = 0;

    public NumberWithUnits() {
    }

    public NumberWithUnits(String string) {
        this.set(string);
    }

    public NumberWithUnits(float f, int n) {
        this.value = f;
        this.unitType = n;
    }

    public float getValue() {
        return this.value;
    }

    public int getUnits() {
        return this.unitType;
    }

    public void set(String string) {
        this.value = XMLParseUtil.findFloat(string);
        this.unitType = 0;
        if (string.indexOf("px") != -1) {
            this.unitType = 1;
            return;
        }
        if (string.indexOf("cm") != -1) {
            this.unitType = 2;
            return;
        }
        if (string.indexOf("mm") != -1) {
            this.unitType = 3;
            return;
        }
        if (string.indexOf("in") != -1) {
            this.unitType = 4;
            return;
        }
        if (string.indexOf("em") != -1) {
            this.unitType = 5;
            return;
        }
        if (string.indexOf("ex") != -1) {
            this.unitType = 6;
            return;
        }
        if (string.indexOf("pt") != -1) {
            this.unitType = 7;
            return;
        }
        if (string.indexOf("pc") != -1) {
            this.unitType = 8;
            return;
        }
        if (string.indexOf("%") != -1) {
            this.unitType = 9;
            return;
        }
    }

    public static String unitsAsString(int n) {
        switch (n) {
            default: {
                return "";
            }
            case 1: {
                return "px";
            }
            case 2: {
                return "cm";
            }
            case 3: {
                return "mm";
            }
            case 4: {
                return "in";
            }
            case 5: {
                return "em";
            }
            case 6: {
                return "ex";
            }
            case 7: {
                return "pt";
            }
            case 8: {
                return "pc";
            }
            case 9: 
        }
        return "%";
    }

    public String toString() {
        return "" + this.value + NumberWithUnits.unitsAsString(this.unitType);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NumberWithUnits numberWithUnits = (NumberWithUnits)object;
        if (Float.floatToIntBits(this.value) != Float.floatToIntBits(numberWithUnits.value)) {
            return false;
        }
        return this.unitType == numberWithUnits.unitType;
    }

    public int hashCode() {
        int n = 5;
        n = 37 * n + Float.floatToIntBits(this.value);
        n = 37 * n + this.unitType;
        return n;
    }
}

