/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import oauth.signpost.OAuth;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.basic.UrlStringRequestAdapter;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.http.HttpParameters;
import oauth.signpost.http.HttpRequest;
import oauth.signpost.signature.AuthorizationHeaderSigningStrategy;
import oauth.signpost.signature.HmacSha1MessageSigner;
import oauth.signpost.signature.OAuthMessageSigner;
import oauth.signpost.signature.QueryStringSigningStrategy;
import oauth.signpost.signature.SigningStrategy;

public abstract class AbstractOAuthConsumer
implements OAuthConsumer {
    private static final long serialVersionUID = 1L;
    private String consumerKey;
    private String consumerSecret;
    private String token;
    private OAuthMessageSigner messageSigner;
    private SigningStrategy signingStrategy;
    private HttpParameters additionalParameters;
    private HttpParameters requestParameters;
    private boolean sendEmptyTokens;

    public AbstractOAuthConsumer(String string, String string2) {
        this.consumerKey = string;
        this.consumerSecret = string2;
        this.setMessageSigner(new HmacSha1MessageSigner());
        this.setSigningStrategy(new AuthorizationHeaderSigningStrategy());
    }

    public void setMessageSigner(OAuthMessageSigner oAuthMessageSigner) {
        this.messageSigner = oAuthMessageSigner;
        oAuthMessageSigner.setConsumerSecret(this.consumerSecret);
    }

    public void setSigningStrategy(SigningStrategy signingStrategy) {
        this.signingStrategy = signingStrategy;
    }

    public void setAdditionalParameters(HttpParameters httpParameters) {
        this.additionalParameters = httpParameters;
    }

    public HttpRequest sign(HttpRequest httpRequest) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException {
        if (this.consumerKey == null) {
            throw new OAuthExpectationFailedException("consumer key not set");
        }
        if (this.consumerSecret == null) {
            throw new OAuthExpectationFailedException("consumer secret not set");
        }
        this.requestParameters = new HttpParameters();
        try {
            if (this.additionalParameters != null) {
                this.requestParameters.putAll(this.additionalParameters, false);
            }
            this.collectHeaderParameters(httpRequest, this.requestParameters);
            this.collectQueryParameters(httpRequest, this.requestParameters);
            this.collectBodyParameters(httpRequest, this.requestParameters);
            this.completeOAuthParameters(this.requestParameters);
            this.requestParameters.remove("oauth_signature");
        }
        catch (IOException iOException) {
            throw new OAuthCommunicationException(iOException);
        }
        String string = this.messageSigner.sign(httpRequest, this.requestParameters);
        OAuth.debugOut("signature", string);
        this.signingStrategy.writeSignature(string, httpRequest, this.requestParameters);
        OAuth.debugOut("Auth header", httpRequest.getHeader("Authorization"));
        OAuth.debugOut("Request URL", httpRequest.getRequestUrl());
        return httpRequest;
    }

    public HttpRequest sign(Object object) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException {
        return this.sign(this.wrap(object));
    }

    public String sign(String string) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException {
        UrlStringRequestAdapter urlStringRequestAdapter = new UrlStringRequestAdapter(string);
        SigningStrategy signingStrategy = this.signingStrategy;
        this.signingStrategy = new QueryStringSigningStrategy();
        this.sign(urlStringRequestAdapter);
        this.signingStrategy = signingStrategy;
        return urlStringRequestAdapter.getRequestUrl();
    }

    protected abstract HttpRequest wrap(Object var1);

    public void setTokenWithSecret(String string, String string2) {
        this.token = string;
        this.messageSigner.setTokenSecret(string2);
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenSecret() {
        return this.messageSigner.getTokenSecret();
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    protected void completeOAuthParameters(HttpParameters httpParameters) {
        if (!httpParameters.containsKey("oauth_consumer_key")) {
            httpParameters.put("oauth_consumer_key", this.consumerKey, true);
        }
        if (!httpParameters.containsKey("oauth_signature_method")) {
            httpParameters.put("oauth_signature_method", this.messageSigner.getSignatureMethod(), true);
        }
        if (!httpParameters.containsKey("oauth_timestamp")) {
            httpParameters.put("oauth_timestamp", this.generateTimestamp(), true);
        }
        if (!httpParameters.containsKey("oauth_nonce")) {
            httpParameters.put("oauth_nonce", this.generateNonce(), true);
        }
        if (!httpParameters.containsKey("oauth_version")) {
            httpParameters.put("oauth_version", "1.0", true);
        }
        if (!httpParameters.containsKey("oauth_token") && (this.token != null && !this.token.equals("") || this.sendEmptyTokens)) {
            httpParameters.put("oauth_token", this.token, true);
        }
    }

    public HttpParameters getRequestParameters() {
        return this.requestParameters;
    }

    public void setSendEmptyTokens(boolean bl) {
        this.sendEmptyTokens = bl;
    }

    protected void collectHeaderParameters(HttpRequest httpRequest, HttpParameters httpParameters) {
        HttpParameters httpParameters2 = OAuth.oauthHeaderToParamsMap(httpRequest.getHeader("Authorization"));
        httpParameters.putAll(httpParameters2, false);
    }

    protected void collectBodyParameters(HttpRequest httpRequest, HttpParameters httpParameters) throws IOException {
        String string = httpRequest.getContentType();
        if (string != null && string.startsWith("application/x-www-form-urlencoded")) {
            InputStream inputStream = httpRequest.getMessagePayload();
            httpParameters.putAll(OAuth.decodeForm(inputStream), true);
        }
    }

    protected void collectQueryParameters(HttpRequest httpRequest, HttpParameters httpParameters) {
        String string = httpRequest.getRequestUrl();
        int n = string.indexOf(63);
        if (n >= 0) {
            httpParameters.putAll(OAuth.decodeForm(string.substring(n + 1)), true);
        }
    }

    protected String generateTimestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    protected String generateNonce() {
        return Long.toString(new Random().nextLong());
    }
}

