/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tile {
    public static BufferedImage LOADING_IMAGE;
    public static BufferedImage ERROR_IMAGE;
    protected TileSource source;
    protected int xtile;
    protected int ytile;
    protected int zoom;
    protected BufferedImage image;
    protected String key;
    protected boolean loaded = false;
    protected boolean loading = false;
    protected boolean error = false;
    protected String error_message;
    protected Map<String, String> metadata;

    public Tile(TileSource tileSource, int n, int n2, int n3) {
        this.source = tileSource;
        this.xtile = n;
        this.ytile = n2;
        this.zoom = n3;
        this.image = LOADING_IMAGE;
        this.key = Tile.getTileKey(tileSource, n, n2, n3);
    }

    public Tile(TileSource tileSource, int n, int n2, int n3, BufferedImage bufferedImage) {
        this(tileSource, n, n2, n3);
        this.image = bufferedImage;
    }

    public void loadPlaceholderFromCache(TileCache tileCache) {
        BufferedImage bufferedImage = new BufferedImage(this.source.getTileSize(), this.source.getTileSize(), 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        for (int i = 1; i < 5; ++i) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = this.zoom + i;
            if (i < 3 && n5 <= 22) {
                n4 = 1 << i;
                n3 = this.xtile << i;
                n2 = this.ytile << i;
                double d = 1.0 / (double)n4;
                graphics2D.setTransform(AffineTransform.getScaleInstance(d, d));
                int n6 = 0;
                for (int j = 0; j < n4; ++j) {
                    for (n = 0; n < n4; ++n) {
                        Tile tile = tileCache.getTile(this.source, n3 + j, n2 + n, n5);
                        if (tile == null || !tile.isLoaded()) continue;
                        ++n6;
                        tile.paint(graphics2D, j * this.source.getTileSize(), n * this.source.getTileSize());
                    }
                }
                if (n6 == n4 * n4) {
                    this.image = bufferedImage;
                    return;
                }
            }
            if ((n4 = this.zoom - i) < 0) continue;
            n3 = this.xtile >> i;
            n2 = this.ytile >> i;
            int n7 = 1 << i;
            double d = n7;
            AffineTransform affineTransform = new AffineTransform();
            n = this.xtile % n7 * this.source.getTileSize();
            int n8 = this.ytile % n7 * this.source.getTileSize();
            affineTransform.setTransform(d, 0.0, 0.0, d, -n, -n8);
            graphics2D.setTransform(affineTransform);
            Tile tile = tileCache.getTile(this.source, n3, n2, n4);
            if (tile == null || !tile.isLoaded()) continue;
            tile.paint(graphics2D, 0, 0);
            this.image = bufferedImage;
            return;
        }
    }

    public TileSource getSource() {
        return this.source;
    }

    public int getXtile() {
        return this.xtile;
    }

    public int getYtile() {
        return this.ytile;
    }

    public int getZoom() {
        return this.zoom;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public void loadImage(InputStream inputStream) throws IOException {
        this.image = ImageIO.read(inputStream);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public String getUrl() throws IOException {
        return this.source.getTileUrl(this.zoom, this.xtile, this.ytile);
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (this.image == null) {
            return;
        }
        graphics.drawImage(this.image, n, n2, null);
    }

    public String toString() {
        return "Tile " + this.key;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.xtile;
        n = 31 * n + this.ytile;
        n = 31 * n + this.zoom;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Tile tile = (Tile)object;
        if (this.xtile != tile.xtile) {
            return false;
        }
        if (this.ytile != tile.ytile) {
            return false;
        }
        return this.zoom == tile.zoom;
    }

    public static String getTileKey(TileSource tileSource, int n, int n2, int n3) {
        return n3 + "/" + n + "/" + n2 + "@" + tileSource.getName();
    }

    public String getStatus() {
        if (this.error) {
            return "error";
        }
        if (this.loaded) {
            return "loaded";
        }
        if (this.loading) {
            return "loading";
        }
        return "new";
    }

    public boolean hasError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.error_message;
    }

    public void setError(String string) {
        this.error = true;
        this.setImage(ERROR_IMAGE);
        this.error_message = string;
    }

    public void putValue(String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            if (this.metadata != null) {
                this.metadata.remove(string);
            }
            return;
        }
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(string, string2);
    }

    public String getValue(String string) {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.get(string);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void initLoading() {
        this.loaded = false;
        this.error = false;
        this.loading = true;
    }

    public void finishLoading() {
        this.loading = false;
        this.loaded = true;
    }

    static {
        try {
            LOADING_IMAGE = ImageIO.read(JMapViewer.class.getResourceAsStream("images/hourglass.png"));
            ERROR_IMAGE = ImageIO.read(JMapViewer.class.getResourceAsStream("images/error.png"));
        }
        catch (Exception exception) {
            LOADING_IMAGE = null;
            ERROR_IMAGE = null;
        }
    }
}

