/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.io.IOException;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTileSource;

public abstract class AbstractTMSTileSource
extends AbstractTileSource {
    protected String name;
    protected String baseUrl;

    public AbstractTMSTileSource(String string, String string2) {
        this.name = string;
        this.baseUrl = string2;
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getMaxZoom() {
        return 21;
    }

    public int getMinZoom() {
        return 0;
    }

    public String getExtension() {
        return "png";
    }

    public String getTilePath(int n, int n2, int n3) throws IOException {
        return "/" + n + "/" + n2 + "/" + n3 + "." + this.getExtension();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getTileUrl(int n, int n2, int n3) throws IOException {
        return this.getBaseUrl() + this.getTilePath(n, n2, n3);
    }

    public String toString() {
        return this.getName();
    }

    public String getTileType() {
        return "png";
    }

    public int getTileSize() {
        return 256;
    }

    public double latToTileY(double d, int n) {
        double d2 = d / 180.0 * Math.PI;
        double d3 = Math.log(Math.tan(d2) + 1.0 / Math.cos(d2));
        return Math.pow(2.0, n - 1) * (Math.PI - d3) / Math.PI;
    }

    public double lonToTileX(double d, int n) {
        return Math.pow(2.0, n - 3) * (d + 180.0) / 45.0;
    }

    public double tileYToLat(int n, int n2) {
        return Math.atan(Math.sinh(Math.PI - Math.PI * (double)n / Math.pow(2.0, n2 - 1))) * 180.0 / Math.PI;
    }

    public double tileXToLon(int n, int n2) {
        return (double)n * 45.0 / Math.pow(2.0, n2 - 3) - 180.0;
    }
}

