/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AdaptableAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.actionsupport.AlignImageryPanel;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.preferences.imagery.WMSLayerTree;
import org.openstreetmap.josm.io.imagery.WMSImagery;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AddImageryLayerAction
extends JosmAction
implements AdaptableAction {
    private static final int MAX_ICON_SIZE = 24;
    private final ImageryInfo info;

    public AddImageryLayerAction(ImageryInfo imageryInfo) {
        super(imageryInfo.getMenuName(), "imagery_menu", I18n.tr("Add imagery layer {0}", imageryInfo.getName()), null, false, false);
        this.putValue("toolbar", "imagery_" + imageryInfo.getToolbarName());
        this.info = imageryInfo;
        this.installAdapters();
        try {
            ImageIcon imageIcon;
            if (imageryInfo.getIcon() != null && (imageIcon = new ImageProvider(imageryInfo.getIcon()).setOptional(true).setMaxHeight(24).setMaxWidth(24).get()) != null) {
                this.putValue("SmallIcon", imageIcon);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            ImageryInfo imageryInfo;
            ImageryInfo imageryInfo2 = imageryInfo = ImageryInfo.ImageryType.WMS_ENDPOINT.equals((Object)this.info.getImageryType()) ? this.getWMSLayerInfo() : this.info;
            if (imageryInfo != null) {
                Main.main.addLayer(ImageryLayer.create(imageryInfo));
                AlignImageryPanel.addNagPanelIfNeeded();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage() == null || illegalArgumentException.getMessage().isEmpty()) {
                throw illegalArgumentException;
            }
            JOptionPane.showMessageDialog(Main.parent, illegalArgumentException.getMessage(), I18n.tr("Error", new Object[0]), 0);
        }
    }

    protected ImageryInfo getWMSLayerInfo() {
        try {
            assert (ImageryInfo.ImageryType.WMS_ENDPOINT.equals((Object)this.info.getImageryType()));
            WMSImagery wMSImagery = new WMSImagery();
            wMSImagery.attemptGetCapabilities(this.info.getUrl());
            System.out.println(wMSImagery.getLayers());
            final WMSLayerTree wMSLayerTree = new WMSLayerTree();
            wMSLayerTree.updateTree(wMSImagery);
            if (1 != new ExtendedDialog(Main.parent, I18n.tr("Select WMS layers", new Object[0]), new String[]{I18n.tr("Add layers", new Object[0]), I18n.tr("Cancel", new Object[0])}){
                {
                    super(component, string, stringArray);
                    JScrollPane jScrollPane = new JScrollPane(wMSLayerTree.getLayerTree());
                    this.setContent(jScrollPane);
                    jScrollPane.setPreferredSize(new Dimension(400, 400));
                }
            }.showDialog().getValue()) {
                return null;
            }
            String string = wMSImagery.buildGetMapUrl(wMSLayerTree.getSelectedLayers());
            return new ImageryInfo(this.info.getName(), string, "wms", this.info.getEulaAcceptanceRequired(), this.info.getCookies());
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Invalid service URL.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not retrieve WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
        }
        catch (WMSImagery.WMSGetCapabilitiesException wMSGetCapabilitiesException) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not parse WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
            System.err.println("Could not parse WMS layer list. Incoming data:");
            System.err.println(wMSGetCapabilitiesException.getIncomingData());
        }
        return null;
    }

    protected boolean isLayerAlreadyPresent() {
        if (Main.isDisplayingMapView()) {
            for (ImageryLayer imageryLayer : Main.map.mapView.getLayersOfType(ImageryLayer.class)) {
                if (!this.info.equals(imageryLayer.getInfo())) continue;
                return true;
            }
        }
        return false;
    }

    protected void updateEnabledState() {
        if (this.info.isBlacklisted()) {
            this.setEnabled(false);
        } else if (this.info.getImageryType() == ImageryInfo.ImageryType.TMS || this.info.getImageryType() == ImageryInfo.ImageryType.BING || this.info.getImageryType() == ImageryInfo.ImageryType.SCANEX) {
            this.setEnabled(true);
        } else if (Main.isDisplayingMapView() && !Main.map.mapView.getAllLayers().isEmpty()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

