/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class DialogsToggleAction
extends JosmAction {
    private final List<ButtonModel> buttonModels = new ArrayList<ButtonModel>();
    private boolean selected;

    public DialogsToggleAction() {
        super(I18n.tr("Toggle dialogs panel", new Object[0]), (Icon)null, I18n.tr("Toggle dialogs panel, maximize mapview", new Object[0]), Shortcut.registerShortcut("menu:view:dialogspanel", I18n.tr("Toggle dialogs panel", new Object[0]), 9, 5003), true, "dialogspanel", false);
        this.putValue("help", HelpUtil.ht("/Action/ToggleDialogsPanel"));
        this.selected = Main.pref.getBoolean("draw.dialogspanel", true);
        this.notifySelectedState();
    }

    public void addButtonModel(ButtonModel buttonModel) {
        if (buttonModel != null && !this.buttonModels.contains(buttonModel)) {
            this.buttonModels.add(buttonModel);
        }
    }

    public void removeButtonModel(ButtonModel buttonModel) {
        if (buttonModel != null && this.buttonModels.contains(buttonModel)) {
            this.buttonModels.remove(buttonModel);
        }
    }

    protected void notifySelectedState() {
        for (ButtonModel buttonModel : this.buttonModels) {
            if (buttonModel.isSelected() == this.selected) continue;
            buttonModel.setSelected(this.selected);
        }
    }

    protected void toggleSelectedState() {
        this.selected = !this.selected;
        Main.pref.put("draw.dialogspanel", this.selected);
        this.notifySelectedState();
        this.setMode();
    }

    public void initial() {
        if (this.selected) {
            this.setMode();
        }
    }

    protected void setMode() {
        if (Main.isDisplayingMapView()) {
            Main.map.setDialogsPanelVisible(this.selected);
            Main.map.statusLine.setVisible(this.selected || Main.pref.getBoolean("statusbar.always-visible", true));
            Main.toolbar.control.setVisible(this.selected || Main.pref.getBoolean("toolbar.always-visible", true));
            Main.main.menu.setVisible(this.selected || Main.pref.getBoolean("menu.always-visible", true));
            if (!Main.pref.getBoolean("sidetoolbar.always-visible", true)) {
                Main.pref.put("sidetoolbar.visible", this.selected);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.toggleSelectedState();
    }
}

