/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SelectMembersAction
extends AbstractRelationAction {
    private final boolean add;

    public SelectMembersAction(boolean bl) {
        this.putValue("ShortDescription", bl ? I18n.tr("Add the members of all selected relations to current selection", new Object[0]) : I18n.tr("Select the members of all selected relations", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("selectall"));
        this.putValue("Name", bl ? I18n.tr("Select members (add)", new Object[0]) : I18n.tr("Select members", new Object[0]));
        this.add = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled() || this.relations.isEmpty() || Main.map == null || Main.map.mapView == null) {
            return;
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (Relation relation : this.relations) {
            hashSet.addAll(relation.getMemberPrimitives());
        }
        if (this.add) {
            Main.map.mapView.getEditLayer().data.addSelected(hashSet);
        } else {
            Main.map.mapView.getEditLayer().data.setSelected(hashSet);
        }
    }
}

