/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class TurnrestrictionTest
extends Test {
    protected static final int NO_VIA = 1801;
    protected static final int NO_FROM = 1802;
    protected static final int NO_TO = 1803;
    protected static final int MORE_VIA = 1804;
    protected static final int MORE_FROM = 1805;
    protected static final int MORE_TO = 1806;
    protected static final int UNKNOWN_ROLE = 1807;
    protected static final int UNKNOWN_TYPE = 1808;
    protected static final int FROM_VIA_NODE = 1809;
    protected static final int TO_VIA_NODE = 1810;
    protected static final int FROM_VIA_WAY = 1811;
    protected static final int TO_VIA_WAY = 1812;
    protected static final int MIX_VIA = 1813;
    protected static final int UNCONNECTED_VIA = 1814;
    protected static final int SUPERFLUOUS = 1815;

    public TurnrestrictionTest() {
        super(I18n.tr("Turnrestrictions", new Object[0]), I18n.tr("This test checks if turnrestrictions are valid", new Object[0]));
    }

    public void visit(Relation relation) {
        Object object;
        if (!"restriction".equals(relation.get("type"))) {
            return;
        }
        OsmPrimitive osmPrimitive = null;
        Way way = null;
        ArrayList<Way> arrayList = new ArrayList<Way>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (RelationMember primitiveId2 : relation.getMembers()) {
            OsmPrimitive osmPrimitive2;
            if (primitiveId2.getMember().isIncomplete()) {
                return;
            }
            object = new ArrayList<OsmPrimitive>();
            ((ArrayList)object).add(relation);
            ((ArrayList)object).add(primitiveId2.getMember());
            if (primitiveId2.isWay()) {
                osmPrimitive2 = primitiveId2.getWay();
                if (osmPrimitive2.getNodesCount() < 2) continue;
                if ("from".equals(primitiveId2.getRole())) {
                    if (osmPrimitive != null) {
                        bl = true;
                        continue;
                    }
                    osmPrimitive = osmPrimitive2;
                    continue;
                }
                if ("to".equals(primitiveId2.getRole())) {
                    if (way != null) {
                        bl2 = true;
                        continue;
                    }
                    way = osmPrimitive2;
                    continue;
                }
                if ("via".equals(primitiveId2.getRole())) {
                    if (!arrayList.isEmpty() && arrayList.get(0) instanceof Node) {
                        bl4 = true;
                        continue;
                    }
                    arrayList.add((Way)osmPrimitive2);
                    continue;
                }
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Unknown role", new Object[0]), 1807, (Collection<? extends OsmPrimitive>)object, Collections.singletonList(primitiveId2)));
                continue;
            }
            if (primitiveId2.isNode()) {
                osmPrimitive2 = primitiveId2.getNode();
                if ("via".equals(primitiveId2.getRole())) {
                    if (!arrayList.isEmpty()) {
                        if (arrayList.get(0) instanceof Node) {
                            bl3 = true;
                            continue;
                        }
                        bl4 = true;
                        continue;
                    }
                    arrayList.add((Way)osmPrimitive2);
                    continue;
                }
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Unknown role", new Object[0]), 1807, (Collection<? extends OsmPrimitive>)object, (Collection<?>)Collections.singletonList(primitiveId2)));
                continue;
            }
            this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Unknown member type", new Object[0]), 1808, (Collection<? extends OsmPrimitive>)object, (Collection<?>)Collections.singletonList(primitiveId2)));
        }
        if (bl) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("More than one \"from\" way found", new Object[0]), 1805, relation));
        }
        if (bl2) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("More than one \"to\" way found", new Object[0]), 1806, relation));
        }
        if (bl3) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("More than one \"via\" node found", new Object[0]), 1804, relation));
        }
        if (bl4) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Cannot mix node and way for role \"via\"", new Object[0]), 1813, relation));
        }
        if (osmPrimitive == null) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("No \"from\" way found", new Object[0]), 1802, relation));
            return;
        }
        if (way == null) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("No \"to\" way found", new Object[0]), 1803, relation));
            return;
        }
        if (arrayList.isEmpty()) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("No \"via\" node or way found", new Object[0]), 1801, relation));
            return;
        }
        if (arrayList.get(0) instanceof Node) {
            Node node = (Node)arrayList.get(0);
            Way way2 = new Way();
            way2.addNode(node);
            this.checkIfConnected((Way)osmPrimitive, way2, I18n.tr("The \"from\" way does not start or end at a \"via\" node", new Object[0]), 1809);
            if (way.isOneway() != 0 && node.equals(way.lastNode(true))) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Superfluous turnrestriction as \"to\" way is oneway", new Object[0]), 1815, relation));
                return;
            }
            this.checkIfConnected(way2, way, I18n.tr("The \"to\" way does not start or end at a \"via\" node", new Object[0]), 1810);
        } else {
            this.checkIfConnected((Way)osmPrimitive, (Way)arrayList.get(0), I18n.tr("The \"from\" and the first \"via\" way are not connected.", new Object[0]), 1811);
            if (arrayList.size() > 1) {
                for (int i = 1; i < arrayList.size(); ++i) {
                    Way way3 = (Way)arrayList.get(i - 1);
                    object = (Way)arrayList.get(i);
                    this.checkIfConnected(way3, (Way)object, I18n.tr("The \"via\" ways are not connected.", new Object[0]), 1814);
                }
            }
            if (way.isOneway() != 0 && ((Way)arrayList.get(arrayList.size() - 1)).isFirstLastNode(way.lastNode(true))) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Superfluous turnrestriction as \"to\" way is oneway", new Object[0]), 1815, relation));
                return;
            }
            this.checkIfConnected((Way)arrayList.get(arrayList.size() - 1), way, I18n.tr("The last \"via\" and the \"to\" way are not connected.", new Object[0]), 1812);
        }
    }

    private void checkIfConnected(Way way, Way way2, String string, int n) {
        boolean bl;
        if (way.isOneway() != 0 && way2.isOneway() != 0) {
            bl = way.lastNode(true).equals(way2.firstNode(true));
        } else if (way.isOneway() != 0) {
            bl = way2.isFirstLastNode(way.lastNode(true));
        } else if (way2.isOneway() != 0) {
            bl = way.isFirstLastNode(way2.firstNode(true));
        } else {
            boolean bl2 = bl = way2.isFirstLastNode(way.firstNode()) || way2.isFirstLastNode(way.lastNode());
        }
        if (!bl) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, string, n, Arrays.asList(way, way2)));
        }
    }
}

