/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class BookmarkList
extends JList {
    public BookmarkList() {
        this.setModel(new DefaultListModel());
        this.load();
        this.setVisibleRowCount(7);
        this.setCellRenderer(new BookmarkCellRenderer());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load() {
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        defaultListModel.removeAllElements();
        Collection<Collection<String>> collection = Main.pref.getArray("bookmarks", null);
        if (collection != null) {
            LinkedList<Bookmark> linkedList = new LinkedList<Bookmark>();
            for (Collection<String> collection2 : collection) {
                try {
                    linkedList.add(new Bookmark(collection2));
                }
                catch (Exception exception) {
                    System.err.println(I18n.tr("Error reading bookmark entry: %s", exception.getMessage()));
                }
            }
            Collections.sort(linkedList);
            for (Bookmark bookmark : linkedList) {
                defaultListModel.addElement(bookmark);
            }
            return;
        } else {
            if (Main.applet) return;
            File file = new File(Main.pref.getPreferencesDir(), "bookmarks");
            try {
                LinkedList<Bookmark> linkedList = new LinkedList<Bookmark>();
                if (!file.exists()) return;
                System.out.println("Try loading obsolete bookmarks file");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
                Object object = bufferedReader.readLine();
                while (object != null) {
                    Matcher matcher = Pattern.compile("^(.+)[,\u001e](-?\\d+.\\d+)[,\u001e](-?\\d+.\\d+)[,\u001e](-?\\d+.\\d+)[,\u001e](-?\\d+.\\d+)$").matcher((CharSequence)object);
                    if (!matcher.matches() || matcher.groupCount() != 5) {
                        System.err.println(I18n.tr("Error: Unexpected line ''{0}'' in bookmark file ''{1}''", object, file.toString()));
                    } else {
                        Bookmark bookmark = new Bookmark();
                        bookmark.setName(matcher.group(1));
                        double[] dArray = new double[4];
                        for (int i = 0; i < 4; ++i) {
                            try {
                                dArray[i] = Double.parseDouble(matcher.group(i + 2));
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.err.println(I18n.tr("Error: Illegal double value ''{0}'' on line ''{1}'' in bookmark file ''{2}''", matcher.group(i + 2), object, file.toString()));
                            }
                        }
                        bookmark.setArea(new Bounds(dArray));
                        linkedList.add(bookmark);
                    }
                    object = bufferedReader.readLine();
                }
                Utils.close(bufferedReader);
                Collections.sort(linkedList);
                for (Bookmark bookmark : linkedList) {
                    defaultListModel.addElement(bookmark);
                }
                this.save();
                System.out.println("Removing obsolete bookmarks file");
                file.delete();
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Could not read bookmarks from<br>''{0}''<br>Error was: {1}</html>", file.toString(), iOException.getMessage()), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    public void save() {
        LinkedList<Collection<String>> linkedList = new LinkedList<Collection<String>>();
        for (Object object : ((DefaultListModel)this.getModel()).toArray()) {
            String[] stringArray = new String[5];
            Bookmark bookmark = (Bookmark)object;
            stringArray[0] = bookmark.getName();
            Bounds bounds = bookmark.getArea();
            stringArray[1] = String.valueOf(bounds.getMin().lat());
            stringArray[2] = String.valueOf(bounds.getMin().lon());
            stringArray[3] = String.valueOf(bounds.getMax().lat());
            stringArray[4] = String.valueOf(bounds.getMax().lon());
            linkedList.add(Arrays.asList(stringArray));
        }
        Main.pref.putArray("bookmarks", linkedList);
    }

    static class BookmarkCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ImageIcon icon;

        public BookmarkCellRenderer() {
            this.setOpaque(true);
            this.icon = ImageProvider.get("dialogs", "bookmark");
            this.setIcon(this.icon);
        }

        protected void renderColor(boolean bl) {
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("List.background"));
                this.setForeground(UIManager.getColor("List.foreground"));
            }
        }

        protected String buildToolTipText(Bookmark bookmark) {
            Bounds bounds = bookmark.getArea();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>min[latitude,longitude]=<strong>[").append(bounds.getMin().lat()).append(",").append(bounds.getMin().lon()).append("]</strong>").append("<br>").append("max[latitude,longitude]=<strong>[").append(bounds.getMax().lat()).append(",").append(bounds.getMax().lon()).append("]</strong>").append("</html>");
            return stringBuffer.toString();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Bookmark bookmark = (Bookmark)object;
            this.renderColor(bl);
            this.setText(bookmark.getName());
            this.setToolTipText(this.buildToolTipText(bookmark));
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Bookmark
    implements Comparable<Bookmark> {
        private String name;
        private Bounds area;

        public Bookmark(Collection<String> collection) throws NumberFormatException, IllegalArgumentException {
            ArrayList<String> arrayList = new ArrayList<String>(collection);
            if (arrayList.size() < 5) {
                throw new IllegalArgumentException(I18n.tr("Wrong number of arguments for bookmark", new Object[0]));
            }
            this.name = arrayList.get(0);
            this.area = new Bounds(Double.parseDouble(arrayList.get(1)), Double.parseDouble(arrayList.get(2)), Double.parseDouble(arrayList.get(3)), Double.parseDouble(arrayList.get(4)));
        }

        public Bookmark() {
            this.area = null;
            this.name = null;
        }

        public Bookmark(Bounds bounds) {
            this.area = bounds;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Bookmark bookmark) {
            return this.name.toLowerCase().compareTo(bookmark.name.toLowerCase());
        }

        public Bounds getArea() {
            return this.area;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setArea(Bounds bounds) {
            this.area = bounds;
        }
    }
}

